/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StackTraceElementObjectRenderer
extends CompoundReferenceRenderer
implements FullValueEvaluatorProvider {
    private static final Logger LOG = Logger.getInstance(StackTraceElementObjectRenderer.class);

    StackTraceElementObjectRenderer() {
        super("StackTraceElement", null, null);
        this.setClassName("java.lang.StackTraceElement");
        this.setEnabled(true);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(final EvaluationContextImpl evaluationContext, final ValueDescriptorImpl valueDescriptor) {
        return new JavaValue.JavaFullValueEvaluator(DebuggerBundle.message((String)"message.node.navigate", (Object[])new Object[0]), evaluationContext){

            @Override
            public void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                Value value2;
                ClassType type2;
                Method toString;
                if (callback == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((toString = (type2 = (ClassType)(value2 = valueDescriptor.getValue()).type()).concreteMethodByName("toString", "()Ljava/lang/String;")) != null) {
                    try {
                        Value res = evaluationContext.getDebugProcess().invokeMethod((EvaluationContext)evaluationContext, (ObjectReference)value2, toString, Collections.emptyList());
                        if (res instanceof StringReference) {
                            callback.evaluated("");
                            String line = ((StringReference)res).value();
                            ApplicationManager.getApplication().runReadAction(() -> {
                                HyperlinkInfo info;
                                ExceptionFilter filter = new ExceptionFilter(evaluationContext.getDebugProcess().getSession().getSearchScope());
                                Filter.Result result = filter.applyFilter(line, line.length());
                                if (result != null && (info = result.getFirstHyperlinkInfo()) != null) {
                                    DebuggerUIUtil.invokeLater(() -> info.navigate(valueDescriptor.getProject()));
                                }
                            });
                        }
                    }
                    catch (EvaluateException e) {
                        LOG.info("Exception while getting stack info", (Throwable)e);
                    }
                }
            }

            public boolean isShowValuePopup() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/ui/tree/render/StackTraceElementObjectRenderer$1", "evaluate"));
            }
        };
    }
}

