/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.TypeRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.sun.jdi.Value;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LabelRenderer
extends TypeRenderer
implements ValueLabelRenderer,
OnDemandRenderer {
    @NonNls
    public static final String UNIQUE_ID = "LabelRenderer";
    public boolean ON_DEMAND;
    private CachedEvaluator myLabelExpression = this.createCachedEvaluator();

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public LabelRenderer clone() {
        LabelRenderer clone = (LabelRenderer)super.clone();
        clone.myLabelExpression = this.createCachedEvaluator();
        clone.setLabelExpression(this.getLabelExpression());
        return clone;
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
        String result;
        if (!this.isShowValue(descriptor, evaluationContext)) {
            return "";
        }
        Value value2 = descriptor.getValue();
        DebugProcess debugProcess = evaluationContext.getDebugProcess();
        if (value2 != null) {
            try {
                ExpressionEvaluator evaluator = this.myLabelExpression.getEvaluator(debugProcess.getProject());
                if (!debugProcess.isAttached()) {
                    throw EvaluateExceptionUtil.PROCESS_EXITED;
                }
                EvaluationContext thisEvaluationContext = evaluationContext.createEvaluationContext(value2);
                Value labelValue = evaluator.evaluate(thisEvaluationContext);
                result = DebuggerUtils.getValueAsString((EvaluationContext)thisEvaluationContext, (Value)labelValue);
            }
            catch (EvaluateException ex) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + ex.getMessage(), (Throwable)ex);
            }
        } else {
            result = "null";
        }
        return result;
    }

    @Override
    @NotNull
    public String getLinkText() {
        String string = "\u2026 " + this.getLabelExpression().getText();
        if (string == null) {
            LabelRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        TextWithImports labelExpression = DebuggerUtils.getInstance().readTextWithImports(element, "LABEL_EXPRESSION");
        if (labelExpression != null) {
            this.setLabelExpression(labelExpression);
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        DebuggerUtils.getInstance().writeTextWithImports(element, "LABEL_EXPRESSION", this.getLabelExpression());
    }

    public TextWithImports getLabelExpression() {
        return this.myLabelExpression.getReferenceExpression();
    }

    public void setLabelExpression(TextWithImports expression2) {
        this.myLabelExpression.setReferenceExpression(expression2);
    }

    @Override
    public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
        return this.ON_DEMAND || OnDemandRenderer.super.isOnDemand(evaluationContext, valueDescriptor);
    }

    public boolean isOnDemand() {
        return this.ON_DEMAND;
    }

    public void setOnDemand(boolean value2) {
        this.ON_DEMAND = value2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/tree/render/LabelRenderer", "getLinkText"));
    }
}

