/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiType;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.Nullable;

public abstract class CachedEvaluator {
    SoftReference<Cache> myCache = new SoftReference(null);
    private TextWithImports myReferenceExpression;

    protected abstract String getClassName();

    public TextWithImports getReferenceExpression() {
        return this.myReferenceExpression != null ? this.myReferenceExpression : DebuggerUtils.getInstance().createExpressionWithImports("");
    }

    public void setReferenceExpression(TextWithImports referenceExpression) {
        this.myReferenceExpression = referenceExpression;
        this.clear();
    }

    public void clear() {
        this.myCache.clear();
    }

    protected Cache initEvaluatorAndChildrenExpression(Project project) {
        Cache cache;
        block6: {
            cache = new Cache();
            try {
                String className2 = this.getClassName();
                Pair<PsiElement, PsiType> psiClassAndType = DebuggerUtilsImpl.getPsiClassAndType(className2, project);
                PsiElement context = (PsiElement)psiClassAndType.first;
                if (context == null) {
                    throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.find.source", (Object[])new Object[]{className2}));
                }
                CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(this.myReferenceExpression, context);
                JavaCodeFragment codeFragment = factory.createCodeFragment(this.myReferenceExpression, this.overrideContext(context), project);
                codeFragment.setThisType((PsiType)psiClassAndType.second);
                DebuggerUtils.checkSyntax((PsiCodeFragment)codeFragment);
                cache.myPsiChildrenExpression = codeFragment instanceof PsiExpressionCodeFragment ? ((PsiExpressionCodeFragment)codeFragment).getExpression() : null;
                try {
                    cache.myEvaluator = factory.getEvaluatorBuilder().build((PsiElement)codeFragment, null);
                }
                catch (UnsupportedExpressionException ex) {
                    ExpressionEvaluator eval = CompilingEvaluatorImpl.create(project, context, element -> codeFragment);
                    if (eval != null) {
                        cache.myEvaluator = eval;
                        break block6;
                    }
                    throw ex;
                }
            }
            catch (EvaluateException e) {
                cache.myException = e;
            }
        }
        this.myCache = new SoftReference((Object)cache);
        return cache;
    }

    protected PsiElement overrideContext(PsiElement context) {
        return context;
    }

    protected ExpressionEvaluator getEvaluator(Project project) throws EvaluateException {
        Cache cache = (Cache)this.myCache.get();
        if (cache == null) {
            cache = (Cache)PsiDocumentManager.getInstance((Project)project).commitAndRunReadAction(() -> this.initEvaluatorAndChildrenExpression(project));
        }
        if (cache.myException != null) {
            throw cache.myException;
        }
        return cache.myEvaluator;
    }

    @Nullable
    protected PsiExpression getPsiExpression(Project project) {
        Cache cache = (Cache)this.myCache.get();
        if (cache == null) {
            cache = this.initEvaluatorAndChildrenExpression(project);
        }
        return cache.myPsiChildrenExpression;
    }

    private static class Cache {
        protected ExpressionEvaluator myEvaluator;
        protected EvaluateException myException;
        protected PsiExpression myPsiChildrenExpression;

        private Cache() {
        }
    }
}

