/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicRendererProperties
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.BasicRendererProperties");
    @NonNls
    private static final String NAME_OPTION = "NAME";
    private String myName;
    @NonNls
    private static final String ENABLED_OPTION = "ENABLED";
    private boolean myEnabled;
    @NonNls
    private static final String CLASSNAME_OPTION = "QUALIFIED_NAME";
    private String myClassName;
    @NonNls
    private static final String SHOW_TYPE_OPTION = "SHOW_TYPE";
    private boolean myShowType = true;
    private final boolean myEnabledDefaultValue;

    public BasicRendererProperties(boolean enabledDefaultValue) {
        this.myEnabledDefaultValue = enabledDefaultValue;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name2) {
        this.myName = name2;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public void setClassName(String className2) {
        this.myClassName = className2;
    }

    public boolean isShowType() {
        return this.myShowType;
    }

    public void setShowType(boolean showType) {
        this.myShowType = showType;
    }

    public void readExternal(@NotNull Element element, @Nullable String defaultName) {
        if (element == null) {
            BasicRendererProperties.$$$reportNull$$$0(0);
        }
        this.myName = null;
        this.myClassName = null;
        for (Element option : element.getChildren("option")) {
            String optionName;
            switch (optionName = option.getAttributeValue("name")) {
                case "NAME": {
                    this.myName = option.getAttributeValue("value");
                    break;
                }
                case "ENABLED": {
                    String value2 = option.getAttributeValue("value");
                    if (value2 == null) break;
                    this.myEnabled = Boolean.parseBoolean(value2);
                    break;
                }
                case "QUALIFIED_NAME": {
                    this.myClassName = option.getAttributeValue("value");
                    break;
                }
                case "SHOW_TYPE": {
                    this.myShowType = !"false".equalsIgnoreCase(option.getAttributeValue("value"));
                }
            }
        }
        if (this.myName == null) {
            this.myName = defaultName;
        }
    }

    public void writeExternal(@NotNull Element element, @Nullable String defaultName) {
        if (element == null) {
            BasicRendererProperties.$$$reportNull$$$0(1);
        }
        if (this.myName != null && !this.myName.equals(defaultName)) {
            JDOMExternalizerUtil.writeField((Element)element, (String)NAME_OPTION, (String)this.myName);
        }
        if (this.myEnabled != this.myEnabledDefaultValue) {
            JDOMExternalizerUtil.writeField((Element)element, (String)ENABLED_OPTION, (String)Boolean.toString(this.myEnabled));
        }
        if (this.myClassName != null) {
            JDOMExternalizerUtil.writeField((Element)element, (String)CLASSNAME_OPTION, (String)this.myClassName);
        }
        if (!this.myShowType) {
            JDOMExternalizerUtil.writeField((Element)element, (String)SHOW_TYPE_OPTION, (String)Boolean.toString(this.myShowType));
        }
    }

    public BasicRendererProperties clone() {
        try {
            return (BasicRendererProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/debugger/ui/tree/render/BasicRendererProperties";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

