/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.impl.descriptors.data.ArgValueData;
import com.intellij.debugger.impl.descriptors.data.ArrayItemData;
import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DescriptorKey;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.impl.descriptors.data.FieldData;
import com.intellij.debugger.impl.descriptors.data.LocalData;
import com.intellij.debugger.impl.descriptors.data.MethodReturnValueData;
import com.intellij.debugger.impl.descriptors.data.StackFrameData;
import com.intellij.debugger.impl.descriptors.data.StaticData;
import com.intellij.debugger.impl.descriptors.data.StaticFieldData;
import com.intellij.debugger.impl.descriptors.data.ThisData;
import com.intellij.debugger.impl.descriptors.data.ThreadData;
import com.intellij.debugger.impl.descriptors.data.ThreadGroupData;
import com.intellij.debugger.impl.descriptors.data.ThrownExceptionValueData;
import com.intellij.debugger.impl.descriptors.data.WatchItemData;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DescriptorTree;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MarkedDescriptorTree;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeDescriptorFactoryImpl
implements NodeDescriptorFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.NodeDescriptorFactoryImpl");
    private DescriptorTree myCurrentHistoryTree = new DescriptorTree(true);
    private DescriptorTreeSearcher myDescriptorSearcher;
    private DescriptorTreeSearcher myDisplayDescriptorSearcher;
    protected final Project myProject;

    public NodeDescriptorFactoryImpl(Project project) {
        this.myProject = project;
        this.myDescriptorSearcher = new DescriptorTreeSearcher(new MarkedDescriptorTree());
        this.myDisplayDescriptorSearcher = new DisplayDescriptorTreeSearcher(new MarkedDescriptorTree());
    }

    public void dispose() {
        this.myCurrentHistoryTree.clear();
        this.myDescriptorSearcher.clear();
        this.myDisplayDescriptorSearcher.clear();
    }

    @NotNull
    public <T extends NodeDescriptor> T getDescriptor(NodeDescriptor parent, DescriptorData<T> key2) {
        T descriptor = key2.createDescriptor(this.myProject);
        T oldDescriptor = this.findDescriptor(parent, descriptor, key2);
        if (oldDescriptor != null && oldDescriptor.getClass() == descriptor.getClass()) {
            descriptor.setAncestor(oldDescriptor);
        } else {
            T displayDescriptor = this.findDisplayDescriptor(parent, descriptor, key2.getDisplayKey());
            if (displayDescriptor != null) {
                descriptor.displayAs(displayDescriptor);
            }
        }
        this.myCurrentHistoryTree.addChild(parent, (NodeDescriptor)descriptor);
        T t = descriptor;
        if (t == null) {
            NodeDescriptorFactoryImpl.$$$reportNull$$$0(0);
        }
        return t;
    }

    @Nullable
    protected <T extends NodeDescriptor> T findDisplayDescriptor(NodeDescriptor parent, T descriptor, DisplayKey<T> key2) {
        return this.myDisplayDescriptorSearcher.search(parent, descriptor, key2);
    }

    @Nullable
    protected <T extends NodeDescriptor> T findDescriptor(NodeDescriptor parent, T descriptor, DescriptorData<T> key2) {
        return this.myDescriptorSearcher.search(parent, descriptor, key2);
    }

    public DescriptorTree getCurrentHistoryTree() {
        return this.myCurrentHistoryTree;
    }

    public void deriveHistoryTree(DescriptorTree tree, StackFrameContext context) {
        this.deriveHistoryTree(tree, context.getFrameProxy());
    }

    public void deriveHistoryTree(DescriptorTree tree, StackFrameProxy frameProxy) {
        final MarkedDescriptorTree descriptorTree = new MarkedDescriptorTree();
        final MarkedDescriptorTree displayDescriptorTree = new MarkedDescriptorTree();
        tree.dfst(new DescriptorTree.DFSTWalker(){

            @Override
            public void visit(NodeDescriptor parent, NodeDescriptor child) {
                DescriptorData<NodeDescriptor> descriptorData = DescriptorData.getDescriptorData(child);
                descriptorTree.addChild(parent, child, descriptorData);
                displayDescriptorTree.addChild(parent, child, descriptorData.getDisplayKey());
            }
        });
        this.myDescriptorSearcher = new DescriptorTreeSearcher(descriptorTree);
        this.myDisplayDescriptorSearcher = new DisplayDescriptorTreeSearcher(displayDescriptorTree);
        this.myCurrentHistoryTree = NodeDescriptorFactoryImpl.createDescriptorTree(frameProxy, tree);
    }

    private static DescriptorTree createDescriptorTree(StackFrameProxy frameProxy, DescriptorTree fromTree) {
        int frameCount = -1;
        int frameIndex = -1;
        if (frameProxy != null) {
            try {
                ThreadReferenceProxy threadReferenceProxy = frameProxy.threadProxy();
                frameCount = threadReferenceProxy.frameCount();
                frameIndex = frameProxy.getFrameIndex();
            }
            catch (EvaluateException threadReferenceProxy) {
                // empty catch block
            }
        }
        boolean isInitial = !fromTree.frameIdEquals(frameCount, frameIndex);
        DescriptorTree descriptorTree = new DescriptorTree(isInitial);
        descriptorTree.setFrameId(frameCount, frameIndex);
        return descriptorTree;
    }

    @Override
    public ArrayElementDescriptorImpl getArrayItemDescriptor(NodeDescriptor parent, ArrayReference array, int index) {
        return this.getDescriptor(parent, new ArrayItemData(array, index));
    }

    @Override
    @NotNull
    public FieldDescriptorImpl getFieldDescriptor(NodeDescriptor parent, ObjectReference objRef, Field field) {
        DescriptorData descriptorData;
        if (objRef == null) {
            if (!field.isStatic()) {
                LOG.error("Object reference is null for non-static field: " + field);
            }
            descriptorData = new StaticFieldData(field);
        } else {
            descriptorData = new FieldData(objRef, field);
        }
        FieldDescriptorImpl fieldDescriptorImpl = this.getDescriptor(parent, descriptorData);
        if (fieldDescriptorImpl == null) {
            NodeDescriptorFactoryImpl.$$$reportNull$$$0(1);
        }
        return fieldDescriptorImpl;
    }

    @Override
    public LocalVariableDescriptorImpl getLocalVariableDescriptor(NodeDescriptor parent, LocalVariableProxy local) {
        return this.getDescriptor(parent, new LocalData((LocalVariableProxyImpl)local));
    }

    public ArgumentValueDescriptorImpl getArgumentValueDescriptor(NodeDescriptor parent, DecompiledLocalVariable variable, Value value2) {
        return this.getDescriptor(parent, new ArgValueData(variable, value2));
    }

    public StackFrameDescriptorImpl getStackFrameDescriptor(@Nullable NodeDescriptorImpl parent, @NotNull StackFrameProxyImpl frameProxy) {
        if (frameProxy == null) {
            NodeDescriptorFactoryImpl.$$$reportNull$$$0(2);
        }
        return this.getDescriptor(parent, new StackFrameData(frameProxy));
    }

    public StaticDescriptorImpl getStaticDescriptor(NodeDescriptorImpl parent, ReferenceType refType) {
        return this.getDescriptor(parent, new StaticData(refType));
    }

    public ValueDescriptorImpl getThisDescriptor(NodeDescriptorImpl parent, Value value2) {
        return this.getDescriptor(parent, new ThisData());
    }

    public ValueDescriptorImpl getMethodReturnValueDescriptor(NodeDescriptorImpl parent, Method method, Value value2) {
        return this.getDescriptor(parent, new MethodReturnValueData(method, value2));
    }

    public ValueDescriptorImpl getThrownExceptionObjectDescriptor(NodeDescriptorImpl parent, ObjectReference exceptionObject) {
        return this.getDescriptor(parent, new ThrownExceptionValueData(exceptionObject));
    }

    public ThreadDescriptorImpl getThreadDescriptor(NodeDescriptorImpl parent, ThreadReferenceProxyImpl thread) {
        return this.getDescriptor(parent, new ThreadData(thread));
    }

    public ThreadGroupDescriptorImpl getThreadGroupDescriptor(NodeDescriptorImpl parent, ThreadGroupReferenceProxyImpl group) {
        return this.getDescriptor(parent, new ThreadGroupData(group));
    }

    @Override
    public UserExpressionDescriptor getUserExpressionDescriptor(NodeDescriptor parent, DescriptorData<UserExpressionDescriptor> data) {
        return this.getDescriptor(parent, data);
    }

    public WatchItemDescriptor getWatchItemDescriptor(NodeDescriptor parent, TextWithImports text2, @Nullable Value value2) {
        return this.getDescriptor(parent, new WatchItemData(text2, value2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/NodeDescriptorFactoryImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/NodeDescriptorFactoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStackFrameDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DisplayDescriptorTreeSearcher
    extends DescriptorTreeSearcher {
        DisplayDescriptorTreeSearcher(MarkedDescriptorTree descriptorTree) {
            super(descriptorTree);
        }

        @Override
        protected NodeDescriptor getSearched(NodeDescriptor parent) {
            NodeDescriptor searched = super.getSearched(parent);
            if (searched == null) {
                return NodeDescriptorFactoryImpl.this.myDescriptorSearcher.getSearched(parent);
            }
            return searched;
        }
    }

    private static class DescriptorTreeSearcher {
        private final MarkedDescriptorTree myDescriptorTree;
        private final HashMap<NodeDescriptor, NodeDescriptor> mySearchedDescriptors = new HashMap();

        DescriptorTreeSearcher(MarkedDescriptorTree descriptorTree) {
            this.myDescriptorTree = descriptorTree;
        }

        @Nullable
        public <T extends NodeDescriptor> T search(NodeDescriptor parent, T descriptor, DescriptorKey<T> key2) {
            T result;
            if (parent == null) {
                result = this.myDescriptorTree.getChild(null, key2);
            } else {
                NodeDescriptor parentDescriptor = this.getSearched(parent);
                result = parentDescriptor != null ? this.myDescriptorTree.getChild(parentDescriptor, key2) : null;
                Object v0 = result;
            }
            if (result != null) {
                this.mySearchedDescriptors.put(descriptor, (NodeDescriptor)result);
            }
            return result;
        }

        protected NodeDescriptor getSearched(NodeDescriptor parent) {
            return this.mySearchedDescriptors.get(parent);
        }

        public void clear() {
            this.mySearchedDescriptors.clear();
            this.myDescriptorTree.clear();
        }
    }
}

