/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.SmartHashSet;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeNodeExpression {
    public static final Key<Set<String>> ADDITIONAL_IMPORTS_KEY = Key.create((String)"ADDITIONAL_IMPORTS");

    @Nullable
    public static PsiExpression substituteThis(@Nullable PsiElement expressionWithThis, PsiExpression howToEvaluateThis, Value howToEvaluateThisValue) throws EvaluateException {
        PsiExpression psiExpression;
        PsiType type2;
        if (!(expressionWithThis instanceof PsiExpression)) {
            return null;
        }
        PsiExpression result = (PsiExpression)expressionWithThis.copy();
        PsiClass thisClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)result, PsiClass.class, (boolean)true);
        boolean castNeeded = true;
        if (thisClass != null && (type2 = howToEvaluateThis.getType()) != null) {
            if (type2 instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)type2).resolve();
                if (psiClass != null && (psiClass == thisClass || psiClass.isInheritor(thisClass, true))) {
                    castNeeded = false;
                }
            } else if (type2 instanceof PsiArrayType && PsiUtil.isArrayClass((PsiElement)thisClass)) {
                castNeeded = false;
            }
        }
        if (castNeeded) {
            howToEvaluateThis = DebuggerTreeNodeExpression.castToRuntimeType(howToEvaluateThis, howToEvaluateThisValue);
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)result, false);
        try {
            psiExpression = (PsiExpression)ChangeContextUtil.decodeContextInfo((PsiElement)result, thisClass, howToEvaluateThis);
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"evaluation.error.invalid.this.expression", (Object[])new Object[]{result.getText(), howToEvaluateThis.getText()}), null);
        }
        try {
            PsiExpression res = JavaPsiFacade.getElementFactory((Project)howToEvaluateThis.getProject()).createExpressionFromText(psiExpression.getText(), howToEvaluateThis.getContext());
            res.putUserData(ADDITIONAL_IMPORTS_KEY, howToEvaluateThis.getUserData(ADDITIONAL_IMPORTS_KEY));
            return res;
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(e.getMessage(), (Throwable)e);
        }
    }

    public static PsiExpression castToRuntimeType(PsiExpression expression2, Value value2) throws EvaluateException {
        if (!(value2 instanceof ObjectReference)) {
            return expression2;
        }
        ReferenceType valueType = ((ObjectReference)value2).referenceType();
        if (valueType == null) {
            return expression2;
        }
        Project project = expression2.getProject();
        PsiType type2 = RuntimeTypeEvaluator.getCastableRuntimeType(project, value2);
        if (type2 == null) {
            return expression2;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        String typeName = type2.getCanonicalText();
        try {
            PsiParenthesizedExpression parenthExpression = (PsiParenthesizedExpression)elementFactory.createExpressionFromText("((" + typeName + ")expression)", null);
            ((PsiTypeCastExpression)parenthExpression.getExpression()).getOperand().replace((PsiElement)expression2);
            Set imports2 = (Set)expression2.getUserData(ADDITIONAL_IMPORTS_KEY);
            if (imports2 == null) {
                imports2 = new SmartHashSet();
            }
            imports2.add(typeName);
            parenthExpression.putUserData(ADDITIONAL_IMPORTS_KEY, (Object)imports2);
            return parenthExpression;
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.type.name", (Object[])new Object[]{typeName}), (Throwable)e);
        }
    }

    public static String normalize(String qualifiedName, PsiElement contextElement, Project project) {
        if (contextElement == null) {
            return qualifiedName;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass aClass = facade.findClass(qualifiedName, GlobalSearchScope.allScope((Project)project));
        if (aClass != null) {
            return DebuggerTreeNodeExpression.normalizePsiClass(aClass, contextElement, facade.getResolveHelper());
        }
        return qualifiedName;
    }

    private static String normalizePsiClass(PsiClass psiClass, PsiElement contextElement, PsiResolveHelper helper) {
        String name2 = psiClass.getName();
        PsiClass aClass = helper.resolveReferencedClass(name2, contextElement);
        if (psiClass.equals(aClass)) {
            return name2;
        }
        PsiClass parentClass = psiClass.getContainingClass();
        if (parentClass != null) {
            return DebuggerTreeNodeExpression.normalizePsiClass(parentClass, contextElement, helper) + "." + name2;
        }
        return psiClass.getQualifiedName();
    }
}

