/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.server.BuildManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluator;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import com.intellij.util.lang.JavaVersion;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class CompilingEvaluatorImpl
extends CompilingEvaluator {
    private Collection<ClassObject> myCompiledClasses;
    private final Module myModule;

    public CompilingEvaluatorImpl(@NotNull Project project, @NotNull PsiElement context, @NotNull ExtractLightMethodObjectHandler.ExtractedData data) {
        if (project == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(1);
        }
        if (data == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(2);
        }
        super(project, context, data);
        this.myModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
    }

    @Override
    @NotNull
    protected Collection<ClassObject> compile(@Nullable JavaSdkVersion debuggeeVersion) throws EvaluateException {
        if (this.myCompiledClasses == null) {
            ArrayList<String> options = new ArrayList<String>();
            options.add("-encoding");
            options.add("UTF-8");
            ArrayList<File> platformClasspath = new ArrayList<File>();
            ArrayList<File> classpath = new ArrayList<File>();
            AnnotationProcessingConfiguration profile = null;
            if (this.myModule != null) {
                assert (this.myProject.equals(this.myModule.getProject())) : this.myModule + " is from another project";
                profile = CompilerConfiguration.getInstance((Project)this.myProject).getAnnotationProcessingConfiguration(this.myModule);
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
                for (String s : rootManager.orderEntries().compileOnly().recursively().exportedOnly().withoutSdk().getPathsList().getPathList()) {
                    classpath.add(new File(s));
                }
                for (String s : rootManager.orderEntries().compileOnly().sdkOnly().getPathsList().getPathList()) {
                    platformClasspath.add(new File(s));
                }
            }
            JavaBuilder.addAnnotationProcessingOptions(options, profile, (boolean)false);
            Pair<Sdk, JavaSdkVersion> runtime = BuildManager.getJavacRuntimeSdk(this.myProject);
            JavaSdkVersion buildRuntimeVersion = (JavaSdkVersion)runtime.getSecond();
            if (buildRuntimeVersion != null && debuggeeVersion != null) {
                JavaSdkVersion minVersion = debuggeeVersion.compareTo((Enum)buildRuntimeVersion) < 0 ? debuggeeVersion : buildRuntimeVersion;
                String sourceOption = JpsJavaSdkType.complianceOption((JavaVersion)minVersion.getMaxLanguageLevel().toJavaVersion());
                options.add("-source");
                options.add(sourceOption);
                options.add("-target");
                options.add(sourceOption);
            }
            CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
            File sourceFile = null;
            try {
                sourceFile = this.generateTempSourceFile(compilerManager.getJavacCompilerWorkingDir());
                File srcDir = sourceFile.getParentFile();
                List sourcePath = Collections.emptyList();
                Set<File> sources = Collections.singleton(sourceFile);
                this.myCompiledClasses = compilerManager.compileJavaCode(options, platformClasspath, classpath, Collections.emptyList(), Collections.emptyList(), sourcePath, sources, srcDir);
            }
            catch (CompilationException e) {
                StringBuilder res = new StringBuilder("Compilation failed:\n");
                for (CompilationException.Message m : e.getMessages()) {
                    if (m.getCategory() != CompilerMessageCategory.ERROR) continue;
                    res.append(m.getText()).append("\n");
                }
                throw new EvaluateException(res.toString());
            }
            catch (Exception e) {
                throw new EvaluateException(e.getMessage());
            }
            finally {
                if (sourceFile != null) {
                    FileUtil.delete((File)sourceFile);
                }
            }
        }
        Collection<ClassObject> collection = this.myCompiledClasses;
        if (collection == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private File generateTempSourceFile(File workingDir) throws IOException {
        Pair fileData = (Pair)ReadAction.compute(() -> {
            PsiFile file = this.myData.getGeneratedInnerClass().getContainingFile();
            return Pair.create((Object)file.getName(), (Object)file.getText());
        });
        if (fileData.first == null) {
            throw new IOException("Class file name not specified");
        }
        if (fileData.second == null) {
            throw new IOException("Class source code not specified");
        }
        File file = new File(workingDir, "debugger/src/" + (String)fileData.first);
        FileUtil.writeToFile((File)file, (String)((String)fileData.second));
        return file;
    }

    @Nullable
    public static ExpressionEvaluator create(@NotNull Project project, @Nullable PsiElement psiContext, @NotNull Function<? super PsiElement, ? extends PsiCodeFragment> fragmentFactory) throws EvaluateException {
        if (project == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(4);
        }
        if (fragmentFactory == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(5);
        }
        if (Registry.is((String)"debugger.compiling.evaluator") && psiContext != null) {
            return (ExpressionEvaluator)ApplicationManager.getApplication().runReadAction(() -> {
                try {
                    XDebugSession currentSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
                    JavaSdkVersion javaVersion = CompilingEvaluatorImpl.getJavaVersion(currentSession);
                    ExtractLightMethodObjectHandler.ExtractedData data = ExtractLightMethodObjectHandler.extractLightMethodObject(project, CompilingEvaluatorImpl.findPhysicalContext(psiContext), (PsiCodeFragment)fragmentFactory.apply(psiContext), CompilingEvaluatorImpl.getGeneratedClassName(), javaVersion);
                    if (data != null) {
                        return new CompilingEvaluatorImpl(project, psiContext, data);
                    }
                }
                catch (PrepareFailedException e) {
                    NodeDescriptorImpl.LOG.info((Throwable)e);
                }
                return null;
            });
        }
        return null;
    }

    @NotNull
    private static PsiElement findPhysicalContext(@NotNull PsiElement element) {
        PsiElement context;
        if (element == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(6);
        }
        while (!element.isPhysical() && (context = element.getContext()) != null) {
            element = context;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @Nullable
    public static JavaSdkVersion getJavaVersion(@Nullable XDebugSession session) {
        XSuspendContext suspendContext;
        if (session != null && (suspendContext = session.getSuspendContext()) instanceof SuspendContextImpl) {
            DebugProcessImpl debugProcess = ((SuspendContextImpl)suspendContext).getDebugProcess();
            return JavaSdkVersion.fromVersionString((String)debugProcess.getVirtualMachineProxy().version());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findPhysicalContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPhysicalContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

