/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PatternUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class WildcardMethodBreakpoint
extends Breakpoint<JavaMethodBreakpointProperties>
implements MethodBreakpointBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint");

    public WildcardMethodBreakpoint(Project project, XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        super(project, breakpoint);
    }

    @Override
    public Key<MethodBreakpoint> getCategory() {
        return MethodBreakpoint.CATEGORY;
    }

    protected WildcardMethodBreakpoint(Project project, @NotNull String classPattern, @NotNull String methodName, XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        if (classPattern == null) {
            WildcardMethodBreakpoint.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            WildcardMethodBreakpoint.$$$reportNull$$$0(1);
        }
        super(project, breakpoint);
        this.setClassPattern(classPattern);
        this.setMethodName(methodName);
    }

    @Override
    public String getClassName() {
        return this.getClassPattern();
    }

    @Override
    @Nullable
    public String getShortClassName() {
        return this.getClassName();
    }

    public String getMethodName() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName;
    }

    @Override
    public void disableEmulation() {
        MethodBreakpointBase.disableEmulation(this);
    }

    @Override
    public PsiClass getPsiClass() {
        return (PsiClass)ReadAction.compute(() -> this.getClassName() != null ? DebuggerUtils.findClass((String)this.getClassName(), (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)) : null);
    }

    @Override
    public String getDisplayName() {
        if (!this.isValid()) {
            return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        return this.getClassPattern() + "." + this.getMethodName() + "()";
    }

    @Override
    public Icon getIcon() {
        if (!this.isEnabled()) {
            Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
            return master == null ? AllIcons.Debugger.Db_disabled_method_breakpoint : AllIcons.Debugger.Db_dep_method_breakpoint;
        }
        return AllIcons.Debugger.Db_method_breakpoint;
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        return (this.isEmulated() || this.matchesMethod(event.location().method())) && super.evaluateCondition(context, event);
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.shouldCreateRequest(debugProcess)) {
            return;
        }
        if (this.isEmulated()) {
            debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, this.getClassPattern());
            Pattern pattern = PatternUtil.fromMask((String)this.getClassPattern());
            debugProcess.getVirtualMachineProxy().allClasses().stream().filter(c -> pattern.matcher(c.name()).matches()).filter(ReferenceType::isPrepared).forEach(aList -> this.processClassPrepare(debugProcess, (ReferenceType)aList));
        } else {
            try {
                RequestManagerImpl requestManager = debugProcess.getRequestsManager();
                if (this.isWatchEntry()) {
                    MethodEntryRequest entryRequest = MethodBreakpoint.findRequest(debugProcess, MethodEntryRequest.class, this);
                    if (entryRequest == null) {
                        entryRequest = requestManager.createMethodEntryRequest(this);
                    } else {
                        entryRequest.disable();
                    }
                    entryRequest.addClassFilter(this.getClassPattern());
                    debugProcess.getRequestsManager().enableRequest(entryRequest);
                }
                if (this.isWatchExit()) {
                    MethodExitRequest exitRequest = MethodBreakpoint.findRequest(debugProcess, MethodExitRequest.class, this);
                    if (exitRequest == null) {
                        exitRequest = requestManager.createMethodExitRequest(this);
                    } else {
                        exitRequest.disable();
                    }
                    exitRequest.addClassFilter(this.getClassPattern());
                    debugProcess.getRequestsManager().enableRequest(exitRequest);
                }
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType refType) {
        if (this.isEmulated()) {
            MethodBreakpoint.createRequestForPreparedClassEmulated(this, (DebugProcessImpl)debugProcess, refType, true);
        }
    }

    @Override
    public String getEventMessage(@NotNull LocatableEvent event) {
        if (event == null) {
            WildcardMethodBreakpoint.$$$reportNull$$$0(2);
        }
        return MethodBreakpoint.getEventMessage(event, "");
    }

    @Override
    public boolean isValid() {
        return !StringUtil.isEmpty((String)this.getClassPattern()) && !StringUtil.isEmpty((String)this.getMethodName());
    }

    @Override
    public PsiElement getEvaluationElement() {
        return null;
    }

    @Override
    public void readExternal(Element parentNode) throws InvalidDataException {
        super.readExternal(parentNode);
        String className2 = parentNode.getAttributeValue("class_name");
        this.setClassPattern(className2);
        String methodName = parentNode.getAttributeValue("method_name");
        this.setMethodName(methodName);
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (className2 == null || methodName == null) {
            throw new InvalidDataException();
        }
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        return (StreamEx)methods.filter(this::matchesMethod);
    }

    private boolean matchesMethod(Method method) {
        StringBuilder sb = new StringBuilder();
        for (String mask : StringUtil.split((String)this.getMethodName(), (String)",")) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append('(').append(PatternUtil.convertToRegex((String)mask)).append(')');
        }
        try {
            return method != null && Pattern.compile(sb.toString()).matcher(method.name()).matches();
        }
        catch (PatternSyntaxException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public static WildcardMethodBreakpoint create(Project project, String classPattern, String methodName, XBreakpoint<JavaMethodBreakpointProperties> xBreakpoint) {
        return new WildcardMethodBreakpoint(project, classPattern, methodName, xBreakpoint);
    }

    public boolean isEmulated() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).EMULATED;
    }

    @Override
    public boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY;
    }

    @Override
    public boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT;
    }

    private String getClassPattern() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern;
    }

    private void setClassPattern(String classPattern) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern = classPattern;
    }

    private void setMethodName(String methodName) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName = methodName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/breakpoints/WildcardMethodBreakpoint";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

