/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class MethodBreakpointPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XBreakpoint<JavaMethodBreakpointProperties>> {
    private JCheckBox myEmulatedCheckBox;
    private JCheckBox myWatchEntryCheckBox;
    private JCheckBox myWatchExitCheckBox;

    @NotNull
    public JComponent getComponent() {
        this.myEmulatedCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.method.breakpoint.properties.panel.emulated", (Object[])new Object[0]));
        this.myWatchEntryCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.method.breakpoint.properties.panel.method.entry", (Object[])new Object[0]));
        this.myWatchExitCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.method.breakpoint.properties.panel.method.exit", (Object[])new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.myWatchEntryCheckBox);
        DialogUtil.registerMnemonic((AbstractButton)this.myWatchExitCheckBox);
        Box watchBox = Box.createVerticalBox();
        Object _panel = JBUI.Panels.simplePanel();
        ((Container)_panel).add((Component)this.myEmulatedCheckBox, "North");
        watchBox.add((Component)_panel);
        _panel = new JPanel(new BorderLayout());
        ((Container)_panel).add((Component)this.myWatchEntryCheckBox, "North");
        watchBox.add((Component)_panel);
        _panel = new JPanel(new BorderLayout());
        ((Container)_panel).add((Component)this.myWatchExitCheckBox, "North");
        watchBox.add((Component)_panel);
        _panel = new JPanel(new BorderLayout());
        JPanel _panel0 = new JPanel(new BorderLayout());
        _panel0.add((Component)watchBox, "Center");
        _panel0.add(Box.createHorizontalStrut(3), "West");
        _panel0.add(Box.createHorizontalStrut(3), "East");
        ((Container)_panel).add((Component)_panel0, "North");
        ((JComponent)_panel).setBorder(IdeBorderFactory.createTitledBorder((String)DebuggerBundle.message((String)"label.group.watch.events", (Object[])new Object[0])));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox toCheck = null;
                if (!MethodBreakpointPropertiesPanel.this.myWatchEntryCheckBox.isSelected() && !MethodBreakpointPropertiesPanel.this.myWatchExitCheckBox.isSelected()) {
                    Object source = e.getSource();
                    if (MethodBreakpointPropertiesPanel.this.myWatchEntryCheckBox.equals(source)) {
                        toCheck = MethodBreakpointPropertiesPanel.this.myWatchExitCheckBox;
                    } else if (MethodBreakpointPropertiesPanel.this.myWatchExitCheckBox.equals(source)) {
                        toCheck = MethodBreakpointPropertiesPanel.this.myWatchEntryCheckBox;
                    }
                    if (toCheck != null) {
                        toCheck.setSelected(true);
                    }
                }
            }
        };
        this.myWatchEntryCheckBox.addActionListener(listener);
        this.myWatchExitCheckBox.addActionListener(listener);
        Object object = _panel;
        if (object == null) {
            MethodBreakpointPropertiesPanel.$$$reportNull$$$0(0);
        }
        return object;
    }

    public void loadFrom(@NotNull XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            MethodBreakpointPropertiesPanel.$$$reportNull$$$0(1);
        }
        this.myEmulatedCheckBox.setSelected(((JavaMethodBreakpointProperties)breakpoint.getProperties()).EMULATED);
        this.myWatchEntryCheckBox.setSelected(((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_ENTRY);
        this.myWatchExitCheckBox.setSelected(((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_EXIT);
    }

    public void saveTo(@NotNull XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            MethodBreakpointPropertiesPanel.$$$reportNull$$$0(2);
        }
        boolean changed = ((JavaMethodBreakpointProperties)breakpoint.getProperties()).EMULATED != this.myEmulatedCheckBox.isSelected();
        ((JavaMethodBreakpointProperties)breakpoint.getProperties()).EMULATED = this.myEmulatedCheckBox.isSelected();
        changed = ((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_ENTRY != this.myWatchEntryCheckBox.isSelected() || changed;
        ((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_ENTRY = this.myWatchEntryCheckBox.isSelected();
        changed = ((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_EXIT != this.myWatchExitCheckBox.isSelected() || changed;
        ((JavaMethodBreakpointProperties)breakpoint.getProperties()).WATCH_EXIT = this.myWatchExitCheckBox.isSelected();
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/MethodBreakpointPropertiesPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpointPropertiesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

