/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class LineBreakpoint<P extends JavaBreakpointProperties>
extends BreakpointWithHighlighter<P> {
    static final Logger LOG = Logger.getInstance(LineBreakpoint.class);
    @NonNls
    public static final Key<LineBreakpoint> CATEGORY = BreakpointCategory.lookup("line_breakpoints");
    private static final Pattern ourAnonymousPattern = Pattern.compile(".*\\$\\d*$");

    protected LineBreakpoint(Project project, XBreakpoint xBreakpoint) {
        super(project, xBreakpoint);
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) != null) {
            return isMuted ? AllIcons.Debugger.Db_muted_dep_line_breakpoint : AllIcons.Debugger.Db_dep_line_breakpoint;
        }
        return null;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return XDebuggerUtilImpl.getVerifiedIcon((XBreakpoint)this.myXBreakpoint);
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return new LayeredIcon(new Icon[]{isMuted ? AllIcons.Debugger.Db_muted_breakpoint : AllIcons.Debugger.Db_set_breakpoint, AllIcons.General.WarningDecorator});
    }

    @Override
    public Key<LineBreakpoint> getCategory() {
        return CATEGORY;
    }

    @Override
    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, String classToBeLoaded) {
        if (this.isInScopeOf(debugProcess, classToBeLoaded)) {
            super.createOrWaitPrepare(debugProcess, classToBeLoaded);
        }
    }

    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
        if (!((Boolean)ReadAction.compute(() -> this.isInScopeOf(debugProcess, classType.name()))).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(classType.name() + " is out of debug-process scope, breakpoint request won't be created for line " + this.getLineIndex());
            }
            return;
        }
        try {
            List<Location> locations = debugProcess.getPositionManager().locationsOfLine(classType, this.getSourcePosition());
            if (!locations.isEmpty()) {
                locations = ((StreamEx)((StreamEx)StreamEx.of(locations).peek(loc -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found location [codeIndex=" + loc.codeIndex() + "] for reference type " + classType.name() + " at line " + this.getLineIndex() + "; isObsolete: " + (debugProcess.getVirtualMachineProxy().versionHigher("1.4") && loc.method().isObsolete()));
                    }
                })).filter(l -> this.acceptLocation(debugProcess, classType, (Location)l))).toList();
                locations = MethodBytecodeUtil.removeSameLineLocations(locations);
                for (Location loc2 : locations) {
                    LineBreakpoint.createLocationBreakpointRequest(this, loc2, debugProcess);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Created breakpoint request for reference type " + classType.name() + " at line " + this.getLineIndex() + "; codeIndex=" + loc2.codeIndex());
                }
            } else if (DebuggerUtilsEx.allLineLocations(classType) == null) {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.no.line.info", (Object[])new Object[]{classType.name()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No line number info in " + classType.name());
                }
            } else {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.no.executable.code", (Object[])new Object[]{this.getLineIndex() + 1, classType.name()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No locations of type " + classType.name() + " found at line " + this.getLineIndex());
                }
            }
        }
        catch (ClassNotPreparedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClassNotPreparedException: " + ex.getMessage());
            }
        }
        catch (ObjectCollectedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ObjectCollectedException: " + ex.getMessage());
            }
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
        }
        this.updateUI();
    }

    private static boolean isAnonymousClass(ReferenceType classType) {
        if (classType instanceof ClassType) {
            return ourAnonymousPattern.matcher(classType.name()).matches();
        }
        return false;
    }

    protected boolean acceptLocation(DebugProcessImpl debugProcess, ReferenceType classType, Location loc) {
        Method method = loc.method();
        if (LineBreakpoint.isAnonymousClass(classType) && (method.isConstructor() && loc.codeIndex() == 0L || method.isBridge())) {
            return false;
        }
        SourcePosition position = debugProcess.getPositionManager().getSourcePosition(loc);
        if (position == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            JavaLineBreakpointType type2 = this.getXBreakpointType();
            if (type2 == null) {
                return true;
            }
            return type2.matchesPosition(this, position);
        });
    }

    @Nullable
    protected JavaLineBreakpointType getXBreakpointType() {
        XBreakpointType type2 = this.myXBreakpoint.getType();
        if (type2 instanceof JavaLineBreakpointType) {
            return (JavaLineBreakpointType)type2;
        }
        return null;
    }

    private boolean isInScopeOf(DebugProcessImpl debugProcess, String className2) {
        SourcePosition position = this.getSourcePosition();
        if (position != null) {
            VirtualFile breakpointFile = position.getFile().getVirtualFile();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            if (breakpointFile != null && fileIndex.isUnderSourceRootOfType(breakpointFile, JavaModuleSourceRootTypes.SOURCES)) {
                if (debugProcess.getSearchScope().contains(breakpointFile)) {
                    return true;
                }
                Collection<VirtualFile> candidates = this.findClassCandidatesInSourceContent(className2, debugProcess.getSearchScope(), fileIndex);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found " + (candidates == null ? "null" : Integer.valueOf(candidates.size())) + " candidate containing files for class " + className2);
                }
                if (candidates == null) {
                    return true;
                }
                if (LOG.isDebugEnabled()) {
                    GlobalSearchScope scope = debugProcess.getSearchScope();
                    boolean contains = scope.contains(breakpointFile);
                    List files = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(className2, scope), aClass -> aClass.getContainingFile().getVirtualFile());
                    List allFiles = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(className2, (GlobalSearchScope)new EverythingGlobalScope(this.myProject)), aClass -> aClass.getContainingFile().getVirtualFile());
                    VirtualFile contentRoot = fileIndex.getContentRootForFile(breakpointFile);
                    Module module = fileIndex.getModuleForFile(breakpointFile);
                    LOG.debug("Did not find '" + className2 + "' in " + scope + "; contains=" + contains + "; contentRoot=" + contentRoot + "; module = " + module + "; all files in index are: " + files + "; all possible files are: " + allFiles);
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    private Collection<VirtualFile> findClassCandidatesInSourceContent(String className2, GlobalSearchScope scope, ProjectFileIndex fileIndex) {
        int dollarIndex = className2.indexOf("$");
        String topLevelClassName = dollarIndex >= 0 ? className2.substring(0, dollarIndex) : className2;
        return (Collection)ReadAction.compute(() -> {
            PsiClass[] classes2 = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(topLevelClassName, scope);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found " + classes2.length + " classes " + topLevelClassName + " in scope " + scope);
            }
            if (classes2.length == 0) {
                return null;
            }
            ArrayList<VirtualFile> list = new ArrayList<VirtualFile>(classes2.length);
            for (PsiClass aClass : classes2) {
                PsiFile psiFile = aClass.getContainingFile();
                if (LOG.isDebugEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Checking class ").append(aClass.getQualifiedName());
                    msg.append("\n\t").append("PsiFile=").append(psiFile);
                    if (psiFile != null) {
                        VirtualFile vFile = psiFile.getVirtualFile();
                        msg.append("\n\t").append("VirtualFile=").append(vFile);
                        if (vFile != null) {
                            msg.append("\n\t").append("isInSourceContent=").append(fileIndex.isUnderSourceRootOfType(vFile, JavaModuleSourceRootTypes.SOURCES));
                        }
                    }
                    LOG.debug(msg.toString());
                }
                if (psiFile == null) {
                    return null;
                }
                VirtualFile vFile = psiFile.getVirtualFile();
                if (vFile == null || !fileIndex.isUnderSourceRootOfType(vFile, JavaModuleSourceRootTypes.SOURCES)) {
                    return null;
                }
                list.add(vFile);
            }
            return list;
        });
    }

    @Override
    public String getShortName() {
        return this.getDisplayInfoInternal(false, 30);
    }

    @Override
    public String getDisplayName() {
        return this.getDisplayInfoInternal(true, -1);
    }

    private String getDisplayInfoInternal(boolean showPackageInfo, int totalTextLength) {
        if (this.isValid()) {
            boolean hasMethodInfo;
            int lineNumber = this.getLineIndex() + 1;
            String className2 = this.getClassName();
            boolean hasClassInfo = className2 != null && className2.length() > 0;
            String methodName = this.getMethodName();
            String displayName = methodName != null ? methodName + "()" : null;
            boolean bl = hasMethodInfo = displayName != null && displayName.length() > 0;
            if (hasClassInfo || hasMethodInfo) {
                StringBuilder info = new StringBuilder();
                boolean isFile = this.getFileName().equals(className2);
                String packageName = null;
                if (hasClassInfo) {
                    int offset;
                    int dotIndex = className2.lastIndexOf(".");
                    if (dotIndex >= 0 && !isFile) {
                        packageName = className2.substring(0, dotIndex);
                        className2 = className2.substring(dotIndex + 1);
                    }
                    if (totalTextLength != -1 && className2.length() + (hasMethodInfo ? displayName.length() : 0) > totalTextLength + 3 && (offset = totalTextLength - (hasMethodInfo ? displayName.length() : 0)) > 0 && offset < className2.length()) {
                        className2 = className2.substring(className2.length() - offset);
                        info.append("...");
                    }
                    info.append(className2);
                }
                if (hasMethodInfo) {
                    if (isFile) {
                        info.append(":");
                    } else if (hasClassInfo) {
                        info.append(".");
                    }
                    info.append(displayName);
                }
                if (showPackageInfo && packageName != null) {
                    info.append(" (").append(packageName).append(")");
                }
                return DebuggerBundle.message((String)"line.breakpoint.display.name.with.class.or.method", (Object[])new Object[]{lineNumber, info.toString()});
            }
            return DebuggerBundle.message((String)"line.breakpoint.display.name", (Object[])new Object[]{lineNumber});
        }
        return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
    }

    @Nullable
    private static String findOwnerMethod(PsiFile file, int offset) {
        if (offset < 0 || file instanceof JspFile) {
            return null;
        }
        if (file instanceof PsiClassOwner) {
            return (String)ReadAction.compute(() -> {
                PsiMethod method = DebuggerUtilsEx.findPsiMethod(file, offset);
                return method != null ? method.getName() : null;
            });
        }
        return null;
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        Location location = event.location();
        String sourceName = DebuggerUtilsEx.getSourceName(location, e -> this.getFileName());
        return DebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])new Object[]{DebuggerUtilsEx.getLocationMethodQName(location), sourceName, this.getLineIndex() + 1});
    }

    @Override
    public PsiElement getEvaluationElement() {
        return ContextUtil.getContextElement(this.getSourcePosition());
    }

    public static LineBreakpoint create(@NotNull Project project, XBreakpoint xBreakpoint) {
        if (project == null) {
            LineBreakpoint.$$$reportNull$$$0(0);
        }
        LineBreakpoint breakpoint = new LineBreakpoint(project, xBreakpoint);
        return (LineBreakpoint)breakpoint.init();
    }

    public static boolean canAddLineBreakpoint(Project project, Document document, int lineIndex) {
        if (lineIndex < 0 || lineIndex >= document.getLineCount()) {
            return false;
        }
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
        LineBreakpoint breakpointAtLine = breakpointManager.findBreakpoint(document, document.getLineStartOffset(lineIndex), CATEGORY);
        if (breakpointAtLine != null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        boolean[] canAdd = new boolean[]{false};
        XDebuggerUtil.getInstance().iterateLine(project, document, lineIndex, element -> {
            PsiStatement[] statements;
            PsiCodeBlock body2;
            int offset;
            if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                return true;
            }
            PsiElement child = element;
            while (element != null && ((offset = element.getTextOffset()) < 0 || document.getLineNumber(offset) == lineIndex)) {
                child = element;
                element = element.getParent();
            }
            canAdd[0] = child instanceof PsiMethod && child.getTextRange().getEndOffset() >= document.getLineEndOffset(lineIndex) ? ((body2 = ((PsiMethod)child).getBody()) == null ? false : (statements = body2.getStatements()).length > 0 && document.getLineNumber(statements[0].getTextOffset()) == lineIndex) : true;
            return false;
        });
        return canAdd[0];
    }

    @Nullable
    public String getMethodName() {
        SourcePosition position = this.getSourcePosition();
        if (position != null) {
            return LineBreakpoint.findOwnerMethod(position.getFile(), position.getOffset());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/LineBreakpoint", "create"));
    }
}

