/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.AddFieldBreakpointDialog;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PairFunction;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

public class JavaFieldBreakpointType
extends JavaLineBreakpointTypeBase<JavaFieldBreakpointProperties> {
    public JavaFieldBreakpointType() {
        super("java-field", DebuggerBundle.message((String)"field.watchpoints.tab.title", (Object[])new Object[0]));
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        Icon icon = AllIcons.Debugger.Db_no_suspend_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(5);
        }
        return icon;
    }

    protected String getHelpID() {
        return "debugging.fieldWatchpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"field.watchpoints.tab.title", (Object[])new Object[0]);
    }

    public String getShortText(XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        return this.getText(breakpoint);
    }

    public String getText(XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        JavaFieldBreakpointProperties properties = (JavaFieldBreakpointProperties)breakpoint.getProperties();
        String className2 = properties.myClassName;
        return className2 != null && !className2.isEmpty() ? className2 + "." + properties.myFieldName : properties.myFieldName;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaFieldBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(6);
        }
        return new FieldBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaFieldBreakpointProperties createProperties() {
        return new JavaFieldBreakpointProperties();
    }

    @Nullable
    public JavaFieldBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(7);
        }
        return new JavaFieldBreakpointProperties();
    }

    @Nullable
    public XLineBreakpoint<JavaFieldBreakpointProperties> addBreakpoint(final Project project, JComponent parentComponent) {
        final Ref result = Ref.create(null);
        AddFieldBreakpointDialog dialog = new AddFieldBreakpointDialog(project){

            @Override
            protected boolean validateData() {
                String className2 = this.getClassName();
                if (className2.length() == 0) {
                    Messages.showMessageDialog((Project)project, (String)DebuggerBundle.message((String)"error.field.breakpoint.class.name.not.specified", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                String fieldName = this.getFieldName();
                if (fieldName.length() == 0) {
                    Messages.showMessageDialog((Project)project, (String)DebuggerBundle.message((String)"error.field.breakpoint.field.name.not.specified", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className2, GlobalSearchScope.allScope((Project)project));
                if (psiClass != null) {
                    PsiFile psiFile = psiClass.getContainingFile();
                    Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                    if (document != null) {
                        PsiField field = psiClass.findFieldByName(fieldName, true);
                        if (field != null) {
                            int line = document.getLineNumber(field.getTextOffset());
                            WriteAction.run(() -> {
                                XLineBreakpoint fieldBreakpoint = XDebuggerManager.getInstance((Project)project).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)JavaFieldBreakpointType.this, psiFile.getVirtualFile().getUrl(), line, (XBreakpointProperties)new JavaFieldBreakpointProperties(fieldName, className2));
                                result.set((Object)fieldBreakpoint);
                            });
                            return true;
                        }
                        Messages.showMessageDialog((Project)project, (String)DebuggerBundle.message((String)"error.field.breakpoint.field.not.found", (Object[])new Object[]{className2, fieldName, fieldName}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    }
                } else {
                    Messages.showMessageDialog((Project)project, (String)DebuggerBundle.message((String)"error.field.breakpoint.class.sources.not.found", (Object[])new Object[]{className2, fieldName, className2}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                }
                return false;
            }
        };
        dialog.show();
        return (XLineBreakpoint)result.get();
    }

    @Override
    @NotNull
    public Breakpoint<JavaFieldBreakpointProperties> createJavaBreakpoint(Project project, XBreakpoint breakpoint) {
        FieldBreakpoint fieldBreakpoint = new FieldBreakpoint(project, breakpoint);
        if (fieldBreakpoint == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(8);
        }
        return fieldBreakpoint;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(9);
        }
        if (project == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(10);
        }
        return JavaFieldBreakpointType.canPutAtElement(file, line, project, (PairFunction<? super PsiElement, ? super Document, Boolean>)((PairFunction)(element, document) -> element instanceof PsiField));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaFieldBreakpointType";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendNoneIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedEnabledIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedDisabledIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaFieldBreakpointType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBreakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomPropertiesPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

