/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class InstrumentationTracker {
    private static final Logger LOG = Logger.getInstance(InstrumentationTracker.class);
    private final InstrumentationMethodBreakpoint myRedefineBreakpoint;
    private final InstrumentationMethodBreakpoint myRetransformBreakpoint;
    @NotNull
    private final DebugProcessImpl myDebugProcess;
    private static final java.lang.reflect.Method ourNoticeRedefineClassMethod;

    public static void track(DebugProcessImpl debugProcess) {
        if (ourNoticeRedefineClassMethod != null) {
            new InstrumentationTracker(debugProcess);
        }
    }

    private InstrumentationTracker(DebugProcessImpl debugProcess) {
        this.myRedefineBreakpoint = new InstrumentationMethodBreakpoint(debugProcess.getProject(), "sun.instrument.InstrumentationImpl", "redefineClasses"){

            @Override
            public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) {
                try {
                    Value value2 = (Value)ContainerUtil.getFirstItem(DebuggerUtilsEx.getArgumentValues(event.thread().frame(0)));
                    if (value2 instanceof ArrayReference) {
                        ((ArrayReference)value2).getValues().forEach(v -> {
                            Value aClass = ((ObjectReference)v).getValue(((ReferenceType)v.type()).fieldByName("mClass"));
                            InstrumentationTracker.this.noticeRedefineClass(((ClassObjectReference)aClass).reflectedType());
                        });
                    }
                }
                catch (IncompatibleThreadStateException e) {
                    LOG.warn((Throwable)e);
                }
                return false;
            }
        };
        this.myRetransformBreakpoint = new InstrumentationMethodBreakpoint(debugProcess.getProject(), "sun.instrument.InstrumentationImpl", "retransformClasses"){

            @Override
            public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) {
                try {
                    Value value2 = (Value)ContainerUtil.getFirstItem(DebuggerUtilsEx.getArgumentValues(event.thread().frame(0)));
                    if (value2 instanceof ArrayReference) {
                        ((ArrayReference)value2).getValues().forEach(v -> InstrumentationTracker.this.noticeRedefineClass(((ClassObjectReference)v).reflectedType()));
                    }
                }
                catch (IncompatibleThreadStateException e) {
                    LOG.warn((Throwable)e);
                }
                return false;
            }
        };
        this.myDebugProcess = debugProcess;
        this.myRedefineBreakpoint.createRequest(debugProcess);
        this.myRetransformBreakpoint.createRequest(debugProcess);
    }

    private void noticeRedefineClass(ReferenceType type2) {
        if (!ourNoticeRedefineClassMethod.getDeclaringClass().isAssignableFrom(type2.getClass())) {
            return;
        }
        List requestors = ((StreamEx)StreamEx.of(type2.virtualMachine().eventRequestManager().breakpointRequests()).filter(r -> type2.equals(r.location().declaringType()))).map(RequestManagerImpl::findRequestor).toList();
        requestors.forEach(this.myDebugProcess.getRequestsManager()::deleteRequest);
        try {
            ourNoticeRedefineClassMethod.invoke((Object)type2, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error((Throwable)e);
        }
        StreamEx.of((Collection)requestors).select(Breakpoint.class).forEach(b -> b.createRequest(this.myDebugProcess));
    }

    static {
        java.lang.reflect.Method redefineMethod = null;
        try {
            redefineMethod = ReflectionUtil.getDeclaredMethod(Class.forName("com.sun.tools.jdi.ReferenceTypeImpl"), (String)"noticeRedefineClass", (Class[])new Class[0]);
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Throwable)e);
        }
        ourNoticeRedefineClassMethod = redefineMethod;
    }

    public static class InstrumentationMethodBreakpoint
    extends SyntheticLineBreakpoint {
        private final String myClassName;
        private final String myMethodName;

        public InstrumentationMethodBreakpoint(@NotNull Project project, String className2, String methodName) {
            if (project == null) {
                InstrumentationMethodBreakpoint.$$$reportNull$$$0(0);
            }
            super(project);
            this.myClassName = className2;
            this.myMethodName = methodName;
        }

        @Override
        public void createRequest(@NotNull DebugProcessImpl debugProcess) {
            if (debugProcess == null) {
                InstrumentationMethodBreakpoint.$$$reportNull$$$0(1);
            }
            this.createOrWaitPrepare(debugProcess, this.myClassName);
        }

        @Override
        protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
            for (Method method : classType.methodsByName(this.myMethodName)) {
                this.createRequestInMethod(debugProcess, method);
            }
        }

        protected void createRequestInMethod(DebugProcessImpl debugProcess, Method method) {
            try {
                Location location = (Location)ContainerUtil.getLastItem(method.allLineLocations());
                BreakpointWithHighlighter.createLocationBreakpointRequest(this, location, debugProcess);
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }

        @Override
        public String getDisplayName() {
            return "Instrumentation tracker: " + this.myMethodName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugProcess";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/ui/breakpoints/InstrumentationTracker$InstrumentationMethodBreakpoint";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

