/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.DialogUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

public class FieldBreakpointPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaFieldBreakpointProperties>> {
    private JCheckBox myWatchAccessCheckBox;
    private JCheckBox myWatchModificationCheckBox;

    @NotNull
    public JComponent getComponent() {
        this.myWatchAccessCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.filed.breakpoint.properties.panel.field.access", (Object[])new Object[0]));
        this.myWatchModificationCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.filed.breakpoint.properties.panel.field.modification", (Object[])new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.myWatchAccessCheckBox);
        DialogUtil.registerMnemonic((AbstractButton)this.myWatchModificationCheckBox);
        Box watchBox = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myWatchAccessCheckBox, "North");
        watchBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myWatchModificationCheckBox, "North");
        watchBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        JPanel _panel0 = new JPanel(new BorderLayout());
        _panel0.add((Component)watchBox, "Center");
        _panel0.add(Box.createHorizontalStrut(3), "West");
        _panel0.add(Box.createHorizontalStrut(3), "East");
        _panel.add((Component)_panel0, "North");
        _panel.setBorder(IdeBorderFactory.createTitledBorder((String)DebuggerBundle.message((String)"label.group.watch.events", (Object[])new Object[0])));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox toCheck = null;
                if (!FieldBreakpointPropertiesPanel.this.myWatchAccessCheckBox.isSelected() && !FieldBreakpointPropertiesPanel.this.myWatchModificationCheckBox.isSelected()) {
                    Object source = e.getSource();
                    if (FieldBreakpointPropertiesPanel.this.myWatchAccessCheckBox.equals(source)) {
                        toCheck = FieldBreakpointPropertiesPanel.this.myWatchModificationCheckBox;
                    } else if (FieldBreakpointPropertiesPanel.this.myWatchModificationCheckBox.equals(source)) {
                        toCheck = FieldBreakpointPropertiesPanel.this.myWatchAccessCheckBox;
                    }
                    if (toCheck != null) {
                        toCheck.setSelected(true);
                    }
                }
            }
        };
        this.myWatchAccessCheckBox.addActionListener(listener);
        this.myWatchModificationCheckBox.addActionListener(listener);
        JPanel jPanel = _panel;
        if (jPanel == null) {
            FieldBreakpointPropertiesPanel.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void loadFrom(@NotNull XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            FieldBreakpointPropertiesPanel.$$$reportNull$$$0(1);
        }
        this.myWatchAccessCheckBox.setSelected(((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_ACCESS);
        this.myWatchModificationCheckBox.setSelected(((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_MODIFICATION);
    }

    public void saveTo(@NotNull XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            FieldBreakpointPropertiesPanel.$$$reportNull$$$0(2);
        }
        boolean changed = ((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_ACCESS != this.myWatchAccessCheckBox.isSelected();
        ((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_ACCESS = this.myWatchAccessCheckBox.isSelected();
        changed = ((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_MODIFICATION != this.myWatchModificationCheckBox.isSelected() || changed;
        ((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_MODIFICATION = this.myWatchModificationCheckBox.isSelected();
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/FieldBreakpointPropertiesPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/FieldBreakpointPropertiesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

