/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapManager;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.HotSwapProgressImpl;
import com.intellij.debugger.ui.HotSwapStatusListener;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapVetoableListener;
import com.intellij.debugger.ui.RunHotswapDialog;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskListener;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskResult;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

public class HotSwapUIImpl
extends HotSwapUI {
    private static final Key<HotSwapStatusListener> HOT_SWAP_CALLBACK_KEY = Key.create((String)"hot_swap_callback");
    private final List<HotSwapVetoableListener> myListeners;
    private boolean myAskBeforeHotswap;
    private final Project myProject;
    private boolean myPerformHotswapAfterThisCompilation;

    public HotSwapUIImpl(final @NotNull Project project) {
        if (project == null) {
            HotSwapUIImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myAskBeforeHotswap = true;
        this.myPerformHotswapAfterThisCompilation = true;
        this.myProject = project;
        project.getMessageBus().connect().subscribe(DebuggerManagerListener.TOPIC, (Object)new DebuggerManagerListener(){
            private MessageBusConnection myConn = null;

            @Override
            public void sessionAttached(DebuggerSession session) {
                if (this.myConn == null) {
                    this.myConn = project.getMessageBus().connect();
                    this.myConn.subscribe(ProjectTaskListener.TOPIC, (Object)new MyCompilationStatusListener());
                }
            }

            @Override
            public void sessionDetached(DebuggerSession session) {
                if (!HotSwapUIImpl.this.getHotSwappableDebugSessions().isEmpty()) {
                    return;
                }
                MessageBusConnection conn = this.myConn;
                if (conn != null) {
                    Disposer.dispose((Disposable)conn);
                    this.myConn = null;
                }
            }
        });
    }

    @Override
    public void addListener(HotSwapVetoableListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(HotSwapVetoableListener listener) {
        this.myListeners.remove(listener);
    }

    private static boolean shouldDisplayHangWarning(DebuggerSettings settings, List<DebuggerSession> sessions) {
        if (!settings.HOTSWAP_HANG_WARNING_ENABLED) {
            return false;
        }
        return sessions.stream().anyMatch(DebuggerSession::isPaused);
    }

    private void hotSwapSessions(final List<DebuggerSession> sessions, @Nullable Map<String, Collection<String>> generatedPaths, final @Nullable HotSwapStatusListener callback) {
        HotSwapProgressImpl findClassesProgress;
        boolean shouldPerformScan;
        boolean shouldAskBeforeHotswap = this.myAskBeforeHotswap;
        this.myAskBeforeHotswap = true;
        DebuggerSettings settings = DebuggerSettings.getInstance();
        String runHotswap = settings.RUN_HOTSWAP_AFTER_COMPILE;
        boolean shouldDisplayHangWarning = HotSwapUIImpl.shouldDisplayHangWarning(settings, sessions);
        final HotSwapStatusListener callbackWrapper = new HotSwapStatusListener(){

            @Override
            public void onCancel(List<DebuggerSession> sessions) {
                if (callback != null) {
                    callback.onCancel(sessions);
                }
            }

            @Override
            public void onSuccess(List<DebuggerSession> sessions) {
                if (callback != null) {
                    callback.onSuccess(sessions);
                }
            }

            @Override
            public void onFailure(List<DebuggerSession> sessions) {
                if (callback != null) {
                    callback.onFailure(sessions);
                }
            }
        };
        if (shouldAskBeforeHotswap && "RunHotswapNever".equals(runHotswap)) {
            callbackWrapper.onCancel(sessions);
            return;
        }
        boolean bl = shouldPerformScan = generatedPaths == null;
        if (shouldPerformScan) {
            findClassesProgress = new HotSwapProgressImpl(this.myProject);
        } else {
            boolean createProgress = sessions.stream().anyMatch(DebuggerSession::isModifiedClassesScanRequired);
            HotSwapProgressImpl hotSwapProgressImpl = findClassesProgress = createProgress ? new HotSwapProgressImpl(this.myProject) : null;
        }
        if (findClassesProgress != null) {
            findClassesProgress.addProgressListener(new HotSwapProgressImpl.HotSwapProgressListener(){

                @Override
                public void onCancel() {
                    callbackWrapper.onCancel(sessions);
                }
            });
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses;
            if (shouldPerformScan) {
                modifiedClasses = HotSwapUIImpl.scanForModifiedClassesWithProgress(sessions, findClassesProgress);
            } else {
                ArrayList<DebuggerSession> toScan = new ArrayList<DebuggerSession>();
                ArrayList toUseGenerated = new ArrayList();
                for (DebuggerSession session : sessions) {
                    (session.isModifiedClassesScanRequired() ? toScan : toUseGenerated).add(session);
                    session.setModifiedClassesScanRequired(false);
                }
                modifiedClasses = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
                if (!toUseGenerated.isEmpty()) {
                    modifiedClasses.putAll(HotSwapManager.findModifiedClasses(toUseGenerated, generatedPaths));
                }
                if (!toScan.isEmpty()) {
                    modifiedClasses.putAll(HotSwapUIImpl.scanForModifiedClassesWithProgress(toScan, Objects.requireNonNull(findClassesProgress)));
                }
            }
            Application application = ApplicationManager.getApplication();
            if (modifiedClasses.isEmpty()) {
                String message2 = DebuggerBundle.message((String)"status.hotswap.uptodate", (Object[])new Object[0]);
                HotSwapProgressImpl.NOTIFICATION_GROUP.createNotification(message2, NotificationType.INFORMATION).notify(this.myProject);
                callbackWrapper.onSuccess(sessions);
                return;
            }
            application.invokeLater(() -> {
                int answer;
                if (shouldAskBeforeHotswap && !"RunHotswapAlways".equals(runHotswap)) {
                    RunHotswapDialog dialog = new RunHotswapDialog(this.myProject, sessions, shouldDisplayHangWarning);
                    if (!dialog.showAndGet()) {
                        for (DebuggerSession session : modifiedClasses.keySet()) {
                            session.setModifiedClassesScanRequired(true);
                        }
                        callbackWrapper.onCancel(sessions);
                        return;
                    }
                    HashSet<DebuggerSession> toReload = new HashSet<DebuggerSession>(dialog.getSessionsToReload());
                    for (DebuggerSession session : modifiedClasses.keySet()) {
                        if (toReload.contains(session)) continue;
                        session.setModifiedClassesScanRequired(true);
                    }
                    modifiedClasses.keySet().retainAll(toReload);
                } else if (shouldDisplayHangWarning && (answer = Messages.showCheckboxMessageDialog((String)DebuggerBundle.message((String)"hotswap.dialog.hang.warning", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"hotswap.dialog.title", (Object[])new Object[0]), (String[])new String[]{"Perform &Reload Classes", "&Skip Reload Classes"}, (String)CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]), (boolean)false, (int)1, (int)1, (Icon)Messages.getWarningIcon(), (exitCode, cb) -> {
                    settings.HOTSWAP_HANG_WARNING_ENABLED = !cb.isSelected();
                    return exitCode == 0 ? exitCode : 1;
                })) == 1) {
                    for (DebuggerSession session : modifiedClasses.keySet()) {
                        session.setModifiedClassesScanRequired(true);
                    }
                    callbackWrapper.onCancel(sessions);
                    return;
                }
                if (!modifiedClasses.isEmpty()) {
                    final HotSwapProgressImpl progress = new HotSwapProgressImpl(this.myProject);
                    if (modifiedClasses.keySet().size() == 1) {
                        progress.setSessionForActions((DebuggerSession)ContainerUtil.getFirstItem(modifiedClasses.keySet()));
                    }
                    progress.addProgressListener(new HotSwapProgressImpl.HotSwapProgressListener(){

                        @Override
                        public void onCancel() {
                            callbackWrapper.onCancel(sessions);
                        }

                        @Override
                        public void onFinish() {
                            if (progress.getMessages(4).isEmpty()) {
                                callbackWrapper.onSuccess(sessions);
                            } else {
                                callbackWrapper.onFailure(sessions);
                            }
                        }
                    });
                    application.executeOnPooledThread(() -> HotSwapUIImpl.reloadModifiedClasses(modifiedClasses, progress));
                }
            }, ModalityState.NON_MODAL);
        });
    }

    @NotNull
    private static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClassesWithProgress(@NotNull List<DebuggerSession> sessions, @NotNull HotSwapProgressImpl progress) {
        if (sessions == null) {
            HotSwapUIImpl.$$$reportNull$$$0(1);
        }
        if (progress == null) {
            HotSwapUIImpl.$$$reportNull$$$0(2);
        }
        Map map2 = (Map)ProgressManager.getInstance().runProcess(() -> {
            try {
                Map<DebuggerSession, Map<String, HotSwapFile>> map2 = HotSwapManager.scanForModifiedClasses(sessions, progress);
                return map2;
            }
            finally {
                progress.finished();
            }
        }, progress.getProgressIndicator());
        if (map2 == null) {
            HotSwapUIImpl.$$$reportNull$$$0(3);
        }
        return map2;
    }

    private static void reloadModifiedClasses(Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, HotSwapProgressImpl progress) {
        ProgressManager.getInstance().runProcess(() -> {
            HotSwapManager.reloadModifiedClasses(modifiedClasses, progress);
            progress.finished();
        }, progress.getProgressIndicator());
    }

    @Override
    public void reloadChangedClasses(@NotNull DebuggerSession session, boolean compileBeforeHotswap) {
        if (session == null) {
            HotSwapUIImpl.$$$reportNull$$$0(4);
        }
        this.reloadChangedClasses(session, compileBeforeHotswap, null);
    }

    @Override
    public void reloadChangedClasses(@NotNull DebuggerSession session, boolean compileBeforeHotswap, @Nullable HotSwapStatusListener callback) {
        if (session == null) {
            HotSwapUIImpl.$$$reportNull$$$0(5);
        }
        this.dontAskHotswapAfterThisCompilation();
        if (compileBeforeHotswap) {
            ProjectTaskManager projectTaskManager = ProjectTaskManager.getInstance((Project)session.getProject());
            if (callback == null) {
                projectTaskManager.buildAllModules();
            } else {
                ProjectTask buildProjectTask = projectTaskManager.createAllModulesBuildTask(true, session.getProject());
                ProjectTaskContext context = new ProjectTaskContext((Object)callback).withUserData(HOT_SWAP_CALLBACK_KEY, (Object)callback);
                projectTaskManager.run(context, buildProjectTask, null);
            }
        } else if (session.isAttached()) {
            this.hotSwapSessions(Collections.singletonList(session), null, callback);
        } else if (callback != null) {
            callback.onFailure(ContainerUtil.newSmartList((Object)session));
        }
    }

    @Override
    public void dontPerformHotswapAfterThisCompilation() {
        this.myPerformHotswapAfterThisCompilation = false;
    }

    public void dontAskHotswapAfterThisCompilation() {
        this.myAskBeforeHotswap = false;
    }

    public static boolean canHotSwap(@NotNull DebuggerSession debuggerSession) {
        if (debuggerSession == null) {
            HotSwapUIImpl.$$$reportNull$$$0(6);
        }
        return debuggerSession.isAttached() && debuggerSession.getProcess().canRedefineClasses();
    }

    @NotNull
    private List<DebuggerSession> getHotSwappableDebugSessions() {
        List list = (List)DebuggerManagerEx.getInstanceEx(this.myProject).getSessions().stream().filter(HotSwapUIImpl::canHotSwap).collect(Collectors.toCollection(SmartList::new));
        if (list == null) {
            HotSwapUIImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/HotSwapUIImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/HotSwapUIImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForModifiedClassesWithProgress";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHotSwappableDebugSessions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scanForModifiedClassesWithProgress";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reloadChangedClasses";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canHotSwap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCompilationStatusListener
    implements ProjectTaskListener {
        private final THashSet<File> myOutputRoots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);

        private MyCompilationStatusListener() {
            for (String path : CompilerPaths.getOutputPaths((Module[])ModuleManager.getInstance((Project)HotSwapUIImpl.this.myProject).getModules())) {
                this.myOutputRoots.add((Object)new File(path));
            }
        }

        public void started(@NotNull ProjectTaskContext context) {
            if (context == null) {
                MyCompilationStatusListener.$$$reportNull$$$0(0);
            }
            context.enableCollectionOfGeneratedFiles();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(@NotNull ProjectTaskContext context, @NotNull ProjectTaskResult executionResult) {
            block15: {
                if (context == null) {
                    MyCompilationStatusListener.$$$reportNull$$$0(1);
                }
                if (executionResult == null) {
                    MyCompilationStatusListener.$$$reportNull$$$0(2);
                }
                if (HotSwapUIImpl.this.myProject.isDisposed()) {
                    return;
                }
                try {
                    if (!this.hasCompilationResults(executionResult)) {
                        return;
                    }
                    int errors = executionResult.getErrors();
                    boolean aborted = executionResult.isAborted();
                    if (errors != 0 || aborted || !HotSwapUIImpl.this.myPerformHotswapAfterThisCompilation) break block15;
                    for (HotSwapVetoableListener listener : HotSwapUIImpl.this.myListeners) {
                        if (listener.shouldHotSwap(context, executionResult)) continue;
                        return;
                    }
                    List sessions = HotSwapUIImpl.this.getHotSwappableDebugSessions();
                    if (!sessions.isEmpty()) {
                        HashMap<String, Collection> generatedPaths;
                        Collection generatedFilesRoots = context.getGeneratedFilesRoots();
                        if (!generatedFilesRoots.isEmpty()) {
                            generatedPaths = new HashMap<String, Collection>();
                            for (String outputRoot : generatedFilesRoots) {
                                Collection relativePaths;
                                if (!JpsPathUtil.isUnder(this.myOutputRoots, (File)new File(outputRoot)) || (relativePaths = (Collection)context.getGeneratedFilesRelativePaths(outputRoot).stream().filter(relativePath -> StringUtil.endsWith((CharSequence)relativePath, (CharSequence)".class")).collect(Collectors.toCollection(SmartList::new))).isEmpty()) continue;
                                generatedPaths.put(outputRoot, relativePaths);
                            }
                            if (generatedPaths.isEmpty()) {
                                generatedPaths = null;
                            }
                        } else {
                            generatedPaths = null;
                        }
                        HotSwapStatusListener callback = (HotSwapStatusListener)context.getUserData(HOT_SWAP_CALLBACK_KEY);
                        HotSwapUIImpl.this.hotSwapSessions(sessions, generatedPaths, callback);
                    }
                }
                finally {
                    HotSwapUIImpl.this.myPerformHotswapAfterThisCompilation = true;
                }
            }
        }

        private boolean hasCompilationResults(@NotNull ProjectTaskResult executionResult) {
            if (executionResult == null) {
                MyCompilationStatusListener.$$$reportNull$$$0(3);
            }
            return executionResult.anyMatch((task, state) -> task instanceof ModuleBuildTask && !state.isFailed() && !state.isSkipped());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executionResult";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/ui/HotSwapUIImpl$MyCompilationStatusListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "started";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finished";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasCompilationResults";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

