/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.memory.event.InstancesTrackerListener;
import com.intellij.xdebugger.memory.tracking.TrackingType;
import com.intellij.xdebugger.memory.ui.InstancesTree;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InstancesWithStackFrameView {
    private static final float DEFAULT_SPLITTER_PROPORTION = 0.7f;
    private static final String EMPTY_TEXT_WHEN_ITEM_NOT_SELECTED = "Select instance to see stack frame";
    private static final String EMPTY_TEXT_WHEN_STACK_NOT_FOUND = "No stack frame for this instance";
    private static final String TEXT_FOR_ARRAYS = "Arrays could not be tracked";
    private float myHidedProportion;
    private final JBSplitter mySplitter;
    private boolean myIsHided;

    InstancesWithStackFrameView(@NotNull XDebugSession debugSession, @NotNull InstancesTree tree, @NotNull StackFrameList list, final @NotNull String className2) {
        JBLabel stackTraceLabel;
        if (debugSession == null) {
            InstancesWithStackFrameView.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            InstancesWithStackFrameView.$$$reportNull$$$0(1);
        }
        if (list == null) {
            InstancesWithStackFrameView.$$$reportNull$$$0(2);
        }
        if (className2 == null) {
            InstancesWithStackFrameView.$$$reportNull$$$0(3);
        }
        this.mySplitter = new JBSplitter(false, 0.7f);
        this.myIsHided = false;
        this.mySplitter.setFirstComponent((JComponent)new JBScrollPane((Component)tree));
        Project project = debugSession.getProject();
        list.setEmptyText(EMPTY_TEXT_WHEN_ITEM_NOT_SELECTED);
        if (InstancesWithStackFrameView.isArrayType(className2)) {
            stackTraceLabel = new JBLabel(TEXT_FOR_ARRAYS, 0);
        } else {
            ActionLink actionLink = new ActionLink("Enable tracking for new instances", AllIcons.Debugger.Watch, new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Project project;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((project = e.getProject()) != null && !project.isDisposed()) {
                        InstancesTracker.getInstance((Project)project).add(className2, TrackingType.CREATION);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/memory/ui/InstancesWithStackFrameView$1", "actionPerformed"));
                }
            });
            actionLink.setHorizontalAlignment(0);
            actionLink.setPaintUnderline(false);
            stackTraceLabel = actionLink;
        }
        this.mySplitter.setSplitterProportionKey("InstancesWithStackFrameView.SplitterKey");
        JBScrollPane stackComponent = new JBScrollPane((Component)((Object)list));
        if (!project.isDisposed()) {
            InstancesTracker tracker = InstancesTracker.getInstance((Project)project);
            tracker.addTrackerListener(new InstancesTrackerListener((JComponent)stackComponent, (JLabel)stackTraceLabel){
                final /* synthetic */ JComponent val$stackComponent;
                final /* synthetic */ JLabel val$stackTraceLabel;
                {
                    this.val$stackComponent = jComponent;
                    this.val$stackTraceLabel = jLabel;
                }

                public void classChanged(@NotNull String name2, @NotNull TrackingType type2) {
                    if (name2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (type2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (Objects.equals(className2, name2) && type2 == TrackingType.CREATION) {
                        InstancesWithStackFrameView.this.mySplitter.setSecondComponent(this.val$stackComponent);
                    }
                }

                public void classRemoved(@NotNull String name2) {
                    if (name2 == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (Objects.equals(name2, className2)) {
                        InstancesWithStackFrameView.this.mySplitter.setSecondComponent((JComponent)this.val$stackTraceLabel);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "name";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "type";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWithStackFrameView$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "classChanged";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "classRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)tree);
            this.mySplitter.setSecondComponent((JComponent)(tracker.isTracked(className2) ? stackComponent : stackTraceLabel));
        }
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.myHidedProportion = 0.7f;
        MemoryViewDebugProcessData data = (MemoryViewDebugProcessData)DebuggerManager.getInstance((Project)project).getDebugProcess(debugSession.getDebugProcess().getProcessHandler()).getUserData(MemoryViewDebugProcessData.KEY);
        tree.addTreeSelectionListener(e -> {
            ObjectReference ref = InstancesWithStackFrameView.getSelectedReference(tree);
            if (ref != null && data != null) {
                List<StackFrameItem> stack = data.getTrackedStacks().getStack(ref);
                if (stack != null) {
                    list.setFrameItems(stack);
                    if (this.mySplitter.getProportion() == 1.0f) {
                        this.mySplitter.setProportion(0.7f);
                    }
                    return;
                }
                list.setEmptyText(EMPTY_TEXT_WHEN_STACK_NOT_FOUND);
            } else {
                list.setEmptyText(EMPTY_TEXT_WHEN_ITEM_NOT_SELECTED);
            }
            list.setFrameItems(Collections.emptyList());
        });
    }

    @Nullable
    private static ObjectReference getSelectedReference(InstancesTree tree) {
        Value value2;
        NodeDescriptorImpl descriptor;
        XValueNodeImpl xValueNode;
        XValue valueContainer;
        Object selectedItem;
        TreePath selectionPath = tree.getSelectionPath();
        Object object = selectedItem = selectionPath != null ? selectionPath.getLastPathComponent() : null;
        if (selectedItem instanceof XValueNodeImpl && (valueContainer = (XValue)(xValueNode = (XValueNodeImpl)selectedItem).getValueContainer()) instanceof NodeDescriptorProvider && (descriptor = ((NodeDescriptorProvider)valueContainer).getDescriptor()) instanceof ValueDescriptor && (value2 = ((ValueDescriptor)((Object)descriptor)).getValue()) instanceof ObjectReference) {
            return (ObjectReference)value2;
        }
        return null;
    }

    JComponent getComponent() {
        return this.mySplitter;
    }

    private static boolean isArrayType(@NotNull String className2) {
        if (className2 == null) {
            InstancesWithStackFrameView.$$$reportNull$$$0(4);
        }
        return className2.contains("[]");
    }

    private void hideStackFrame() {
        if (!this.myIsHided) {
            this.myHidedProportion = this.mySplitter.getProportion();
            this.mySplitter.getSecondComponent().setVisible(false);
            this.mySplitter.setProportion(1.0f);
            this.myIsHided = true;
        }
    }

    private void showStackFrame() {
        if (this.myIsHided) {
            this.mySplitter.getSecondComponent().setVisible(true);
            this.mySplitter.setProportion(this.myHidedProportion);
            this.myIsHided = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWithStackFrameView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isArrayType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

