/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.debugger.memory.agent.MemoryAgentOperations;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.sun.jdi.ObjectReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class MemoryAgentImpl
implements MemoryAgent {
    static final MemoryAgent DISABLED = new MemoryAgentImpl(MemoryAgentCapabilities.DISABLED);
    private final MemoryAgentCapabilities myCapabilities;

    MemoryAgentImpl(@NotNull MemoryAgentCapabilities capabilities) {
        if (capabilities == null) {
            MemoryAgentImpl.$$$reportNull$$$0(0);
        }
        this.myCapabilities = capabilities;
    }

    @Override
    public long estimateObjectSize(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(1);
        }
        if (reference == null) {
            MemoryAgentImpl.$$$reportNull$$$0(2);
        }
        if (!this.myCapabilities.canEstimateObjectSize()) {
            throw new UnsupportedOperationException("Memory agent can't estimate object size");
        }
        return MemoryAgentOperations.estimateObjectSize(evaluationContext, reference);
    }

    @Override
    public long[] estimateObjectsSizes(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ObjectReference> references) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(3);
        }
        if (references == null) {
            MemoryAgentImpl.$$$reportNull$$$0(4);
        }
        if (!this.myCapabilities.canEstimateObjectsSizes()) {
            throw new UnsupportedOperationException("Memory agent can't estimate objects sizes");
        }
        return MemoryAgentOperations.estimateObjectsSizes(evaluationContext, references);
    }

    @Override
    @NotNull
    public ReferringObjectsInfo findReferringObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference, int limit) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentImpl.$$$reportNull$$$0(5);
        }
        if (reference == null) {
            MemoryAgentImpl.$$$reportNull$$$0(6);
        }
        if (!this.myCapabilities.canGetReferringObjects()) {
            throw new UnsupportedOperationException("Memory agent can't provide referring objects");
        }
        ReferringObjectsInfo referringObjectsInfo = MemoryAgentOperations.findReferringObjects(evaluationContext, reference, limit);
        if (referringObjectsInfo == null) {
            MemoryAgentImpl.$$$reportNull$$$0(7);
        }
        return referringObjectsInfo;
    }

    @Override
    @NotNull
    public MemoryAgentCapabilities capabilities() {
        MemoryAgentCapabilities memoryAgentCapabilities = this.myCapabilities;
        if (memoryAgentCapabilities == null) {
            MemoryAgentImpl.$$$reportNull$$$0(8);
        }
        return memoryAgentCapabilities;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capabilities";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/MemoryAgentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/MemoryAgentImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferringObjects";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "capabilities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "estimateObjectSize";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "estimateObjectsSizes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findReferringObjects";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

