/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MemoryAgentCapabilities {
    static final MemoryAgentCapabilities DISABLED = new MemoryAgentCapabilities(false, EnumSet.noneOf(Capability.class));
    private final boolean myIsLoaded;
    private final Set<Capability> myCapabilities;

    private MemoryAgentCapabilities(boolean isLoaded, @NotNull EnumSet<Capability> capabilitySet) {
        if (capabilitySet == null) {
            MemoryAgentCapabilities.$$$reportNull$$$0(0);
        }
        this.myIsLoaded = isLoaded;
        this.myCapabilities = EnumSet.copyOf(capabilitySet);
    }

    public boolean isLoaded() {
        return this.myIsLoaded;
    }

    public boolean canGetReferringObjects() {
        return this.check(Capability.GC_ROOTS);
    }

    public boolean canEstimateObjectSize() {
        return this.check(Capability.OBJECT_SIZE);
    }

    public boolean canEstimateObjectsSizes() {
        return this.check(Capability.OBJECTS_SIZES);
    }

    private boolean check(Capability capability) {
        return this.myCapabilities.contains((Object)capability);
    }

    public String toString() {
        return "Agent capabilities: " + this.myCapabilities.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilitySet", "com/intellij/debugger/memory/agent/MemoryAgentCapabilities", "<init>"));
    }

    static class Builder {
        private final EnumSet<Capability> myCapabilities = EnumSet.noneOf(Capability.class);

        Builder() {
        }

        public Builder setCanFindGcRoots(boolean value2) {
            return this.update(Capability.GC_ROOTS, value2);
        }

        public Builder setCanEstimateObjectSize(boolean value2) {
            return this.update(Capability.OBJECT_SIZE, value2);
        }

        public Builder setCanEstimateObjectsSizes(boolean value2) {
            return this.update(Capability.OBJECTS_SIZES, value2);
        }

        public MemoryAgentCapabilities buildLoaded() {
            return new MemoryAgentCapabilities(true, this.myCapabilities);
        }

        private Builder update(@NotNull Capability capability, boolean value2) {
            if (capability == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (!value2) {
                this.myCapabilities.remove((Object)capability);
            } else {
                this.myCapabilities.add(capability);
            }
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capability", "com/intellij/debugger/memory/agent/MemoryAgentCapabilities$Builder", "update"));
        }
    }

    private static enum Capability {
        GC_ROOTS,
        OBJECT_SIZE,
        OBJECTS_SIZES;

    }
}

