/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.memory.action.DebuggerTreeAction;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;

public abstract class MemoryAgentActionBase
extends DebuggerTreeAction {
    protected final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());

    protected void perform(final XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        if (nodeName == null) {
            MemoryAgentActionBase.$$$reportNull$$$0(0);
        }
        Project project = node.getTree().getProject();
        DebugProcessImpl debugProcess = JavaDebugProcess.getCurrentDebugProcess(project);
        final ObjectReference reference = this.getObjectReference(node);
        if (debugProcess == null || reference == null) {
            return;
        }
        SuspendContextImpl suspendContext = debugProcess.getSuspendManager().getPausedContext();
        debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                EvaluationContextImpl evaluationContext;
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((evaluationContext = suspendContext.getEvaluationContext()) == null) {
                    MemoryAgentActionBase.this.LOG.error("Evaluation impossible");
                    return;
                }
                try {
                    MemoryAgentActionBase.this.perform(evaluationContext, reference, node);
                }
                catch (EvaluateException ex) {
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification("Action failed", NotificationType.ERROR);
                }
            }

            @Override
            public void commandCancelled() {
                MemoryAgentActionBase.this.LOG.info("command cancelled");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/action/MemoryAgentActionBase$1", "contextAction"));
            }
        });
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        if (node == null) {
            MemoryAgentActionBase.$$$reportNull$$$0(1);
        }
        if (e == null) {
            MemoryAgentActionBase.$$$reportNull$$$0(2);
        }
        if (!super.isEnabled(node, e)) {
            return false;
        }
        DebugProcessImpl debugProcess = JavaDebugProcess.getCurrentDebugProcess(node.getTree().getProject());
        if (debugProcess == null || debugProcess.isEvaluationPossible() || !MemoryAgent.get(debugProcess).capabilities().isLoaded()) {
            e.getPresentation().setVisible(false);
            return false;
        }
        ObjectReference reference = this.getObjectReference(node);
        return reference != null && this.isEnabled(MemoryAgent.get(debugProcess).capabilities());
    }

    protected abstract boolean isEnabled(@NotNull MemoryAgentCapabilities var1);

    protected abstract void perform(@NotNull EvaluationContextImpl var1, @NotNull ObjectReference var2, @NotNull XValueNodeImpl var3) throws EvaluateException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/action/MemoryAgentActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

