/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.action.MemoryAgentActionBase;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;

public class CalculateRetainedSizeAction
extends MemoryAgentActionBase {
    @Override
    protected void perform(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference, @NotNull XValueNodeImpl node) throws EvaluateException {
        if (evaluationContext == null) {
            CalculateRetainedSizeAction.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            CalculateRetainedSizeAction.$$$reportNull$$$0(1);
        }
        if (node == null) {
            CalculateRetainedSizeAction.$$$reportNull$$$0(2);
        }
        MemoryAgent memoryAgent = MemoryAgent.get(evaluationContext.getDebugProcess());
        long size = memoryAgent.estimateObjectSize(evaluationContext, reference);
        ApplicationManager.getApplication().invokeLater(() -> new MessageDialog(node.getTree().getProject(), String.valueOf(size), "Size of the Object", ArrayUtilRt.EMPTY_STRING_ARRAY, 0, null, false).show());
    }

    @Override
    protected boolean isEnabled(@NotNull MemoryAgentCapabilities agentCapabilities) {
        if (agentCapabilities == null) {
            CalculateRetainedSizeAction.$$$reportNull$$$0(3);
        }
        return agentCapabilities.canEstimateObjectSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentCapabilities";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/action/CalculateRetainedSizeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

