/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.ReferenceType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface ClassesByNameProvider {
    public List<ReferenceType> get(@NotNull String var1);

    public static ClassesByNameProvider createCache(List<ReferenceType> allTypes) {
        return new Cache(allTypes);
    }

    public static final class Cache
    implements ClassesByNameProvider {
        private final MultiMap<String, ReferenceType> myCache = new MultiMap();

        public Cache(List<ReferenceType> classes2) {
            classes2.forEach(t -> this.myCache.putValue((Object)t.signature(), t));
        }

        @Override
        public List<ReferenceType> get(@NotNull String s) {
            String signature;
            if (s == null) {
                Cache.$$$reportNull$$$0(0);
            }
            if ((signature = VirtualMachineProxyImpl.JNITypeParserReflect.typeNameToSignature(s)) != null) {
                return (List)this.myCache.get((Object)signature);
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/debugger/jdi/ClassesByNameProvider$Cache", "get"));
        }
    }
}

