/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.sun.jdi.connect.Connector;

public class PidRemoteConnection
extends RemoteConnection {
    private final String myPid;
    private final boolean myFixedAddress;

    public PidRemoteConnection(String pid) {
        super(false, null, null, false);
        this.myFixedAddress = false;
        this.myPid = pid;
    }

    public PidRemoteConnection(String pid, boolean useSockets, String hostName, String address, boolean serverMode) {
        super(useSockets, hostName, address, serverMode);
        this.myFixedAddress = true;
        this.myPid = pid;
    }

    public String getPid() {
        return this.myPid;
    }

    public Connector getConnector(DebugProcessImpl debugProcess) throws ExecutionException {
        assert (!this.myFixedAddress);
        return DebugProcessImpl.findConnector("com.sun.jdi.ProcessAttach");
    }

    public boolean isFixedAddress() {
        return this.myFixedAddress;
    }
}

