/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerInlayUtil;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEditorLinePainter;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerInlayUtil {

    public static class Helper
    implements XDebuggerInlayUtil.Helper {
        private Editor currentEditor;
        private PsiMethod currentMethod;

        @Nullable
        private static Editor findEditor(@NotNull Project project, @NotNull VirtualFile file) {
            FileEditor editor;
            if (project == null) {
                Helper.$$$reportNull$$$0(0);
            }
            if (file == null) {
                Helper.$$$reportNull$$$0(1);
            }
            return (editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file)) instanceof TextEditor ? ((TextEditor)editor).getEditor() : null;
        }

        private static void setupValuePlaceholders(@NotNull Editor editor, @NotNull PsiMethod method) {
            PsiCodeBlock body2;
            if (editor == null) {
                Helper.$$$reportNull$$$0(2);
            }
            if (method == null) {
                Helper.$$$reportNull$$$0(3);
            }
            if ((body2 = method.getBody()) == null) {
                return;
            }
            PsiJavaToken lBrace = body2.getLBrace();
            PsiJavaToken rBrace = body2.getRBrace();
            if (lBrace == null || rBrace == null) {
                return;
            }
            Document document = editor.getDocument();
            int startLine = document.getLineNumber(lBrace.getTextOffset());
            int endLine = document.getLineNumber(rBrace.getTextOffset());
            EditorScrollingPositionKeeper.perform((Editor)editor, (boolean)true, () -> {
                for (int i = startLine; i < endLine; ++i) {
                    XDebuggerInlayUtil.createBlockInlay((Editor)editor, (int)document.getLineStartOffset(i));
                }
            });
        }

        public synchronized void setupValuePlaceholders(@NotNull Project project, @Nullable XSourcePosition currentPosition) {
            PsiMethod m;
            PsiFile psiFile;
            Editor e;
            if (project == null) {
                Helper.$$$reportNull$$$0(4);
            }
            Editor editor = null;
            PsiMethod method = null;
            if (currentPosition != null && (e = Helper.findEditor(project, currentPosition.getFile())) != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(e.getDocument())) != null && (m = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)currentPosition.getOffset(), PsiMethod.class, (boolean)false)) != null) {
                editor = e;
                method = m;
            }
            if (editor != this.currentEditor || method != this.currentMethod) {
                if (this.currentEditor != null) {
                    EditorScrollingPositionKeeper.perform(editor, (boolean)true, () -> XDebuggerInlayUtil.clearBlockInlays((Editor)this.currentEditor));
                }
                if (editor != null) {
                    Helper.setupValuePlaceholders(editor, method);
                }
                this.currentEditor = editor;
                this.currentMethod = method;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean showValueInBlockInlay(@NotNull Project project, @NotNull XValueNodeImpl node, @NotNull XSourcePosition position) {
            PsiFile psiFile;
            if (project == null) {
                Helper.$$$reportNull$$$0(5);
            }
            if (node == null) {
                Helper.$$$reportNull$$$0(6);
            }
            if (position == null) {
                Helper.$$$reportNull$$$0(7);
            }
            if ((psiFile = PsiManager.getInstance((Project)project).findFile(position.getFile())) == null) {
                return false;
            }
            int offset = position.getOffset();
            PsiMethod method = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, PsiMethod.class, (boolean)false);
            if (method == null) {
                return false;
            }
            Helper helper = this;
            synchronized (helper) {
                if (method != this.currentMethod) {
                    return false;
                }
            }
            SimpleColoredText text2 = XDebuggerEditorLinePainter.createPresentation((XValueNodeImpl)node);
            if (text2 == null) {
                return false;
            }
            String presentationText = text2.toString();
            UIUtil.invokeLaterIfNeeded(() -> {
                Editor editor = Helper.findEditor(project, position.getFile());
                Helper helper = this;
                synchronized (helper) {
                    if (editor == null || editor != this.currentEditor || method != this.currentMethod) {
                        return;
                    }
                }
                XDebuggerInlayUtil.addValueToBlockInlay((Editor)editor, (int)offset, (String)presentationText);
            });
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/impl/JavaDebuggerInlayUtil$Helper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findEditor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setupValuePlaceholders";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showValueInBlockInlay";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

