/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerParametersRunnerConfigurable;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PatchedRunnableState;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithRunnerSettings;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaPatchableProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDebuggerRunner
extends JavaPatchableProgramRunner<GenericDebuggerRunnerSettings> {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(1);
        }
        return executorId.equals(DefaultDebugExecutor.EXECUTOR_ID) && profile instanceof ModuleRunProfile && !(profile instanceof RunConfigurationWithSuppressedDefaultDebugAction);
    }

    @NotNull
    public String getRunnerId() {
        if ("Debug" == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(2);
        }
        return "Debug";
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(4);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.createContentDescriptor(state, env);
    }

    @Nullable
    protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(6);
        }
        if (state instanceof JavaCommandLine) {
            ProcessHandler handler;
            RunContentDescriptor descriptor;
            JavaParameters parameters2 = ((JavaCommandLine)state).getJavaParameters();
            GenericDebuggerRunner.runCustomPatchers((JavaParameters)parameters2, (Executor)environment.getExecutor(), (RunProfile)environment.getRunProfile());
            boolean isPollConnection = true;
            RemoteConnection connection = null;
            if (state instanceof RemoteConnectionCreator) {
                connection = ((RemoteConnectionCreator)state).createRemoteConnection(environment);
                isPollConnection = ((RemoteConnectionCreator)state).isPollConnection();
            }
            if (connection == null) {
                int transport;
                connection = DebuggerManagerImpl.createDebugParameters(parameters2, true, transport, (transport = DebuggerSettings.getInstance().getTransport()) == 0 ? "0" : "", false);
                isPollConnection = true;
            }
            if ((descriptor = this.attachVirtualMachine(state, environment, connection, isPollConnection)) != null && (handler = descriptor.getProcessHandler()) instanceof KillableProcessHandler) {
                ((KillableProcessHandler)handler).setShouldKillProcessSoftlyWithWinP(true);
            }
            return descriptor;
        }
        if (state instanceof PatchedRunnableState) {
            RemoteConnection connection = GenericDebuggerRunner.doPatch(new JavaParameters(), environment.getRunnerSettings(), true);
            return this.attachVirtualMachine(state, environment, connection, true);
        }
        if (state instanceof RemoteState) {
            RemoteConnection connection = GenericDebuggerRunner.createRemoteDebugConnection((RemoteState)state, environment.getRunnerSettings());
            return this.attachVirtualMachine(state, environment, connection, false);
        }
        return null;
    }

    @Nullable
    protected RunContentDescriptor attachVirtualMachine(RunProfileState state, @NotNull ExecutionEnvironment env, RemoteConnection connection, boolean pollConnection) throws ExecutionException {
        if (env == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(7);
        }
        return this.attachVirtualMachine(state, env, connection, pollConnection ? 30000L : 0L);
    }

    @Nullable
    protected RunContentDescriptor attachVirtualMachine(RunProfileState state, @NotNull ExecutionEnvironment env, RemoteConnection connection, long pollTimeout) throws ExecutionException {
        if (env == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(8);
        }
        DefaultDebugEnvironment environment = new DefaultDebugEnvironment(env, state, connection, pollTimeout);
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(env.getProject()).attachVirtualMachine(environment);
        if (debuggerSession == null) {
            return null;
        }
        final DebugProcessImpl debugProcess = debuggerSession.getProcess();
        return XDebuggerManager.getInstance((Project)env.getProject()).startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                XDebugSessionImpl sessionImpl = (XDebugSessionImpl)session;
                ExecutionResult executionResult = debugProcess.getExecutionResult();
                sessionImpl.addExtraActions(executionResult.getActions());
                if (executionResult instanceof DefaultExecutionResult) {
                    sessionImpl.addRestartActions(((DefaultExecutionResult)executionResult).getRestartActions());
                }
                JavaDebugProcess javaDebugProcess = JavaDebugProcess.create(session, debuggerSession);
                if (javaDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return javaDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/impl/GenericDebuggerRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/impl/GenericDebuggerRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }).getRunContentDescriptor();
    }

    private static RemoteConnection createRemoteDebugConnection(RemoteState connection, RunnerSettings settings) {
        RemoteConnection remoteConnection = connection.getRemoteConnection();
        GenericDebuggerRunnerSettings debuggerRunnerSettings = (GenericDebuggerRunnerSettings)settings;
        if (debuggerRunnerSettings != null) {
            remoteConnection.setUseSockets(debuggerRunnerSettings.getTransport() == 0);
            remoteConnection.setAddress(debuggerRunnerSettings.getDebugPort());
        }
        return remoteConnection;
    }

    public GenericDebuggerRunnerSettings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return new GenericDebuggerRunnerSettings();
    }

    public void patch(JavaParameters javaParameters, RunnerSettings settings, RunProfile runProfile, boolean beforeExecution) throws ExecutionException {
        GenericDebuggerRunner.doPatch(javaParameters, settings, beforeExecution);
        GenericDebuggerRunner.runCustomPatchers((JavaParameters)javaParameters, (Executor)((Executor)Executor.EXECUTOR_EXTENSION_NAME.findExtension(DefaultDebugExecutor.class)), (RunProfile)runProfile);
    }

    private static RemoteConnection doPatch(JavaParameters javaParameters, RunnerSettings settings, boolean beforeExecution) throws ExecutionException {
        GenericDebuggerRunnerSettings debuggerSettings = (GenericDebuggerRunnerSettings)settings;
        if (StringUtil.isEmpty((String)debuggerSettings.getDebugPort())) {
            debuggerSettings.setDebugPort(DebuggerUtils.getInstance().findAvailableDebugAddress(debuggerSettings.getTransport() == 0));
        }
        return new RemoteConnectionBuilder(debuggerSettings.LOCAL, debuggerSettings.getTransport(), debuggerSettings.getDebugPort()).asyncAgent(beforeExecution).memoryAgent(beforeExecution && DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT).create(javaParameters);
    }

    public SettingsEditor<GenericDebuggerRunnerSettings> getSettingsEditor(Executor executor, RunConfiguration configuration) {
        if (configuration instanceof RunConfigurationWithRunnerSettings && ((RunConfigurationWithRunnerSettings)configuration).isSettingsNeeded()) {
            return new GenericDebuggerParametersRunnerConfigurable(configuration.getProject());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/GenericDebuggerRunner";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/GenericDebuggerRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createContentDescriptor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "attachVirtualMachine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

