/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.impl.settings.DebuggerConfigurable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class GenericDebuggerParametersRunnerConfigurable
extends SettingsEditor<GenericDebuggerRunnerSettings> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.GenericDebuggerParametersRunnerConfigurable");
    private JPanel myPanel;
    private JTextField myAddressField;
    private JPanel myShMemPanel;
    private JPanel myPortPanel;
    private JTextField myPortField;
    private boolean myIsLocal = false;
    private JButton myDebuggerSettings;
    private JRadioButton mySocketTransport;
    private JRadioButton myShmemTransport;
    private JPanel myTransportPanel;

    public GenericDebuggerParametersRunnerConfigurable(final Project project) {
        this.$$$setupUI$$$();
        this.myDebuggerSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSettingsUtil.getInstance().showSettingsDialog(project, DebuggerConfigurable.class);
                if (GenericDebuggerParametersRunnerConfigurable.this.myIsLocal) {
                    GenericDebuggerParametersRunnerConfigurable.this.setTransport(DebuggerSettings.getInstance().getTransport());
                }
                GenericDebuggerParametersRunnerConfigurable.this.suggestAvailablePortIfNotSpecified();
                GenericDebuggerParametersRunnerConfigurable.this.updateUI();
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericDebuggerParametersRunnerConfigurable.this.suggestAvailablePortIfNotSpecified();
                GenericDebuggerParametersRunnerConfigurable.this.updateUI();
                GenericDebuggerParametersRunnerConfigurable.this.myPanel.repaint();
            }
        };
        this.mySocketTransport.addActionListener(listener);
        this.myShmemTransport.addActionListener(listener);
        this.updateUI();
        this.myTransportPanel.setVisible(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.mySocketTransport);
        group.add(this.myShmemTransport);
    }

    private boolean isSocket() {
        return this.getTransport() == 0;
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            GenericDebuggerParametersRunnerConfigurable.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private void updateUI() {
        this.myPortPanel.setVisible(this.isSocket());
        this.myShMemPanel.setVisible(!this.isSocket());
        this.myAddressField.setEditable(!this.myIsLocal);
        this.mySocketTransport.setEnabled(!this.myIsLocal);
        this.myShmemTransport.setEnabled(!this.myIsLocal);
    }

    public void resetEditorFrom(@NotNull GenericDebuggerRunnerSettings runnerSettings) {
        if (runnerSettings == null) {
            GenericDebuggerParametersRunnerConfigurable.$$$reportNull$$$0(1);
        }
        this.setIsLocal(runnerSettings.LOCAL);
        this.setTransport(runnerSettings.getTransport());
        this.setPort(StringUtil.notNullize((String)runnerSettings.getDebugPort()));
        this.suggestAvailablePortIfNotSpecified();
        this.updateUI();
    }

    private void suggestAvailablePortIfNotSpecified() {
        boolean isSocketTransport;
        String port = this.getPort();
        boolean portSpecified = !StringUtil.isEmpty((String)port);
        boolean bl = isSocketTransport = this.getTransport() == 0;
        if (isSocketTransport) {
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException ignored) {
                portSpecified = false;
            }
        }
        if (!portSpecified) {
            try {
                this.setPort(DebuggerUtils.getInstance().findAvailableDebugAddress(isSocketTransport));
            }
            catch (ExecutionException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private int getTransport() {
        if (this.myIsLocal) {
            return DebuggerSettings.getInstance().getTransport();
        }
        return this.mySocketTransport.isSelected() ? 0 : 1;
    }

    private String getPort() {
        if (this.isSocket()) {
            return String.valueOf(this.myPortField.getText());
        }
        return this.myAddressField.getText();
    }

    private void checkPort() throws ConfigurationException {
        if (this.isSocket() && this.parsePort() == 0) {
            throw new ConfigurationException(DebuggerBundle.message((String)"error.text.invalid.port", (Object[])new Object[0]));
        }
    }

    private int parsePort() {
        return Math.max(0, StringUtil.parseInt((String)this.myPortField.getText(), (int)0));
    }

    private void setTransport(int transport) {
        this.mySocketTransport.setSelected(transport == 0);
        this.myShmemTransport.setSelected(transport != 0);
    }

    private void setIsLocal(boolean b) {
        this.myTransportPanel.setVisible(true);
        this.myDebuggerSettings.setVisible(b);
        this.myIsLocal = b;
    }

    private void setPort(String port) {
        if (this.isSocket()) {
            this.myPortField.setText(String.valueOf(StringUtilRt.parseInt((String)port, (int)0)));
        } else {
            this.myAddressField.setText(port);
        }
    }

    public void applyEditorTo(@NotNull GenericDebuggerRunnerSettings runnerSettings) throws ConfigurationException {
        if (runnerSettings == null) {
            GenericDebuggerParametersRunnerConfigurable.$$$reportNull$$$0(2);
        }
        runnerSettings.LOCAL = this.myIsLocal;
        this.checkPort();
        runnerSettings.setDebugPort(this.getPort());
        if (!this.myIsLocal) {
            runnerSettings.setTransport(this.getTransport());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/GenericDebuggerParametersRunnerConfigurable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/GenericDebuggerParametersRunnerConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        JButton jButton;
        JTextField jTextField;
        JPanel jPanel2;
        JTextField jTextField2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myShMemPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.generic.debugger.parameters.patcher.configurable.shmem.address"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myAddressField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        this.myPortPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.generic.debugger.parameters.patcher.configurable.port"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPortField = jTextField = new JTextField();
        jTextField.setColumns(5);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myDebuggerSettings = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/DebuggerBundle").getString("button.debugger.settings"));
        jPanel4.add((Component)jButton, new GridConstraints(1, 1, 2, 1, 8, 0, 3, 0, null, null, null));
        this.myTransportPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.generic.debugger.parameters.patcher.configurable.transport"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySocketTransport = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.generic.debugger.parameters.patcher.configurable.socket"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShmemTransport = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.generic.debugger.parameters.patcher.configurable.shmem"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

