/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.SourcePositionHighlighter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.content.Content;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerUtilsEx
extends DebuggerUtils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerUtilsEx");
    private static int myThreadDumpsCount = 0;
    private static final Key<Map<String, String>> DEBUGGER_ALTERNATIVE_SOURCE_MAPPING = Key.create((String)"DEBUGGER_ALTERNATIVE_SOURCE_MAPPING");
    public static final Comparator<Method> LAMBDA_ORDINAL_COMPARATOR = Comparator.comparingInt(m -> DebuggerUtilsEx.getLambdaOrdinal(m.name()));

    public static List<CodeFragmentFactory> getCodeFragmentFactories(@Nullable PsiElement context) {
        DefaultCodeFragmentFactory defaultFactory = DefaultCodeFragmentFactory.getInstance();
        List providers2 = CodeFragmentFactory.EXTENSION_POINT_NAME.getExtensionList();
        ArrayList<CodeFragmentFactory> suitableFactories = new ArrayList<CodeFragmentFactory>(providers2.size());
        if (providers2.size() > 0) {
            for (CodeFragmentFactory factory : providers2) {
                if (factory == defaultFactory || !factory.isContextAccepted(context)) continue;
                suitableFactories.add(factory);
            }
        }
        suitableFactories.add(defaultFactory);
        return suitableFactories;
    }

    public static PsiMethod findPsiMethod(PsiFile file, int offset) {
        PsiElement element = null;
        while (offset >= 0 && (element = file.findElementAt(offset)) == null) {
            --offset;
        }
        while (element != null) {
            if (element instanceof PsiClass || element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiMethod) {
                return (PsiMethod)element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static boolean isAssignableFrom(@NotNull String baseQualifiedName, @NotNull Type checkedType) {
        if (baseQualifiedName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(0);
        }
        if (checkedType == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(1);
        }
        if (checkedType instanceof ReferenceType) {
            if ("java.lang.Object".equals(baseQualifiedName)) {
                return true;
            }
            return DebuggerUtilsEx.getSuperClass(baseQualifiedName, (ReferenceType)checkedType) != null;
        }
        return baseQualifiedName.equals(checkedType.name());
    }

    public static ReferenceType getSuperClass(@NotNull String baseQualifiedName, @NotNull ReferenceType checkedType) {
        if (baseQualifiedName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(2);
        }
        if (checkedType == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(3);
        }
        if (baseQualifiedName.equals(checkedType.name())) {
            return checkedType;
        }
        if (checkedType instanceof ClassType) {
            ReferenceType superClass;
            ClassType classType = (ClassType)checkedType;
            ClassType superClassType = classType.superclass();
            if (superClassType != null && (superClass = DebuggerUtilsEx.getSuperClass(baseQualifiedName, superClassType)) != null) {
                return superClass;
            }
            List<InterfaceType> interfaces = classType.allInterfaces();
            for (InterfaceType iface : interfaces) {
                ReferenceType superClass2 = DebuggerUtilsEx.getSuperClass(baseQualifiedName, iface);
                if (superClass2 == null) continue;
                return superClass2;
            }
        }
        if (checkedType instanceof InterfaceType) {
            List<InterfaceType> list = ((InterfaceType)checkedType).superinterfaces();
            for (InterfaceType superInterface : list) {
                ReferenceType superClass = DebuggerUtilsEx.getSuperClass(baseQualifiedName, superInterface);
                if (superClass == null) continue;
                return superClass;
            }
        }
        return null;
    }

    public static boolean valuesEqual(Value val1, Value val2) {
        if (val1 == null) {
            return val2 == null;
        }
        if (val2 == null) {
            return false;
        }
        if (val1 instanceof StringReference && val2 instanceof StringReference) {
            return ((StringReference)val1).value().equals(((StringReference)val2).value());
        }
        return val1.equals(val2);
    }

    public static ClassFilter create(Element element) throws InvalidDataException {
        ClassFilter filter = new ClassFilter();
        DefaultJDOMExternalizer.readExternal((Object)filter, (Element)element);
        return filter;
    }

    private static boolean isFiltered(ClassFilter classFilter, String qName) {
        if (!classFilter.isEnabled()) {
            return false;
        }
        try {
            if (classFilter.matches(qName)) {
                return true;
            }
        }
        catch (PatternSyntaxException e) {
            LOG.debug((Throwable)e);
        }
        return false;
    }

    public static boolean isFiltered(@NotNull String qName, ClassFilter[] classFilters) {
        if (qName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(4);
        }
        return DebuggerUtilsEx.isFiltered(qName, Arrays.asList(classFilters));
    }

    public static boolean isFiltered(@NotNull String qName, List<? extends ClassFilter> classFilters) {
        if (qName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(5);
        }
        if (qName.indexOf(91) != -1) {
            return false;
        }
        return classFilters.stream().anyMatch(filter -> DebuggerUtilsEx.isFiltered(filter, qName));
    }

    public static int getEnabledNumber(ClassFilter[] classFilters) {
        return (int)Arrays.stream(classFilters).filter(ClassFilter::isEnabled).count();
    }

    public static ClassFilter[] readFilters(List<? extends Element> children) {
        if (ContainerUtil.isEmpty(children)) {
            return ClassFilter.EMPTY_ARRAY;
        }
        ClassFilter[] filters = new ClassFilter[children.size()];
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            try {
                filters[i] = DebuggerUtilsEx.create(children.get(i));
                continue;
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
        return filters;
    }

    public static void writeFilters(@NotNull Element parentNode, @NonNls String tagName, ClassFilter[] filters) throws WriteExternalException {
        if (parentNode == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(6);
        }
        for (ClassFilter filter : filters) {
            Element element = new Element(tagName);
            parentNode.addContent(element);
            DefaultJDOMExternalizer.writeExternal((Object)filter, (Element)element);
        }
    }

    public static boolean filterEquals(ClassFilter[] filters1, ClassFilter[] filters2) {
        if (filters1.length != filters2.length) {
            return false;
        }
        HashSet f1 = new HashSet(Math.max((int)((float)filters1.length / 0.75f) + 1, 16));
        HashSet f2 = new HashSet(Math.max((int)((float)filters2.length / 0.75f) + 1, 16));
        Collections.addAll(f1, filters1);
        Collections.addAll(f2, filters2);
        return f2.equals(f1);
    }

    private static boolean elementListsEqual(List<? extends Element> l1, List<? extends Element> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<? extends Element> i1 = l1.iterator();
        for (Element element : l2) {
            Element elem1 = i1.next();
            if (DebuggerUtilsEx.elementsEqual(elem1, element)) continue;
            return false;
        }
        return true;
    }

    private static boolean attributeListsEqual(List<? extends Attribute> l1, List<? extends Attribute> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<? extends Attribute> i1 = l1.iterator();
        for (Attribute attribute : l2) {
            Attribute attr1 = i1.next();
            if (Comparing.equal((String)attr1.getName(), (String)attribute.getName()) && Comparing.equal((String)attr1.getValue(), (String)attribute.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean elementsEqual(Element e1, Element e2) {
        if (e1 == null) {
            return e2 == null;
        }
        if (!Comparing.equal((String)e1.getName(), (String)e2.getName())) {
            return false;
        }
        if (!DebuggerUtilsEx.elementListsEqual(e1.getChildren(), e2.getChildren())) {
            return false;
        }
        return DebuggerUtilsEx.attributeListsEqual(e1.getAttributes(), e2.getAttributes());
    }

    public static boolean externalizableEqual(JDOMExternalizable e1, JDOMExternalizable e2) {
        Element root1 = new Element("root");
        Element root2 = new Element("root");
        try {
            e1.writeExternal(root1);
        }
        catch (WriteExternalException e) {
            LOG.debug((Throwable)e);
        }
        try {
            e2.writeExternal(root2);
        }
        catch (WriteExternalException e) {
            LOG.debug((Throwable)e);
        }
        return DebuggerUtilsEx.elementsEqual(root1, root2);
    }

    @NotNull
    public static List<Pair<Breakpoint, Event>> getEventDescriptors(@Nullable SuspendContextImpl suspendContext) {
        EventSet events;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (suspendContext != null && !ContainerUtil.isEmpty((Collection)(events = suspendContext.getEventSet()))) {
            List eventDescriptors = ContainerUtil.newSmartList();
            for (Event event : events) {
                Requestor requestor = RequestManagerImpl.findRequestor(event.request());
                if (!(requestor instanceof Breakpoint)) continue;
                eventDescriptors.add(Pair.create((Object)((Breakpoint)requestor), (Object)event));
            }
            List list = eventDescriptors;
            if (list == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<Pair<Breakpoint, Event>> list = Collections.emptyList();
        if (list == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(8);
        }
        return list;
    }

    public static void addThreadDump(Project project, List<ThreadState> threads, RunnerLayoutUi ui, GlobalSearchScope searchScope) {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        consoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)searchScope));
        ConsoleView consoleView = consoleBuilder.getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        consoleView.allowHeavyFilters();
        ThreadDumpPanel panel = new ThreadDumpPanel(project, consoleView, toolbarActions, threads);
        String id = "Dump " + DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
        Content content = ui.createContent(id + " " + myThreadDumpsCount, (JComponent)panel, id, null, null);
        content.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)Boolean.TRUE);
        content.setCloseable(true);
        content.setDescription("Thread Dump");
        ui.addContent(content);
        ui.selectAndFocus(content, true, true);
        ++myThreadDumpsCount;
        Disposer.register((Disposable)content, (Disposable)consoleView);
        ui.selectAndFocus(content, true, false);
        if (threads.size() > 0) {
            panel.selectStackFrame(0);
        }
    }

    @Deprecated
    public static void keep(Value value2, EvaluationContext context) {
        context.keep(value2);
    }

    public static StringReference mirrorOfString(@NotNull String s, VirtualMachineProxyImpl virtualMachineProxy, EvaluationContext context) throws EvaluateException {
        if (s == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(9);
        }
        return (StringReference)context.computeAndKeep(() -> virtualMachineProxy.mirrorOf(s));
    }

    public static ArrayReference mirrorOfArray(@NotNull ArrayType arrayType, int dimension, EvaluationContext context) throws EvaluateException {
        if (arrayType == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(10);
        }
        return (ArrayReference)context.computeAndKeep(() -> context.getDebugProcess().newInstance(arrayType, dimension));
    }

    @NotNull
    public static CodeFragmentFactory getCodeFragmentFactory(@Nullable PsiElement context, @Nullable FileType fileType) {
        DefaultCodeFragmentFactory defaultFactory = DefaultCodeFragmentFactory.getInstance();
        if (fileType == null) {
            if (context == null) {
                DefaultCodeFragmentFactory defaultCodeFragmentFactory = defaultFactory;
                if (defaultCodeFragmentFactory == null) {
                    DebuggerUtilsEx.$$$reportNull$$$0(11);
                }
                return defaultCodeFragmentFactory;
            }
            PsiFile file = context.getContainingFile();
            fileType = file != null ? file.getFileType() : null;
        }
        for (CodeFragmentFactory factory : CodeFragmentFactory.EXTENSION_POINT_NAME.getExtensionList()) {
            if (factory == defaultFactory || fileType != null && !factory.getFileType().equals(fileType) || !factory.isContextAccepted(context)) continue;
            CodeFragmentFactory codeFragmentFactory = factory;
            if (codeFragmentFactory == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(12);
            }
            return codeFragmentFactory;
        }
        DefaultCodeFragmentFactory defaultCodeFragmentFactory = defaultFactory;
        if (defaultCodeFragmentFactory == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(13);
        }
        return defaultCodeFragmentFactory;
    }

    @NotNull
    public static CodeFragmentFactory findAppropriateCodeFragmentFactory(TextWithImports text2, PsiElement context) {
        CodeFragmentFactory factory = (CodeFragmentFactory)ReadAction.compute(() -> DebuggerUtilsEx.getCodeFragmentFactory(context, text2.getFileType()));
        CodeFragmentFactoryContextWrapper codeFragmentFactoryContextWrapper = new CodeFragmentFactoryContextWrapper(factory);
        if (codeFragmentFactoryContextWrapper == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(14);
        }
        return codeFragmentFactoryContextWrapper;
    }

    public static String methodKey(Method m) {
        return m.declaringType().name() + '.' + m.name() + m.signature();
    }

    public static String methodNameWithArguments(Method m) {
        return m.name() + "(" + StringUtil.join(m.argumentTypeNames(), StringUtil::getShortName, (String)", ") + ")";
    }

    public static String methodName(Method m) {
        return DebuggerUtilsEx.methodName(DebuggerUtilsEx.signatureToName(m.declaringType().signature()), m.name(), m.signature());
    }

    public static String methodName(final String className2, final String methodName, String signature) {
        try {
            return new SigReader(signature){

                @Override
                String getMethodName() {
                    return methodName;
                }

                @Override
                String getClassName() {
                    return className2;
                }
            }.getSignature();
        }
        catch (Exception ignored) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Internal error : unknown signature" + signature);
            }
            return className2 + "." + methodName;
        }
    }

    public static String signatureToName(String s) {
        return new SigReader(s).getSignature();
    }

    @Nullable
    public static List<Location> allLineLocations(Method method) {
        try {
            return method.allLineLocations();
        }
        catch (AbsentInformationException ignored) {
            return null;
        }
    }

    @Nullable
    public static List<Location> allLineLocations(ReferenceType cls) {
        try {
            return cls.allLineLocations();
        }
        catch (AbsentInformationException ignored) {
            return null;
        }
        catch (ObjectCollectedException ignored) {
            return Collections.emptyList();
        }
    }

    public static int getLineNumber(Location location, boolean zeroBased) {
        try {
            return location.lineNumber() - (zeroBased ? 1 : 0);
        }
        catch (IllegalArgumentException | InternalError e) {
            return -1;
        }
    }

    public static String getSourceName(Location location, Function<? super Throwable, String> defaultName) {
        try {
            return location.sourceName();
        }
        catch (AbsentInformationException | InternalError e) {
            return defaultName.apply(e);
        }
    }

    public static boolean isVoid(@NotNull Method method) {
        if (method == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(15);
        }
        return "void".equals(method.returnTypeName());
    }

    @Nullable
    public static Method getMethod(Location location) {
        try {
            return location.method();
        }
        catch (IllegalArgumentException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public static List<Value> getArgumentValues(@NotNull StackFrame frame) {
        if (frame == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(16);
        }
        try {
            return frame.getArgumentValues();
        }
        catch (InternalException e) {
            if (e.errorCode() == 32) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, double value2) {
        if (PsiType.DOUBLE.getName().equals(expectedType)) {
            return vm.mirrorOf(value2);
        }
        if (PsiType.FLOAT.getName().equals(expectedType)) {
            return vm.mirrorOf((float)value2);
        }
        if (PsiType.LONG.getName().equals(expectedType)) {
            return vm.mirrorOf((long)value2);
        }
        if (PsiType.INT.getName().equals(expectedType)) {
            return vm.mirrorOf((int)value2);
        }
        if (PsiType.SHORT.getName().equals(expectedType)) {
            return vm.mirrorOf((short)value2);
        }
        if (PsiType.BYTE.getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value2);
        }
        if (PsiType.CHAR.getName().equals(expectedType)) {
            return vm.mirrorOf((char)value2);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, long value2) {
        if (PsiType.LONG.getName().equals(expectedType)) {
            return vm.mirrorOf(value2);
        }
        if (PsiType.INT.getName().equals(expectedType)) {
            return vm.mirrorOf((int)value2);
        }
        if (PsiType.SHORT.getName().equals(expectedType)) {
            return vm.mirrorOf((short)value2);
        }
        if (PsiType.BYTE.getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value2);
        }
        if (PsiType.CHAR.getName().equals(expectedType)) {
            return vm.mirrorOf((char)value2);
        }
        if (PsiType.DOUBLE.getName().equals(expectedType)) {
            return vm.mirrorOf((double)value2);
        }
        if (PsiType.FLOAT.getName().equals(expectedType)) {
            return vm.mirrorOf((float)value2);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, boolean value2) {
        if (PsiType.BOOLEAN.getName().equals(expectedType)) {
            return vm.mirrorOf(value2);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, char value2) {
        if (PsiType.CHAR.getName().equals(expectedType)) {
            return vm.mirrorOf(value2);
        }
        if (PsiType.LONG.getName().equals(expectedType)) {
            return vm.mirrorOf((long)value2);
        }
        if (PsiType.INT.getName().equals(expectedType)) {
            return vm.mirrorOf((int)value2);
        }
        if (PsiType.SHORT.getName().equals(expectedType)) {
            return vm.mirrorOf((short)value2);
        }
        if (PsiType.BYTE.getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value2);
        }
        if (PsiType.DOUBLE.getName().equals(expectedType)) {
            return vm.mirrorOf((double)value2);
        }
        if (PsiType.FLOAT.getName().equals(expectedType)) {
            return vm.mirrorOf((float)value2);
        }
        return null;
    }

    public static String truncateString(String str) {
        if (str.length() > 1005) {
            return str.substring(0, 1005);
        }
        return str;
    }

    public static String getThreadStatusText(int statusId) {
        switch (statusId) {
            case 3: {
                return DebuggerBundle.message((String)"status.thread.monitor", (Object[])new Object[0]);
            }
            case 5: {
                return DebuggerBundle.message((String)"status.thread.not.started", (Object[])new Object[0]);
            }
            case 1: {
                return DebuggerBundle.message((String)"status.thread.running", (Object[])new Object[0]);
            }
            case 2: {
                return DebuggerBundle.message((String)"status.thread.sleeping", (Object[])new Object[0]);
            }
            case -1: {
                return DebuggerBundle.message((String)"status.thread.unknown", (Object[])new Object[0]);
            }
            case 4: {
                return DebuggerBundle.message((String)"status.thread.wait", (Object[])new Object[0]);
            }
            case 0: {
                return DebuggerBundle.message((String)"status.thread.zombie", (Object[])new Object[0]);
            }
        }
        return DebuggerBundle.message((String)"status.thread.undefined", (Object[])new Object[0]);
    }

    public static String prepareValueText(String text2, Project project) {
        text2 = StringUtil.unquoteString((String)text2);
        text2 = StringUtil.unescapeStringCharacters((String)text2);
        int tabSize = CodeStyle.getSettings((Project)project).getTabSize((FileType)StdFileTypes.JAVA);
        if (tabSize < 0) {
            tabSize = 0;
        }
        return text2.replace("\t", StringUtil.repeat((String)" ", (int)tabSize));
    }

    public static void setAlternativeSourceUrl(String className2, String source, Project project) {
        ConcurrentHashMap<String, String> map2 = (ConcurrentHashMap<String, String>)project.getUserData(DEBUGGER_ALTERNATIVE_SOURCE_MAPPING);
        if (map2 == null) {
            map2 = new ConcurrentHashMap<String, String>();
            project.putUserData(DEBUGGER_ALTERNATIVE_SOURCE_MAPPING, map2);
        }
        map2.put(className2, source);
    }

    @Nullable
    public static String getAlternativeSourceUrl(@Nullable String className2, Project project) {
        Map map2 = (Map)project.getUserData(DEBUGGER_ALTERNATIVE_SOURCE_MAPPING);
        return map2 != null ? (String)map2.get(className2) : null;
    }

    @Nullable
    public static XSourcePosition toXSourcePosition(@Nullable SourcePosition position) {
        if (position != null) {
            VirtualFile file = position.getFile().getVirtualFile();
            if (file == null) {
                file = position.getFile().getOriginalFile().getVirtualFile();
            }
            if (file != null) {
                return new JavaXSourcePosition(position, file);
            }
        }
        return null;
    }

    @Nullable
    public static SourcePosition toSourcePosition(@Nullable XSourcePosition position, Project project) {
        if (position != null) {
            if (position instanceof JavaXSourcePosition) {
                return ((JavaXSourcePosition)position).mySourcePosition;
            }
            PsiFile psiFile = DebuggerUtilsEx.getPsiFile(position, project);
            if (psiFile != null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)position.getLine());
            }
        }
        return null;
    }

    @Nullable
    public static TextRange intersectWithLine(@Nullable TextRange range, @Nullable PsiFile file, int line) {
        Document document;
        if (range != null && file != null && (document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) != null) {
            range = range.intersection(DocumentUtil.getLineTextRange((Document)document, (int)line));
        }
        return range;
    }

    @Nullable
    public static PsiFile getPsiFile(@Nullable XSourcePosition position, Project project) {
        VirtualFile file;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (position != null && (file = position.getFile()).isValid()) {
            return PsiManager.getInstance((Project)project).findFile(file);
        }
        return null;
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiFile file, int offset) {
        return file != null ? file.findElementAt(offset) : null;
    }

    public static String getLocationMethodQName(@NotNull Location location) {
        if (location == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(17);
        }
        StringBuilder res = new StringBuilder();
        ReferenceType type2 = location.declaringType();
        if (type2 != null) {
            res.append(type2.name()).append('.');
        }
        res.append(location.method().name());
        return res.toString();
    }

    private static PsiElement getNextElement(PsiElement element) {
        PsiElement sibling = element.getNextSibling();
        if (sibling != null) {
            return sibling;
        }
        if ((element = element.getParent()) != null) {
            return DebuggerUtilsEx.getNextElement(element);
        }
        return null;
    }

    public static boolean isLambdaClassName(String typeName) {
        return DebuggerUtilsEx.getLambdaBaseClassName(typeName) != null;
    }

    @Nullable
    public static String getLambdaBaseClassName(String typeName) {
        return StringUtil.substringBefore((String)typeName, (String)"$$Lambda$");
    }

    public static boolean isLambdaName(@Nullable String name2) {
        return !StringUtil.isEmpty((String)name2) && name2.startsWith("lambda$");
    }

    public static boolean isLambda(@Nullable Method method) {
        return method != null && DebuggerUtilsEx.isLambdaName(method.name());
    }

    public static boolean isProxyClassName(@Nullable String name2) {
        return !StringUtil.isEmpty((String)name2) && StringUtil.getShortName((String)name2).startsWith("$Proxy");
    }

    public static boolean isProxyClass(@Nullable ReferenceType type2) {
        return type2 instanceof ClassType && DebuggerUtilsEx.isProxyClassName(type2.name());
    }

    public static int getLambdaOrdinal(@NotNull String name2) {
        if (name2 == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(18);
        }
        return StringUtil.parseInt((String)StringUtil.substringAfterLast((String)name2, (String)"$"), (int)-1);
    }

    public static List<PsiLambdaExpression> collectLambdas(@NotNull SourcePosition position, final boolean onlyOnTheLine) {
        PsiElement parent;
        if (position == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile file = position.getFile();
        final int line = position.getLine();
        final Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null || line >= document.getLineCount()) {
            return Collections.emptyList();
        }
        PsiElement element = position.getElementAt();
        if (element == null) {
            return Collections.emptyList();
        }
        TextRange lineRange = DocumentUtil.getLineTextRange((Document)document, (int)line);
        while ((parent = element.getParent()) != null && parent.getTextOffset() >= lineRange.getStartOffset()) {
            element = parent;
        }
        SmartList lambdas = new SmartList();
        JavaRecursiveElementVisitor lambdaCollector = new JavaRecursiveElementVisitor((List)lambdas){
            final /* synthetic */ List val$lambdas;
            {
                this.val$lambdas = list;
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                super.visitLambdaExpression(expression2);
                if (!onlyOnTheLine || DebuggerUtilsEx.getFirstElementOnTheLine(expression2, document, line) != null) {
                    this.val$lambdas.add(expression2);
                }
            }
        };
        element.accept((PsiElementVisitor)lambdaCollector);
        PsiElement sibling = DebuggerUtilsEx.getNextElement(element);
        while (sibling != null && DebuggerUtilsEx.intersects(lineRange, sibling)) {
            sibling.accept((PsiElementVisitor)lambdaCollector);
            sibling = DebuggerUtilsEx.getNextElement(sibling);
        }
        PsiElement method = DebuggerUtilsEx.getContainingMethod(element);
        if (method instanceof PsiLambdaExpression && !lambdas.contains(method)) {
            lambdas.add((PsiLambdaExpression)method);
        }
        return lambdas;
    }

    @Nullable
    public static PsiElement getBody(PsiElement method) {
        if (method instanceof PsiParameterListOwner) {
            return ((PsiParameterListOwner)method).getBody();
        }
        if (method instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)method).getBody();
        }
        return null;
    }

    @NotNull
    public static PsiParameter[] getParameters(PsiElement method) {
        if (method instanceof PsiParameterListOwner) {
            PsiParameter[] psiParameterArray = ((PsiParameterListOwner)method).getParameterList().getParameters();
            if (psiParameterArray == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(20);
            }
            return psiParameterArray;
        }
        if (PsiParameter.EMPTY_ARRAY == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(21);
        }
        return PsiParameter.EMPTY_ARRAY;
    }

    public static boolean evaluateBoolean(ExpressionEvaluator evaluator, EvaluationContextImpl context) throws EvaluateException {
        Object value2 = UnBoxingEvaluator.unbox(evaluator.evaluate((EvaluationContext)context), context);
        if (!(value2 instanceof BooleanValue)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.boolean.expected", (Object[])new Object[0]));
        }
        return ((BooleanValue)value2).booleanValue();
    }

    public static boolean intersects(@NotNull TextRange range, @NotNull PsiElement elem) {
        TextRange elemRange;
        if (range == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(22);
        }
        if (elem == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(23);
        }
        return (elemRange = elem.getTextRange()) != null && elemRange.intersects(range);
    }

    @Nullable
    public static PsiElement getFirstElementOnTheLine(PsiLambdaExpression lambda2, Document document, int line) {
        PsiStatement[] statements;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TextRange lineRange = DocumentUtil.getLineTextRange((Document)document, (int)line);
        if (!DebuggerUtilsEx.intersects(lineRange, (PsiElement)lambda2)) {
            return null;
        }
        PsiElement body2 = lambda2.getBody();
        if (body2 == null || !DebuggerUtilsEx.intersects(lineRange, body2)) {
            return null;
        }
        if (body2 instanceof PsiCodeBlock && (statements = ((PsiCodeBlock)body2).getStatements()).length > 0) {
            for (PsiStatement statement : statements) {
                if (lineRange.contains(statement.getTextOffset())) {
                    return statement;
                }
                if (!DebuggerUtilsEx.intersects(lineRange, (PsiElement)statement)) continue;
                for (PsiElement element : SyntaxTraverser.psiTraverser((PsiElement)statement)) {
                    if (!lineRange.contains(element.getTextOffset())) continue;
                    return element;
                }
            }
            return null;
        }
        return body2;
    }

    public static boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        PsiElement elem;
        if (pos == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(24);
        }
        if (method == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(25);
        }
        if ((elem = pos.getElementAt()) == null) {
            return false;
        }
        return Comparing.equal((Object)DebuggerUtilsEx.getContainingMethod(elem), (Object)method);
    }

    public static boolean methodMatches(@NotNull PsiMethod psiMethod, String className2, String name2, String signature, DebugProcessImpl process2) {
        if (psiMethod == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(26);
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        try {
            if (containingClass != null && JVMNameUtil.getJVMMethodName(psiMethod).equals(name2) && JVMNameUtil.getJVMSignature(psiMethod).getName(process2).equals(signature)) {
                String methodClassName = JVMNameUtil.getClassVMName(containingClass);
                if (Objects.equals(methodClassName, className2)) {
                    return true;
                }
                if (methodClassName != null) {
                    return process2.getVirtualMachineProxy().classesByName(className2).stream().anyMatch(t -> DebuggerUtilsEx.instanceOf((Type)t, (String)methodClassName));
                }
            }
        }
        catch (EvaluateException e) {
            LOG.debug((Throwable)e);
        }
        return false;
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable PsiElement elem) {
        return PsiTreeUtil.getContextOfType((PsiElement)elem, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClassInitializer.class});
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable SourcePosition position) {
        if (position == null) {
            return null;
        }
        return DebuggerUtilsEx.getContainingMethod(position.getElementAt());
    }

    public static void disableCollection(ObjectReference reference) {
        try {
            reference.disableCollection();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void enableCollection(ObjectReference reference) {
        try {
            reference.enableCollection();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static int bytecodeToSourceLine(PsiFile psiFile, int originalLine) {
        int line;
        LineNumbersMapping mapping;
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null && (mapping = (LineNumbersMapping)file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null && (line = mapping.bytecodeToSource(originalLine + 1)) > -1) {
            return line - 1;
        }
        return -1;
    }

    public static boolean isInLibraryContent(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(27);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (file == null) {
                return true;
            }
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            return projectFileIndex.isInLibrary(file);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseQualifiedName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsEx";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsEx";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventDescriptors";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragmentFactory";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findAppropriateCodeFragmentFactory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFrom";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFiltered";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeFilters";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mirrorOfString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mirrorOfArray";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isVoid";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentValues";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLocationMethodQName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaOrdinal";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectLambdas";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "inTheMethod";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "methodMatches";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JavaXSourcePosition
    implements XSourcePosition,
    ExecutionPointHighlighter.HighlighterProvider {
        private final SourcePosition mySourcePosition;
        @NotNull
        private final VirtualFile myFile;

        JavaXSourcePosition(@NotNull SourcePosition sourcePosition, @NotNull VirtualFile file) {
            if (sourcePosition == null) {
                JavaXSourcePosition.$$$reportNull$$$0(0);
            }
            if (file == null) {
                JavaXSourcePosition.$$$reportNull$$$0(1);
            }
            this.mySourcePosition = sourcePosition;
            this.myFile = file;
        }

        public int getLine() {
            return this.mySourcePosition.getLine();
        }

        public int getOffset() {
            return this.mySourcePosition.getOffset();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                JavaXSourcePosition.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        @NotNull
        public Navigatable createNavigatable(@NotNull Project project) {
            if (project == null) {
                JavaXSourcePosition.$$$reportNull$$$0(3);
            }
            OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor((Project)project, (XSourcePosition)this);
            if (openFileDescriptor == null) {
                JavaXSourcePosition.$$$reportNull$$$0(4);
            }
            return openFileDescriptor;
        }

        @Nullable
        public TextRange getHighlightRange() {
            return DebuggerUtilsEx.intersectWithLine(SourcePositionHighlighter.getHighlightRangeFor((SourcePosition)this.mySourcePosition), this.mySourcePosition.getFile(), this.getLine());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePosition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNavigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createNavigatable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SigReader {
        final String buffer;
        int pos = 0;

        SigReader(String s) {
            this.buffer = s;
        }

        int get() {
            return this.buffer.charAt(this.pos++);
        }

        int peek() {
            return this.buffer.charAt(this.pos);
        }

        boolean eof() {
            return this.buffer.length() <= this.pos;
        }

        @NonNls
        String getSignature() {
            if (this.eof()) {
                return "";
            }
            switch (this.get()) {
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 86: {
                    return "void";
                }
                case 76: {
                    int start = this.pos;
                    this.pos = this.buffer.indexOf(59, start) + 1;
                    LOG.assertTrue(this.pos > 0);
                    return this.buffer.substring(start, this.pos - 1).replace('/', '.');
                }
                case 91: {
                    return this.getSignature() + "[]";
                }
                case 40: {
                    StringBuilder result = new StringBuilder("(");
                    String separator = "";
                    while (this.peek() != 41) {
                        result.append(separator);
                        result.append(this.getSignature());
                        separator = ", ";
                    }
                    this.get();
                    result.append(")");
                    return this.getSignature() + " " + this.getClassName() + "." + this.getMethodName() + " " + result;
                }
            }
            return null;
        }

        String getMethodName() {
            return "";
        }

        String getClassName() {
            return "";
        }
    }
}

