/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.Alarm;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerSession
implements AbstractDebuggerSession {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerSession");
    private final MyDebuggerStateManager myContextManager;
    private volatile int myIgnoreFiltersFrameCountThreshold;
    private DebuggerSessionState myState;
    private final String mySessionName;
    private final DebugProcessImpl myDebugProcess;
    private final DebugEnvironment myDebugEnvironment;
    private final GlobalSearchScope mySearchScope;
    private Sdk myAlternativeJre;
    private final Sdk myRunJre;
    private final DebuggerContextImpl SESSION_EMPTY_CONTEXT;
    private final AtomicReference<ThreadReferenceProxyImpl> mySteppingThroughThread;
    private final AtomicReference<ThreadReferenceProxyImpl> myLastThread;
    private final Alarm myUpdateAlarm;
    private boolean myModifiedClassesScanRequired;

    public boolean isSteppingThrough(ThreadReferenceProxyImpl threadProxy) {
        return Comparing.equal((Object)this.mySteppingThroughThread.get(), (Object)threadProxy);
    }

    public void setSteppingThrough(ThreadReferenceProxyImpl threadProxy) {
        this.mySteppingThroughThread.set(threadProxy);
    }

    public void clearSteppingThrough() {
        this.mySteppingThroughThread.set(null);
        this.resetIgnoreStepFiltersFlag();
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.mySearchScope;
        if (globalSearchScope == null) {
            DebuggerSession.$$$reportNull$$$0(0);
        }
        return globalSearchScope;
    }

    public Sdk getAlternativeJre() {
        return this.myAlternativeJre;
    }

    public void setAlternativeJre(Sdk sdk) {
        this.myAlternativeJre = sdk;
        ((AlternativeJreClassFinder)((Object)PsiElementFinder.EP.findExtension(AlternativeJreClassFinder.class, (AreaInstance)this.getProject()))).clearCache();
    }

    public Sdk getRunJre() {
        return this.myRunJre;
    }

    public DebugEnvironment getDebugEnvironment() {
        return this.myDebugEnvironment;
    }

    public boolean isModifiedClassesScanRequired() {
        return this.myModifiedClassesScanRequired;
    }

    public void setModifiedClassesScanRequired(boolean modifiedClassesScanRequired) {
        this.myModifiedClassesScanRequired = modifiedClassesScanRequired;
    }

    static DebuggerSession create(@NotNull DebugProcessImpl debugProcess, DebugEnvironment environment) throws ExecutionException {
        if (debugProcess == null) {
            DebuggerSession.$$$reportNull$$$0(1);
        }
        DebuggerSession session = new DebuggerSession(environment.getSessionName(), debugProcess, environment);
        try {
            session.attach();
        }
        catch (ExecutionException e) {
            session.dispose();
            throw e;
        }
        return session;
    }

    private DebuggerSession(String sessionName, @NotNull DebugProcessImpl debugProcess, DebugEnvironment environment) {
        if (debugProcess == null) {
            DebuggerSession.$$$reportNull$$$0(2);
        }
        this.myIgnoreFiltersFrameCountThreshold = 0;
        this.mySteppingThroughThread = new AtomicReference();
        this.myLastThread = new AtomicReference();
        this.myUpdateAlarm = new Alarm();
        this.myModifiedClassesScanRequired = false;
        this.mySessionName = sessionName;
        this.myDebugProcess = debugProcess;
        this.SESSION_EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(this, null, null, null);
        this.myContextManager = new MyDebuggerStateManager();
        this.myState = new DebuggerSessionState(State.STOPPED, null);
        this.myDebugProcess.addDebugProcessListener(new MyDebugProcessListener(debugProcess));
        ValueLookupManager.getInstance((Project)this.getProject()).startListening();
        this.myDebugEnvironment = environment;
        this.mySearchScope = environment.getSearchScope();
        this.myAlternativeJre = environment.getAlternativeJre();
        this.myRunJre = environment.getRunJre();
    }

    @NotNull
    public DebuggerStateManager getContextManager() {
        MyDebuggerStateManager myDebuggerStateManager = this.myContextManager;
        if (myDebuggerStateManager == null) {
            DebuggerSession.$$$reportNull$$$0(3);
        }
        return myDebuggerStateManager;
    }

    public Project getProject() {
        return this.getProcess().getProject();
    }

    public String getSessionName() {
        return this.mySessionName;
    }

    @NotNull
    public DebugProcessImpl getProcess() {
        DebugProcessImpl debugProcessImpl = this.myDebugProcess;
        if (debugProcessImpl == null) {
            DebuggerSession.$$$reportNull$$$0(4);
        }
        return debugProcessImpl;
    }

    public State getState() {
        return this.myState.myState;
    }

    public String getStateDescription() {
        if (this.myState.myDescription != null) {
            return this.myState.myDescription;
        }
        switch (this.myState.myState) {
            case STOPPED: {
                return DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]);
            }
            case RUNNING: {
                return DebuggerBundle.message((String)"status.app.running", (Object[])new Object[0]);
            }
            case WAITING_ATTACH: {
                RemoteConnection connection = this.getProcess().getConnection();
                return DebuggerBundle.message((String)(connection.isServerMode() ? "status.listening" : "status.connecting"), (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(connection)});
            }
            case PAUSED: {
                return DebuggerBundle.message((String)"status.paused", (Object[])new Object[0]);
            }
            case WAIT_EVALUATION: {
                return DebuggerBundle.message((String)"status.waiting.evaluation.result", (Object[])new Object[0]);
            }
            case DISPOSED: {
                return DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void resumeAction(DebugProcessImpl.ResumeCommand command, Event event) {
        this.myLastThread.set(this.getContextManager().getContext().getThreadProxy());
        this.getContextManager().setState(this.SESSION_EMPTY_CONTEXT, State.WAIT_EVALUATION, event, null);
        this.myDebugProcess.getManagerThread().schedule(command);
    }

    public void stepOut(int stepSize) {
        JvmSteppingCommandProvider handler;
        SuspendContextImpl suspendContext = this.getSuspendContext();
        DebugProcessImpl.ResumeCommand cmd = null;
        Iterator iterator = JvmSteppingCommandProvider.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext() && (cmd = (handler = (JvmSteppingCommandProvider)iterator.next()).getStepOutCommand(suspendContext, stepSize)) == null) {
        }
        if (cmd == null) {
            cmd = this.myDebugProcess.createStepOutCommand(suspendContext, stepSize);
        }
        this.setSteppingThrough(cmd.getContextThread());
        this.resumeAction(cmd, Event.STEP);
    }

    public void stepOut() {
        this.stepOut(-2);
    }

    public void stepOver(boolean ignoreBreakpoints, @Nullable MethodFilter methodFilter, int stepSize) {
        JvmSteppingCommandProvider handler;
        SuspendContextImpl suspendContext = this.getSuspendContext();
        DebugProcessImpl.ResumeCommand cmd = null;
        Iterator iterator = JvmSteppingCommandProvider.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext() && (cmd = (handler = (JvmSteppingCommandProvider)iterator.next()).getStepOverCommand(suspendContext, ignoreBreakpoints, stepSize)) == null) {
        }
        if (cmd == null) {
            cmd = this.myDebugProcess.createStepOverCommand(suspendContext, ignoreBreakpoints, methodFilter, stepSize);
        }
        this.setSteppingThrough(cmd.getContextThread());
        this.resumeAction(cmd, Event.STEP);
    }

    public void stepOver(boolean ignoreBreakpoints, int stepSize) {
        this.stepOver(ignoreBreakpoints, null, stepSize);
    }

    public void stepOver(boolean ignoreBreakpoints) {
        this.stepOver(ignoreBreakpoints, -2);
    }

    public void stepInto(boolean ignoreFilters, @Nullable MethodFilter smartStepFilter, int stepSize) {
        JvmSteppingCommandProvider handler;
        SuspendContextImpl suspendContext = this.getSuspendContext();
        DebugProcessImpl.ResumeCommand cmd = null;
        Iterator iterator = JvmSteppingCommandProvider.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext() && (cmd = (handler = (JvmSteppingCommandProvider)iterator.next()).getStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, stepSize)) == null) {
        }
        if (cmd == null) {
            cmd = this.myDebugProcess.createStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, stepSize);
        }
        this.setSteppingThrough(cmd.getContextThread());
        this.resumeAction(cmd, Event.STEP);
    }

    public void stepInto(boolean ignoreFilters, @Nullable MethodFilter smartStepFilter) {
        this.stepInto(ignoreFilters, smartStepFilter, -2);
    }

    public void runToCursor(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        if (position == null) {
            DebuggerSession.$$$reportNull$$$0(5);
        }
        try {
            DebugProcessImpl.ResumeCommand runToCursorCommand = this.myDebugProcess.createRunToCursorCommand(this.getSuspendContext(), position, ignoreBreakpoints);
            this.setSteppingThrough(runToCursorCommand.getContextThread());
            this.resumeAction(runToCursorCommand, Event.STEP);
        }
        catch (EvaluateException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
        }
    }

    public void resume() {
        SuspendContextImpl suspendContext = this.getSuspendContext();
        if (suspendContext != null) {
            this.clearSteppingThrough();
            this.resumeAction(this.myDebugProcess.createResumeCommand(suspendContext), Event.RESUME);
        }
    }

    public void resetIgnoreStepFiltersFlag() {
        this.myIgnoreFiltersFrameCountThreshold = 0;
    }

    public void setIgnoreStepFiltersFlag(int currentStackFrameCount) {
        this.myIgnoreFiltersFrameCountThreshold = this.myIgnoreFiltersFrameCountThreshold <= 0 ? currentStackFrameCount : Math.min(this.myIgnoreFiltersFrameCountThreshold, currentStackFrameCount);
    }

    public boolean shouldIgnoreSteppingFilters() {
        return this.myIgnoreFiltersFrameCountThreshold > 0;
    }

    public void pause() {
        this.myDebugProcess.getManagerThread().schedule(this.myDebugProcess.createPauseCommand());
    }

    public void showExecutionPoint() {
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(this, this.getSuspendContext()), State.PAUSED, Event.REFRESH, null);
    }

    public void refresh(boolean refreshWithStack) {
        State state = this.getState();
        DebuggerContextImpl context = this.myContextManager.getContext();
        DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(this, context.getSuspendContext(), context.getThreadProxy(), context.getFrameProxy());
        this.myContextManager.setState(newContext, state, refreshWithStack ? Event.REFRESH_WITH_STACK : Event.REFRESH, null);
    }

    public void dispose() {
        this.getProcess().dispose();
        this.clearSteppingThrough();
        this.myLastThread.set(null);
        DebuggerInvocationUtil.swingInvokeLater(this.getProject(), () -> {
            this.myContextManager.setState(this.SESSION_EMPTY_CONTEXT, State.DISPOSED, Event.DISPOSE, null);
            this.myContextManager.dispose();
        });
    }

    public boolean isStopped() {
        return this.getState() == State.STOPPED;
    }

    public boolean isAttached() {
        return !this.isStopped() && this.getState() != State.WAITING_ATTACH;
    }

    public boolean isPaused() {
        return this.getState() == State.PAUSED;
    }

    public boolean isConnecting() {
        return this.getState() == State.WAITING_ATTACH;
    }

    public boolean isRunning() {
        return this.getState() == State.RUNNING && !this.getProcess().getProcessHandler().isProcessTerminated();
    }

    private SuspendContextImpl getSuspendContext() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getContextManager().getContext().getSuspendContext();
    }

    private void attach() throws ExecutionException {
        RemoteConnection remoteConnection = this.myDebugEnvironment.getRemoteConnection();
        this.myDebugProcess.attachVirtualMachine(this.myDebugEnvironment, this);
        this.getContextManager().setState(this.SESSION_EMPTY_CONTEXT, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, DebuggerBundle.message((String)"status.waiting.attach", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(remoteConnection)}));
    }

    public static void switchContext(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            DebuggerSession.$$$reportNull$$$0(6);
        }
        final DebugProcessImpl debugProcess = suspendContext.getDebugProcess();
        debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                DebuggerSession session = debugProcess.getSession();
                DebuggerContextImpl debuggerContext = DebuggerContextUtil.createDebuggerContext(session, suspendContext);
                DebuggerInvocationUtil.invokeLater(debugProcess.getProject(), () -> session.getContextManager().setState(debuggerContext, State.PAUSED, Event.PAUSE, null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerSession$1", "contextAction"));
            }
        });
    }

    private static String getDescription(DebuggerContextImpl debuggerContext) {
        SuspendContextImpl suspendContext = debuggerContext.getSuspendContext();
        if (suspendContext != null && debuggerContext.getThreadProxy() != suspendContext.getThread()) {
            return DebuggerBundle.message((String)"status.paused.in.another.thread", (Object[])new Object[0]);
        }
        return null;
    }

    public static boolean enableBreakpointsDuringEvaluation() {
        return Registry.is((String)"debugger.enable.breakpoints.during.evaluation");
    }

    public void sessionResumed() {
        XDebugSession session = this.getXDebugSession();
        if (session != null) {
            session.sessionResumed();
        }
    }

    @Nullable
    public XDebugSession getXDebugSession() {
        JavaDebugProcess process2 = this.myDebugProcess.getXdebugProcess();
        return process2 != null ? process2.getSession() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerSession";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runToCursor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "switchContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BreakpointReachedNotificationListener
    extends NotificationListener.Adapter {
        private final WeakReference<SuspendContextImpl> myContextRef;

        BreakpointReachedNotificationListener(SuspendContextImpl suspendContext) {
            this.myContextRef = new WeakReference<SuspendContextImpl>(suspendContext);
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                BreakpointReachedNotificationListener.$$$reportNull$$$0(0);
            }
            if (e == null) {
                BreakpointReachedNotificationListener.$$$reportNull$$$0(1);
            }
            notification.hideBalloon();
            SuspendContextImpl suspendContext = (SuspendContextImpl)((Object)SoftReference.dereference(this.myContextRef));
            if (suspendContext != null) {
                DebuggerSession.switchContext(suspendContext);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/impl/DebuggerSession$BreakpointReachedNotificationListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDebugProcessListener
    extends DebugProcessAdapterImpl {
        private final DebugProcessImpl myDebugProcess;

        MyDebugProcessListener(DebugProcessImpl debugProcess) {
            this.myDebugProcess = debugProcess;
        }

        public void connectorIsReady() {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                RemoteConnection connection = this.myDebugProcess.getConnection();
                String connectionStatusMessage = DebuggerBundle.message((String)(connection.isServerMode() ? "status.listening" : "status.connecting"), (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(connection)});
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, connectionStatusMessage);
            });
        }

        @Override
        public void paused(SuspendContextImpl suspendContext) {
            SourcePosition position;
            Object positionContext;
            LOG.debug("paused");
            ThreadReferenceProxyImpl currentThread = suspendContext.getThread();
            if (!this.shouldSetAsActiveContext(suspendContext)) {
                List<Pair<Breakpoint, com.sun.jdi.event.Event>> descriptors;
                this.notifyThreadsRefresh();
                ThreadReferenceProxyImpl thread2 = suspendContext.getThread();
                if (thread2 != null && !(descriptors = DebuggerUtilsEx.getEventDescriptors(suspendContext)).isEmpty()) {
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"status.breakpoint.reached.in.thread", (Object[])new Object[]{thread2.name()}), DebuggerBundle.message((String)"status.breakpoint.reached.in.thread.switch", (Object[])new Object[0]), NotificationType.INFORMATION, (NotificationListener)new BreakpointReachedNotificationListener(suspendContext)).notify(DebuggerSession.this.getProject());
                }
                if (((SuspendManagerImpl)this.myDebugProcess.getSuspendManager()).getPausedContexts().size() > 1) {
                    return;
                }
                currentThread = (ThreadReferenceProxyImpl)DebuggerSession.this.mySteppingThroughThread.get();
            } else {
                DebuggerSession.this.setSteppingThrough(currentThread);
            }
            if (currentThread == null) {
                LOG.assertTrue(suspendContext.getSuspendPolicy() == 2);
                SuspendContextImpl oldContext = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
                if (oldContext != null) {
                    currentThread = oldContext.getThread();
                }
                if (currentThread == null) {
                    Collection<ThreadReferenceProxyImpl> allThreads = DebuggerSession.this.getProcess().getVirtualMachineProxy().allThreads();
                    ThreadReferenceProxyImpl lastThread = (ThreadReferenceProxyImpl)DebuggerSession.this.myLastThread.get();
                    if (lastThread != null && allThreads.contains(lastThread)) {
                        currentThread = lastThread;
                    } else {
                        currentThread = allThreads.stream().filter(thread -> ThreadState.isEDT(thread.name())).findFirst().orElse(null);
                        if (currentThread == null) {
                            currentThread = allThreads.stream().filter(thread -> "main".equals(thread.name())).findFirst().orElse(null);
                        }
                        if (currentThread == null) {
                            Iterator<ThreadReferenceProxyImpl> iterator = allThreads.iterator();
                            while (iterator.hasNext()) {
                                ThreadReferenceProxyImpl thread3;
                                currentThread = thread3 = iterator.next();
                                try {
                                    if (currentThread.status() != 1 || currentThread.frameCount() <= 0) continue;
                                    break;
                                }
                                catch (EvaluateException evaluateException) {
                                }
                            }
                        }
                    }
                }
                StackFrameProxyImpl proxy = null;
                if (currentThread != null) {
                    try {
                        while (!currentThread.isSuspended()) {
                            TimeoutUtil.sleep((long)10L);
                        }
                        proxy = currentThread.frameCount() > 0 ? currentThread.frame(0) : null;
                    }
                    catch (ObjectCollectedException ignored) {
                        proxy = null;
                    }
                    catch (EvaluateException e) {
                        proxy = null;
                        LOG.error((Throwable)e);
                    }
                }
                positionContext = new SimpleStackFrameContext(proxy, this.myDebugProcess);
            } else {
                positionContext = suspendContext;
            }
            if (currentThread != null) {
                try {
                    int frameCount = currentThread.frameCount();
                    if (frameCount == 0 || frameCount <= DebuggerSession.this.myIgnoreFiltersFrameCountThreshold) {
                        DebuggerSession.this.resetIgnoreStepFiltersFlag();
                    }
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                    DebuggerSession.this.resetIgnoreStepFiltersFlag();
                }
            }
            if ((position = ContextUtil.getSourcePosition((StackFrameContext)positionContext)) != null) {
                List<Pair<Breakpoint, com.sun.jdi.event.Event>> eventDescriptors = DebuggerUtilsEx.getEventDescriptors(suspendContext);
                RequestManagerImpl requestsManager = suspendContext.getDebugProcess().getRequestsManager();
                PsiFile foundFile = position.getFile();
                boolean sourceMissing = foundFile instanceof PsiCompiledElement;
                for (Pair<Breakpoint, com.sun.jdi.event.Event> eventDescriptor : eventDescriptors) {
                    String className2;
                    Breakpoint breakpoint = (Breakpoint)eventDescriptor.getFirst();
                    if (!(breakpoint instanceof LineBreakpoint)) continue;
                    SourcePosition breakpointPosition = ((BreakpointWithHighlighter)breakpoint).getSourcePosition();
                    if (breakpointPosition == null || !sourceMissing && breakpointPosition.getLine() != position.getLine()) {
                        requestsManager.deleteRequest(breakpoint);
                        requestsManager.setInvalid(breakpoint, DebuggerBundle.message((String)"error.invalid.breakpoint.source.changed", (Object[])new Object[0]));
                        breakpoint.updateUI();
                        continue;
                    }
                    if (!sourceMissing) continue;
                    position = breakpointPosition;
                    StackFrameProxy frameProxy = positionContext.getFrameProxy();
                    try {
                        className2 = frameProxy != null ? frameProxy.location().declaringType().name() : "";
                    }
                    catch (EvaluateException ignored) {
                        className2 = "";
                    }
                    requestsManager.setInvalid(breakpoint, DebuggerBundle.message((String)"error.invalid.breakpoint.source.not.found", (Object[])new Object[]{className2}));
                    breakpoint.updateUI();
                }
            }
            DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, suspendContext, currentThread, null);
            if (suspendContext.getThread() == currentThread) {
                debuggerContext.setPositionCache(position);
            }
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState(debuggerContext, State.PAUSED, Event.PAUSE, DebuggerSession.getDescription(debuggerContext)));
        }

        private boolean shouldSetAsActiveContext(SuspendContextImpl suspendContext) {
            ThreadReferenceProxyImpl newThread = suspendContext.getThread();
            if (newThread == null || suspendContext.getSuspendPolicy() == 2 || DebuggerSession.this.isSteppingThrough(newThread)) {
                return true;
            }
            SuspendContextImpl currentSuspendContext = DebuggerSession.this.getContextManager().getContext().getSuspendContext();
            if (currentSuspendContext == null) {
                return DebuggerSession.this.mySteppingThroughThread.get() == null;
            }
            if (DebuggerSession.enableBreakpointsDuringEvaluation()) {
                ThreadReferenceProxyImpl currentThread = currentSuspendContext.getThread();
                return currentThread == null || Comparing.equal((Object)currentThread.getThreadReference(), (Object)newThread.getThreadReference());
            }
            return false;
        }

        @Override
        public void resumed(SuspendContextImpl suspendContext) {
            SuspendContextImpl context = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
            ThreadReferenceProxyImpl steppingThread = null;
            if (context != null && suspendContext != null && suspendContext.getSuspendPolicy() == 1 && DebuggerSession.this.isSteppingThrough(suspendContext.getThread())) {
                steppingThread = suspendContext.getThread();
            }
            DebuggerContextImpl debuggerContext = context != null ? DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, context, steppingThread != null ? steppingThread : context.getThread(), null) : null;
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                if (debuggerContext != null) {
                    DebuggerSession.this.getContextManager().setState(debuggerContext, State.PAUSED, Event.CONTEXT, DebuggerSession.getDescription(debuggerContext));
                } else {
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.RUNNING, Event.CONTEXT, null);
                }
            });
        }

        @Override
        public void processAttached(DebugProcessImpl process2) {
            String message2 = DebuggerBundle.message((String)"status.connected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(process2.getConnection())});
            process2.printToConsole(message2 + "\n");
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.RUNNING, Event.ATTACHED, message2));
        }

        public void attachException(RunProfileState state, ExecutionException exception, RemoteConnection remoteConnection) {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                String message2 = "";
                if (state instanceof RemoteState) {
                    message2 = DebuggerBundle.message((String)"status.connect.failed", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(remoteConnection)});
                }
                message2 = message2 + exception.getMessage();
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.STOPPED, Event.DETACHED, message2);
            });
        }

        @Override
        public void processDetached(DebugProcessImpl debugProcess, boolean closedByUser) {
            ProcessHandler processHandler;
            if (!closedByUser && (processHandler = debugProcess.getProcessHandler()) != null) {
                processHandler.notifyTextAvailable(DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(debugProcess.getConnection())}) + "\n", ProcessOutputTypes.SYSTEM);
            }
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.STOPPED, Event.DETACHED, DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(debugProcess.getConnection())})));
            DebuggerSession.this.clearSteppingThrough();
        }

        public void threadStarted(@NotNull DebugProcess proc, ThreadReference thread) {
            if (proc == null) {
                MyDebugProcessListener.$$$reportNull$$$0(0);
            }
            this.notifyThreadsRefresh();
        }

        public void threadStopped(@NotNull DebugProcess proc, ThreadReference thread) {
            DebugProcessImpl debugProcess;
            if (proc == null) {
                MyDebugProcessListener.$$$reportNull$$$0(1);
            }
            this.notifyThreadsRefresh();
            ThreadReferenceProxyImpl steppingThread = (ThreadReferenceProxyImpl)DebuggerSession.this.mySteppingThroughThread.get();
            if (steppingThread != null && steppingThread.getThreadReference() == thread) {
                DebuggerSession.this.clearSteppingThrough();
            }
            if ((debugProcess = (DebugProcessImpl)proc).getRequestsManager().getFilterThread() == thread) {
                DebuggerManagerEx.getInstanceEx(proc.getProject()).getBreakpointManager().applyThreadFilter(debugProcess, null);
            }
        }

        private void notifyThreadsRefresh() {
            DebuggerSession.this.myUpdateAlarm.cancelAllRequests();
            DebuggerSession.this.myUpdateAlarm.addRequest(() -> {
                DebuggerStateManager contextManager = DebuggerSession.this.getContextManager();
                contextManager.fireStateChanged(contextManager.getContext(), Event.THREADS_REFRESH);
            }, ApplicationManager.getApplication().isUnitTestMode() ? 0 : 100, ModalityState.NON_MODAL);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "proc";
            objectArray2[1] = "com/intellij/debugger/impl/DebuggerSession$MyDebugProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "threadStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "threadStopped";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DebuggerSessionState {
        final State myState;
        final String myDescription;

        DebuggerSessionState(State state, String description) {
            this.myState = state;
            this.myDescription = description;
        }
    }

    private class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerContextImpl myDebuggerContext;

        MyDebuggerStateManager() {
            this.myDebuggerContext = DebuggerSession.this.SESSION_EMPTY_CONTEXT;
        }

        @Override
        @NotNull
        public DebuggerContextImpl getContext() {
            DebuggerContextImpl debuggerContextImpl = this.myDebuggerContext;
            if (debuggerContextImpl == null) {
                MyDebuggerStateManager.$$$reportNull$$$0(0);
            }
            return debuggerContextImpl;
        }

        @Override
        public void setState(final @NotNull DebuggerContextImpl context, State state, Event event, String description) {
            if (context == null) {
                MyDebuggerStateManager.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            DebuggerSession session = context.getDebuggerSession();
            LOG.assertTrue(session == DebuggerSession.this || session == null);
            final Runnable setStateRunnable = () -> {
                LOG.assertTrue(this.myDebuggerContext.isInitialised());
                this.myDebuggerContext = context;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DebuggerSession state = " + (Object)((Object)state) + ", event = " + (Object)((Object)event));
                }
                DebuggerSession.this.myState = new DebuggerSessionState(state, description);
                this.fireStateChanged(context, event);
            };
            if (context.getSuspendContext() == null) {
                setStateRunnable.run();
            } else {
                DebuggerSession.this.getProcess().getManagerThread().schedule(new SuspendContextCommandImpl(context.getSuspendContext()){

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return PrioritizedTask.Priority.HIGH;
                    }

                    @Override
                    public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                        if (suspendContext == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        context.initCaches();
                        DebuggerInvocationUtil.swingInvokeLater(DebuggerSession.this.getProject(), setStateRunnable);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager$1", "contextAction"));
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Event {
        ATTACHED,
        DETACHED,
        RESUME,
        STEP,
        PAUSE,
        REFRESH,
        CONTEXT,
        START_WAIT_ATTACH,
        DISPOSE,
        REFRESH_WITH_STACK,
        THREADS_REFRESH;

    }

    public static enum State {
        STOPPED,
        RUNNING,
        WAITING_ATTACH,
        PAUSED,
        WAIT_EVALUATION,
        DISPOSED;

    }
}

