/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.configurations.ConfigurationWithAlternativeJre;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlternativeJreClassFinder
extends NonClasspathClassFinder {
    public AlternativeJreClassFinder(Project project) {
        super(project, new String[0]);
        project.getMessageBus().connect().subscribe(DebuggerManagerListener.TOPIC, (Object)new DebuggerManagerListener(){

            @Override
            public void sessionCreated(DebuggerSession session) {
                AlternativeJreClassFinder.this.clearCache();
            }

            @Override
            public void sessionRemoved(DebuggerSession session) {
                AlternativeJreClassFinder.this.clearCache();
            }
        });
    }

    @Override
    protected List<VirtualFile> calcClassRoots() {
        Collection<DebuggerSession> sessions = DebuggerManagerEx.getInstanceEx(this.myProject).getSessions();
        if (sessions.isEmpty()) {
            return Collections.emptyList();
        }
        List res = ContainerUtil.newSmartList();
        for (DebuggerSession session : sessions) {
            Sdk jre = session.getAlternativeJre();
            if (jre == null) continue;
            res.addAll(AlternativeJreClassFinder.getClassRoots(jre));
        }
        return res;
    }

    @Nullable
    public static Sdk getAlternativeJre(RunProfile profile) {
        ConfigurationWithAlternativeJre appConfig;
        if (profile instanceof ConfigurationWithAlternativeJre && (appConfig = (ConfigurationWithAlternativeJre)profile).isAlternativeJrePathEnabled()) {
            String path = appConfig.getAlternativeJrePath();
            return path == null ? null : ProjectJdkTable.getInstance().findJdk(path);
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getClassRoots(@NotNull Sdk jre) {
        if (jre == null) {
            AlternativeJreClassFinder.$$$reportNull$$$0(0);
        }
        List<VirtualFile> list = Arrays.asList(jre.getRootProvider().getFiles(OrderRootType.CLASSES));
        if (list == null) {
            AlternativeJreClassFinder.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static Collection<VirtualFile> getSourceRoots(@NotNull Sdk jre) {
        if (jre == null) {
            AlternativeJreClassFinder.$$$reportNull$$$0(2);
        }
        List<VirtualFile> list = Arrays.asList(jre.getRootProvider().getFiles(OrderRootType.SOURCES));
        if (list == null) {
            AlternativeJreClassFinder.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static GlobalSearchScope getSearchScope(@NotNull Sdk jre) {
        if (jre == null) {
            AlternativeJreClassFinder.$$$reportNull$$$0(4);
        }
        NonClasspathDirectoriesScope nonClasspathDirectoriesScope = new NonClasspathDirectoriesScope(AlternativeJreClassFinder.getClassRoots(jre));
        if (nonClasspathDirectoriesScope == null) {
            AlternativeJreClassFinder.$$$reportNull$$$0(5);
        }
        return nonClasspathDirectoriesScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jre";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/AlternativeJreClassFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/AlternativeJreClassFinder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassRoots";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

