/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.requests;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.SimpleColoredComponent;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnValueWatcher
implements OverheadProducer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.requests.MethodReturnValueWatcher");
    @Nullable
    private Method myLastExecutedMethod;
    @Nullable
    private Value myLastMethodReturnValue;
    private ThreadReference myThread;
    @Nullable
    private MethodEntryRequest myEntryRequest;
    @Nullable
    private Method myEntryMethod;
    @Nullable
    private MethodExitRequest myExitRequest;
    private volatile boolean myTrackingEnabled;
    private final EventRequestManager myRequestManager;
    private final DebugProcess myProcess;
    private static final String WATCHER_REQUEST_KEY = "WATCHER_REQUEST_KEY";

    public MethodReturnValueWatcher(EventRequestManager requestManager, DebugProcess process2) {
        this.myRequestManager = requestManager;
        this.myProcess = process2;
    }

    private void processMethodExitEvent(MethodExitEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("<- " + event.method());
        }
        try {
            if (Registry.is((String)"debugger.watch.return.speedup") && this.myEntryMethod != null) {
                if (this.myEntryMethod.equals(event.method())) {
                    LOG.debug("Now watching all");
                    this.enableEntryWatching(true);
                    this.myEntryMethod = null;
                    this.createExitRequest().enable();
                } else {
                    return;
                }
            }
            Method method = event.method();
            Value retVal = event.returnValue();
            if (method == null || !DebuggerUtilsEx.isVoid(method)) {
                this.myLastExecutedMethod = method;
                this.myLastMethodReturnValue = retVal;
            }
        }
        catch (UnsupportedOperationException ex) {
            LOG.error((Throwable)ex);
        }
    }

    private void processMethodEntryEvent(MethodEntryEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("-> " + event.method());
        }
        try {
            if (this.myEntryRequest != null && this.myEntryRequest.isEnabled()) {
                this.myExitRequest = this.createExitRequest();
                this.myExitRequest.addClassFilter(event.method().declaringType());
                this.myEntryMethod = event.method();
                this.myExitRequest.enable();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Now watching only " + event.method());
                }
                this.enableEntryWatching(false);
            }
        }
        catch (VMDisconnectedException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void enableEntryWatching(boolean enable) {
        if (this.myEntryRequest != null) {
            this.myEntryRequest.setEnabled(enable);
        }
    }

    @Nullable
    public Method getLastExecutedMethod() {
        return this.myLastExecutedMethod;
    }

    @Nullable
    public Value getLastMethodReturnValue() {
        return this.myLastMethodReturnValue;
    }

    @Override
    public boolean isEnabled() {
        return DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
    }

    @Override
    public void setEnabled(boolean enabled) {
        DebuggerSettings.getInstance().WATCH_RETURN_VALUES = enabled;
        this.clear();
    }

    public boolean isTrackingEnabled() {
        return this.myTrackingEnabled;
    }

    public void enable(ThreadReference thread) {
        this.setTrackingEnabled(true, thread);
    }

    public void disable() {
        this.setTrackingEnabled(false, null);
    }

    private void setTrackingEnabled(boolean trackingEnabled, ThreadReference thread) {
        this.myTrackingEnabled = trackingEnabled;
        this.updateRequestState(trackingEnabled && this.isEnabled(), thread);
    }

    public void clear() {
        this.myLastExecutedMethod = null;
        this.myLastMethodReturnValue = null;
        this.myThread = null;
    }

    private void updateRequestState(boolean enabled, @Nullable ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.myEntryRequest != null) {
                this.myRequestManager.deleteEventRequest(this.myEntryRequest);
                this.myEntryRequest = null;
            }
            if (this.myExitRequest != null) {
                this.myRequestManager.deleteEventRequest(this.myExitRequest);
                this.myExitRequest = null;
            }
            if (enabled) {
                OverheadTimings.add(this.myProcess, this, 1L, null);
                this.clear();
                this.myThread = thread;
                if (Registry.is((String)"debugger.watch.return.speedup")) {
                    this.createEntryRequest().enable();
                }
                this.createExitRequest().enable();
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    private MethodEntryRequest createEntryRequest() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myEntryRequest = this.prepareRequest(this.myRequestManager.createMethodEntryRequest());
        return this.myEntryRequest;
    }

    @NotNull
    private MethodExitRequest createExitRequest() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myExitRequest != null) {
            this.myRequestManager.deleteEventRequest(this.myExitRequest);
        }
        MethodExitRequest methodExitRequest = this.myExitRequest = this.prepareRequest(this.myRequestManager.createMethodExitRequest());
        if (methodExitRequest == null) {
            MethodReturnValueWatcher.$$$reportNull$$$0(0);
        }
        return methodExitRequest;
    }

    @NotNull
    private <T extends EventRequest> T prepareRequest(T request) {
        request.setSuspendPolicy(Registry.is((String)"debugger.watch.return.speedup") ? 1 : 0);
        if (this.myThread != null) {
            if (request instanceof MethodEntryRequest) {
                ((MethodEntryRequest)request).addThreadFilter(this.myThread);
            } else if (request instanceof MethodExitRequest) {
                ((MethodExitRequest)request).addThreadFilter(this.myThread);
            }
        }
        request.putProperty(WATCHER_REQUEST_KEY, true);
        T t = request;
        if (t == null) {
            MethodReturnValueWatcher.$$$reportNull$$$0(1);
        }
        return t;
    }

    public boolean processEvent(Event event) {
        EventRequest request = event.request();
        if (request == null || request.getProperty(WATCHER_REQUEST_KEY) == null) {
            return false;
        }
        if (event instanceof MethodEntryEvent) {
            this.processMethodEntryEvent((MethodEntryEvent)event);
        } else if (event instanceof MethodExitEvent) {
            this.processMethodExitEvent((MethodExitEvent)event);
        }
        return true;
    }

    @Override
    public void customizeRenderer(SimpleColoredComponent renderer) {
        renderer.setIcon(AllIcons.Debugger.WatchLastReturnValue);
        renderer.append(DebuggerBundle.message((String)"action.watches.method.return.value.enable", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/engine/requests/MethodReturnValueWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createExitRequest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRequest";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

