/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;

public class ExpressionListEvaluator
implements Evaluator {
    private final List<? extends Evaluator> myEvaluators;

    public ExpressionListEvaluator(List<? extends Evaluator> evaluators) {
        this.myEvaluators = evaluators;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        ArrayList<String> strings = new ArrayList<String>(this.myEvaluators.size());
        for (Evaluator evaluator : this.myEvaluators) {
            strings.add(DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)((Value)evaluator.evaluate(context))));
        }
        return DebuggerUtilsEx.mirrorOfString(StringUtil.join(strings, (String)", "), context.getDebugProcess().getVirtualMachineProxy(), context);
    }
}

