/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.PopFrameAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.XExpressionDialog;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowExceptionAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ThrowExceptionAction.$$$reportNull$$$0(0);
        }
        final Project project = e.getProject();
        final JavaStackFrame stackFrame = PopFrameAction.getStackFrame(e);
        if (stackFrame == null || project == null) {
            return;
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        StackFrameProxyImpl proxy = stackFrame.getStackFrameProxy();
        ThreadReferenceProxyImpl thread = proxy.threadProxy();
        debugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext, thread){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> new XExpressionDialog(project, debugProcess.getXdebugProcess().getEditorsProvider(), "throwExceptionValue", "Exception To Throw", stackFrame.getSourcePosition(), null){

                    protected void doOKAction() {
                        ThrowExceptionAction.evaluateAndReturn(project, stackFrame, debugProcess, this.getExpression(), (DialogWrapper)this);
                    }
                }.show());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/ThrowExceptionAction$1", "threadAction"));
            }
        });
    }

    private static void throwException(final Value value2, final ThreadReferenceProxyImpl thread, final DebugProcessImpl debugProcess, final @Nullable DialogWrapper dialog) {
        debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                try {
                    thread.stop((ObjectReference)value2);
                }
                catch (Exception e) {
                    ThrowExceptionAction.showError(debugProcess.getProject(), DebuggerBundle.message((String)"error.throw.exception", (Object[])new Object[]{e.getLocalizedMessage()}));
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    if (dialog != null) {
                        dialog.close(0);
                    }
                    debugProcess.getSession().stepInto(true, null);
                });
            }
        });
    }

    private static void showError(Project project, String message2) {
        PopFrameAction.showError(project, message2, UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.ThrowException")));
    }

    private static void evaluateAndReturn(final Project project, final JavaStackFrame stackFrame, final DebugProcessImpl debugProcess, XExpression expression2, final DialogWrapper dialog) {
        XDebuggerEvaluator evaluator = stackFrame.getEvaluator();
        if (evaluator != null) {
            evaluator.evaluate(expression2, new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue result) {
                    if (result == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (result instanceof JavaValue) {
                        ThrowExceptionAction.throwException(((JavaValue)result).getDescriptor().getValue(), stackFrame.getDescriptor().getFrameProxy().threadProxy(), debugProcess, dialog);
                    }
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    ThrowExceptionAction.showError(project, DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + ": " + errorMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/actions/ThrowExceptionAction$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, stackFrame.getSourcePosition());
        } else {
            ThrowExceptionAction.showError(project, XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        JavaStackFrame stackFrame;
        boolean enable;
        if (e == null) {
            ThrowExceptionAction.$$$reportNull$$$0(1);
        }
        boolean bl = enable = (stackFrame = PopFrameAction.getStackFrame(e)) != null && stackFrame.getDescriptor().getUiIndex() == 0;
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "DebuggerToolbar".equals(e.getPlace())) {
            e.getPresentation().setEnabled(enable);
        } else {
            e.getPresentation().setVisible(enable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/debugger/actions/ThrowExceptionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

