/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class JvmSmartStepIntoActionHandler
extends XSmartStepIntoHandler<JvmSmartStepIntoVariant> {
    private final DebuggerSession mySession;

    public JvmSmartStepIntoActionHandler(@NotNull DebuggerSession session) {
        if (session == null) {
            JvmSmartStepIntoActionHandler.$$$reportNull$$$0(0);
        }
        this.mySession = session;
    }

    @NotNull
    public Promise<List<JvmSmartStepIntoVariant>> computeSmartStepVariantsAsync(@NotNull XSourcePosition position) {
        if (position == null) {
            JvmSmartStepIntoActionHandler.$$$reportNull$$$0(1);
        }
        Promise<List<JvmSmartStepIntoVariant>> promise = this.findVariants(position, true);
        if (promise == null) {
            JvmSmartStepIntoActionHandler.$$$reportNull$$$0(2);
        }
        return promise;
    }

    @NotNull
    public Promise<List<JvmSmartStepIntoVariant>> computeStepIntoVariants(@NotNull XSourcePosition position) {
        if (position == null) {
            JvmSmartStepIntoActionHandler.$$$reportNull$$$0(3);
        }
        Promise<List<JvmSmartStepIntoVariant>> promise = this.findVariants(position, false);
        if (promise == null) {
            JvmSmartStepIntoActionHandler.$$$reportNull$$$0(4);
        }
        return promise;
    }

    private Promise<List<JvmSmartStepIntoVariant>> findVariants(@NotNull XSourcePosition xPosition, boolean smart) {
        if (xPosition == null) {
            JvmSmartStepIntoActionHandler.$$$reportNull$$$0(5);
        }
        SourcePosition position = DebuggerUtilsEx.toSourcePosition(xPosition, this.mySession.getProject());
        for (JvmSmartStepIntoHandler handler : JvmSmartStepIntoHandler.EP_NAME.getExtensionList()) {
            if (!handler.isAvailable(position)) continue;
            Promise<List<SmartStepTarget>> targets = smart ? handler.findSmartStepTargetsAsync(position, this.mySession) : handler.findStepIntoTargets(position, this.mySession);
            return targets.then(results -> ContainerUtil.map((Collection)results, target -> new JvmSmartStepIntoVariant((SmartStepTarget)target, handler)));
        }
        return Promises.rejectedPromise();
    }

    @NotNull
    public List<JvmSmartStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        if (position == null) {
            JvmSmartStepIntoActionHandler.$$$reportNull$$$0(6);
        }
        throw new IllegalStateException("Should not be called");
    }

    public String getPopupTitle(@NotNull XSourcePosition position) {
        if (position == null) {
            JvmSmartStepIntoActionHandler.$$$reportNull$$$0(7);
        }
        return DebuggerBundle.message((String)"title.smart.step.popup", (Object[])new Object[0]);
    }

    public void stepIntoEmpty(XDebugSession session) {
        session.forceStepInto();
    }

    public void startStepInto(@NotNull JvmSmartStepIntoVariant variant, @Nullable XSuspendContext context) {
        if (variant == null) {
            JvmSmartStepIntoActionHandler.$$$reportNull$$$0(8);
        }
        this.mySession.stepInto(true, variant.myHandler.createMethodFilter(variant.myTarget));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/actions/JvmSmartStepIntoActionHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xPosition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/actions/JvmSmartStepIntoActionHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSmartStepVariantsAsync";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeStepIntoVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeSmartStepVariantsAsync";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeStepIntoVariants";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findVariants";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeSmartStepVariants";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPopupTitle";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startStepInto";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class JvmSmartStepIntoVariant
    extends XSmartStepIntoVariant {
        private final SmartStepTarget myTarget;
        private final JvmSmartStepIntoHandler myHandler;

        JvmSmartStepIntoVariant(SmartStepTarget target, JvmSmartStepIntoHandler handler) {
            this.myTarget = target;
            this.myHandler = handler;
        }

        public String getText() {
            return this.myTarget.getPresentation();
        }

        @Nullable
        public Icon getIcon() {
            return this.myTarget.getIcon();
        }

        @Nullable
        public TextRange getHighlightRange() {
            PsiElement element = this.myTarget.getHighlightElement();
            return element != null ? element.getTextRange() : null;
        }
    }
}

