/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class GotoFrameSourceAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoFrameSourceAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        GotoFrameSourceAction.doAction(dataContext);
    }

    public static void doAction(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        StackFrameDescriptorImpl stackFrameDescriptor = GotoFrameSourceAction.getStackFrameDescriptor(dataContext);
        final XDebugSession session = (XDebugSession)XDebugSession.DATA_KEY.getData(dataContext);
        if (stackFrameDescriptor != null && session != null) {
            final StackFrameProxyImpl frameProxy = stackFrameDescriptor.getFrameProxy();
            final DebugProcessImpl process2 = (DebugProcessImpl)stackFrameDescriptor.getDebugProcess();
            process2.getManagerThread().schedule(new SuspendContextCommandImpl((SuspendContextImpl)session.getSuspendContext()){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ThreadReferenceProxyImpl threadProxy = frameProxy.threadProxy();
                    SuspendContextImpl threadSuspendContext = SuspendManagerUtil.findContextByThread(process2.getSuspendManager(), threadProxy);
                    JavaExecutionStack executionStack = new JavaExecutionStack(threadProxy, process2, Objects.equals(threadSuspendContext.getThread(), threadProxy));
                    executionStack.initTopFrame();
                    XStackFrame frame = executionStack.createStackFrame(frameProxy);
                    DebuggerUIUtil.invokeLater(() -> session.setCurrentStackFrame((XExecutionStack)executionStack, frame));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/GotoFrameSourceAction$1", "contextAction"));
                }
            });
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoFrameSourceAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setVisible(GotoFrameSourceAction.getStackFrameDescriptor(e.getDataContext()) != null);
    }

    private static StackFrameDescriptorImpl getStackFrameDescriptor(DataContext dataContext) {
        DebuggerTreeNodeImpl selectedNode = GotoFrameSourceAction.getSelectedNode(dataContext);
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getDescriptor() == null || !(selectedNode.getDescriptor() instanceof StackFrameDescriptorImpl)) {
            return null;
        }
        return (StackFrameDescriptorImpl)selectedNode.getDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/debugger/actions/GotoFrameSourceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

