/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cyclicDependencies.ui;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.cyclicDependencies.CyclicDependenciesBuilder;
import com.intellij.cyclicDependencies.actions.CyclicDependenciesHandler;
import com.intellij.cyclicDependencies.ui.CycleNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.packageDependencies.DependenciesToolWindow;
import com.intellij.packageDependencies.DependencyUISettings;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DependenciesUsagesPanel;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageNode;
import com.intellij.packageDependencies.ui.PackageTreeExpansionMonitor;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.packageDependencies.ui.TreeModelBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CyclicDependenciesPanel
extends JPanel
implements Disposable,
DataProvider {
    private static final HashSet<PsiFile> EMPTY_FILE_SET = new HashSet(0);
    private final HashMap<PsiPackage, Set<List<PsiPackage>>> myDependencies;
    private final MyTree myLeftTree = new MyTree();
    private final MyTree myRightTree = new MyTree();
    private final DependenciesUsagesPanel myUsagesPanel;
    private final TreeExpansionMonitor myRightTreeExpansionMonitor;
    private final TreeExpansionMonitor myLeftTreeExpansionMonitor;
    private final Project myProject;
    private final CyclicDependenciesBuilder myBuilder;
    private Content myContent;
    private final DependenciesPanel.DependencyPanelSettings mySettings = new DependenciesPanel.DependencyPanelSettings();
    public static final String DEFAULT_PACKAGE_ABBREVIATION = AnalysisScopeBundle.message((String)"dependencies.tree.node.default.package.abbreviation", (Object[])new Object[0]);

    public CyclicDependenciesPanel(Project project, CyclicDependenciesBuilder builder) {
        super(new BorderLayout());
        this.myDependencies = builder.getCyclicDependencies();
        this.myBuilder = builder;
        this.myProject = project;
        this.myUsagesPanel = new DependenciesUsagesPanel(this.myProject, Collections.singletonList(builder.getForwardBuilder()));
        Disposer.register((Disposable)this, (Disposable)this.myUsagesPanel);
        this.mySettings.UI_SHOW_MODULES = false;
        Splitter treeSplitter = new Splitter();
        Disposer.register((Disposable)this, () -> treeSplitter.dispose());
        treeSplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myLeftTree)));
        treeSplitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myRightTree)));
        Splitter splitter = new Splitter(true);
        Disposer.register((Disposable)this, () -> splitter.dispose());
        splitter.setFirstComponent((JComponent)treeSplitter);
        splitter.setSecondComponent((JComponent)this.myUsagesPanel);
        this.add((Component)splitter, "Center");
        this.add((Component)this.createToolbar(), "North");
        this.myRightTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)((Object)this.myRightTree), (Project)this.myProject);
        this.myLeftTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)((Object)this.myLeftTree), (Project)this.myProject);
        this.updateLeftTreeModel();
        this.updateRightTreeModel();
        this.myLeftTree.getSelectionModel().addTreeSelectionListener(__ -> {
            this.updateRightTreeModel();
            this.myUsagesPanel.setToInitialPosition();
        });
        this.myRightTree.getSelectionModel().addTreeSelectionListener(__ -> SwingUtilities.invokeLater(() -> {
            Set<PsiFile> searchIn = CyclicDependenciesPanel.getSelectedScope(this.myRightTree);
            PackageNode selectedPackageNode = CyclicDependenciesPanel.getSelectedPackage(this.myRightTree);
            if (selectedPackageNode == null) {
                return;
            }
            PackageDependenciesNode nextPackageNode = CyclicDependenciesPanel.getNextPackageNode((DefaultMutableTreeNode)((Object)selectedPackageNode));
            HashSet packNodes = new HashSet();
            CyclicDependenciesPanel.getPackageNodesHierarchy(selectedPackageNode, packNodes);
            HashSet<PsiFile> searchFor = new HashSet<PsiFile>();
            for (PackageNode packageNode : packNodes) {
                searchFor.addAll(this.myBuilder.getDependentFilesInPackage((PsiPackage)packageNode.getPsiElement(), (PsiPackage)nextPackageNode.getPsiElement()));
            }
            if (searchIn.isEmpty() || searchFor.isEmpty()) {
                this.myUsagesPanel.setToInitialPosition();
            } else {
                String pack1Name = ((PsiPackage)nextPackageNode.getPsiElement()).getQualifiedName();
                String pack2Name = ((PsiPackage)selectedPackageNode.getPsiElement()).getQualifiedName();
                this.myBuilder.setRootNodeNameInUsageView(AnalysisScopeBundle.message((String)"cyclic.dependencies.usage.view.root.node.text", (Object[])new Object[]{pack1Name, pack2Name}));
                this.myUsagesPanel.findUsages(searchIn, searchFor);
            }
        }));
        this.initTree(this.myLeftTree);
        this.initTree(this.myRightTree);
        this.mySettings.UI_FILTER_LEGALS = false;
        this.mySettings.UI_FLATTEN_PACKAGES = false;
        TreeUtil.promiseSelectFirst((JTree)((Object)this.myLeftTree));
    }

    private static void getPackageNodesHierarchy(PackageNode node, Set<? super PackageNode> result) {
        result.add(node);
        for (int i = 0; i < node.getChildCount(); ++i) {
            PackageNode packNode;
            TreeNode child = node.getChildAt(i);
            if (!(child instanceof PackageNode) || result.contains((Object)(packNode = (PackageNode)((Object)child)))) continue;
            CyclicDependenciesPanel.getPackageNodesHierarchy(packNode, result);
        }
    }

    @Nullable
    private static PackageDependenciesNode getNextPackageNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode child = node;
        while (node != null) {
            if (node instanceof CycleNode) {
                TreeNode packageDependenciesNode;
                TreeNode treeNode = packageDependenciesNode = child.getNextSibling() != null ? child.getNextSibling() : node.getChildAt(0);
                if (packageDependenciesNode instanceof PackageNode) {
                    return (PackageNode)((Object)packageDependenciesNode);
                }
                if (packageDependenciesNode instanceof ModuleNode) {
                    return (PackageNode)((Object)packageDependenciesNode.getChildAt(0));
                }
            }
            child = node;
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return null;
    }

    private static PackageDependenciesNode hideEmptyMiddlePackages(PackageDependenciesNode node, StringBuffer result) {
        if (node.getChildCount() == 0 || node.getChildCount() > 1 || node.getChildCount() == 1 && node.getChildAt(0) instanceof FileNode) {
            result.append(result.length() != 0 ? "." : "").append(node.toString().equals(DEFAULT_PACKAGE_ABBREVIATION) ? "" : node.toString());
        } else if (node.getChildCount() == 1) {
            PackageDependenciesNode child = (PackageDependenciesNode)node.getChildAt(0);
            if (!(node instanceof PackageNode)) {
                node.removeAllChildren();
                child = CyclicDependenciesPanel.hideEmptyMiddlePackages(child, result);
                node.add((MutableTreeNode)child);
            } else if (child instanceof PackageNode) {
                node.removeAllChildren();
                result.append(result.length() != 0 ? "." : "").append(node.toString().equals(DEFAULT_PACKAGE_ABBREVIATION) ? "" : node.toString());
                node = CyclicDependenciesPanel.hideEmptyMiddlePackages(child, result);
                ((PackageNode)node).setPackageName(result.toString());
            }
        }
        return node;
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new CloseAction());
        group.add((AnAction)new RerunAction(this));
        group.add((AnAction)new ShowFilesAction());
        group.add((AnAction)new HideOutOfCyclePackagesAction());
        group.add((AnAction)new GroupByScopeTypeAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CyclicDependencies", (ActionGroup)group, true);
        return toolbar.getComponent();
    }

    private void rebuild() {
        this.updateLeftTreeModel();
        this.updateRightTreeModel();
    }

    private void initTree(MyTree tree) {
        tree.getSelectionModel().setSelectionMode(1);
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer(tree == this.myLeftTree)));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)((Object)tree));
        SmartExpander.installOn((JTree)((Object)tree));
        EditSourceOnDoubleClickHandler.install((JTree)((Object)tree));
        new TreeSpeedSearch((JTree)((Object)tree));
        PopupHandler.installUnknownPopupHandler((JComponent)((Object)tree), (ActionGroup)CyclicDependenciesPanel.createTreePopupActions(), (ActionManager)ActionManager.getInstance());
    }

    private void updateLeftTreeModel() {
        Set<PsiPackage> psiPackages = this.myDependencies.keySet();
        HashSet<PsiFile> psiFiles = new HashSet<PsiFile>();
        for (PsiPackage psiPackage : psiPackages) {
            Set<List<PsiPackage>> cycles = this.myDependencies.get(psiPackage);
            if (this.mySettings.UI_FILTER_OUT_OF_CYCLE_PACKAGES && (cycles == null || cycles.isEmpty())) continue;
            psiFiles.addAll(this.getPackageFiles(psiPackage));
        }
        boolean showFiles = this.mySettings.UI_SHOW_FILES;
        this.mySettings.UI_FLATTEN_PACKAGES = true;
        this.mySettings.UI_SHOW_FILES = false;
        this.myLeftTreeExpansionMonitor.freeze();
        this.myLeftTree.setModel((javax.swing.tree.TreeModel)TreeModelBuilder.createTreeModel(this.myProject, false, psiFiles, __ -> false, this.mySettings));
        this.myLeftTreeExpansionMonitor.restore();
        CyclicDependenciesPanel.expandFirstLevel(this.myLeftTree);
        this.mySettings.UI_SHOW_FILES = showFiles;
        this.mySettings.UI_FLATTEN_PACKAGES = false;
    }

    private static ActionGroup createTreePopupActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("EditSource"));
        group.add(ActionManager.getInstance().getAction("VersionControlsGroup"));
        return group;
    }

    private void updateRightTreeModel() {
        RootNode root = new RootNode(this.myProject);
        PackageNode packageNode = CyclicDependenciesPanel.getSelectedPackage(this.myLeftTree);
        if (packageNode != null) {
            boolean group = this.mySettings.UI_GROUP_BY_SCOPE_TYPE;
            this.mySettings.UI_GROUP_BY_SCOPE_TYPE = false;
            PsiPackage aPackage = (PsiPackage)packageNode.getPsiElement();
            Set<List<PsiPackage>> cyclesOfPackages = this.myDependencies.get(aPackage);
            for (List<PsiPackage> packCycle : cyclesOfPackages) {
                PackageDependenciesNode[] nodes = new PackageDependenciesNode[packCycle.size()];
                for (int i = packCycle.size() - 1; i >= 0; --i) {
                    PsiPackage psiPackage = packCycle.get(i);
                    PsiPackage nextPackage = packCycle.get(i == 0 ? packCycle.size() - 1 : i - 1);
                    PsiPackage prevPackage = packCycle.get(i == packCycle.size() - 1 ? 0 : i + 1);
                    Set<PsiFile> dependentFilesInPackage = this.myBuilder.getDependentFilesInPackage(prevPackage, psiPackage, nextPackage);
                    PackageDependenciesNode pack = (PackageDependenciesNode)TreeModelBuilder.createTreeModel(this.myProject, false, dependentFilesInPackage, __ -> false, this.mySettings).getRoot();
                    nodes[i] = CyclicDependenciesPanel.hideEmptyMiddlePackages((PackageDependenciesNode)pack.getChildAt(0), new StringBuffer());
                }
                CycleNode cycleNode = new CycleNode(this.myProject);
                for (PackageDependenciesNode node : nodes) {
                    node.setEquals(true);
                    cycleNode.insert((MutableTreeNode)node, 0);
                }
                root.add((MutableTreeNode)((Object)cycleNode));
            }
            this.mySettings.UI_GROUP_BY_SCOPE_TYPE = group;
        }
        this.myRightTreeExpansionMonitor.freeze();
        this.myRightTree.setModel((javax.swing.tree.TreeModel)new TreeModel((TreeNode)root, -1, -1));
        this.myRightTreeExpansionMonitor.restore();
        CyclicDependenciesPanel.expandFirstLevel(this.myRightTree);
    }

    private HashSet<PsiFile> getPackageFiles(PsiPackage psiPackage) {
        PsiClass[] classes2;
        HashSet<PsiFile> psiFiles = new HashSet<PsiFile>();
        for (PsiClass aClass : classes2 = psiPackage.getClasses()) {
            PsiFile file = aClass.getContainingFile();
            if (!this.myBuilder.getScope().contains((PsiElement)file)) continue;
            psiFiles.add(file);
        }
        return psiFiles;
    }

    private static void expandFirstLevel(Tree tree) {
        PackageDependenciesNode root = (PackageDependenciesNode)tree.getModel().getRoot();
        int count = root.getChildCount();
        if (count < 10) {
            for (int i = 0; i < count; ++i) {
                PackageDependenciesNode child = (PackageDependenciesNode)root.getChildAt(i);
                CyclicDependenciesPanel.expandNodeIfNotTooWide(tree, child);
            }
        }
    }

    private static void expandNodeIfNotTooWide(Tree tree, PackageDependenciesNode node) {
        int count = node.getChildCount();
        if (count > 5) {
            return;
        }
        tree.expandPath(new TreePath(node.getPath()));
    }

    @Nullable
    private static PackageNode getSelectedPackage(Tree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length != 1) {
            return null;
        }
        PackageDependenciesNode node = (PackageDependenciesNode)paths[0].getLastPathComponent();
        if (node.isRoot()) {
            return null;
        }
        if (node instanceof PackageNode) {
            return (PackageNode)node;
        }
        if (node instanceof FileNode) {
            return (PackageNode)((Object)node.getParent());
        }
        if (node instanceof ModuleNode) {
            return (PackageNode)((Object)node.getChildAt(0));
        }
        return null;
    }

    private static Set<PsiFile> getSelectedScope(Tree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length != 1) {
            return EMPTY_FILE_SET;
        }
        PackageDependenciesNode node = (PackageDependenciesNode)paths[0].getLastPathComponent();
        if (node.isRoot()) {
            return EMPTY_FILE_SET;
        }
        HashSet<PsiFile> result = new HashSet<PsiFile>();
        node.fillFiles(result, true);
        return result;
    }

    public void setContent(Content content) {
        this.myContent = content;
    }

    public void dispose() {
        TreeModelBuilder.clearCaches(this.myProject);
    }

    @Nullable
    @NonNls
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CyclicDependenciesPanel.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "dependency.viewer.tool.window";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/cyclicDependencies/ui/CyclicDependenciesPanel", "getData"));
    }

    private static class MyTree
    extends Tree
    implements DataProvider {
        private MyTree() {
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyTree.$$$reportNull$$$0(0);
            }
            PackageDependenciesNode node = this.getSelectedNode();
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return node;
            }
            return null;
        }

        @Nullable
        public PackageDependenciesNode getSelectedNode() {
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null || paths.length != 1) {
                return null;
            }
            Object lastPathComponent = paths[0].getLastPathComponent();
            if (lastPathComponent instanceof PackageDependenciesNode) {
                return (PackageDependenciesNode)lastPathComponent;
            }
            return (PackageDependenciesNode)((DefaultMutableTreeNode)lastPathComponent).getUserObject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/cyclicDependencies/ui/CyclicDependenciesPanel$MyTree", "getData"));
        }
    }

    private class RerunAction
    extends AnAction {
        RerunAction(JComponent comp) {
            super(CommonBundle.message((String)"action.rerun", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.rerun.dependency", (Object[])new Object[0]), AllIcons.Actions.Rerun);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), comp);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(CyclicDependenciesPanel.this.myBuilder.getScope().isValid());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(1);
            }
            DependenciesToolWindow.getInstance((Project)CyclicDependenciesPanel.this.myProject).closeContent(CyclicDependenciesPanel.this.myContent);
            CyclicDependenciesPanel.this.mySettings.copyToApplicationDependencySettings();
            SwingUtilities.invokeLater(() -> new CyclicDependenciesHandler(CyclicDependenciesPanel.this.myProject, CyclicDependenciesPanel.this.myBuilder.getScope()).analyze());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cyclicDependencies/ui/CyclicDependenciesPanel$RerunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class GroupByScopeTypeAction
    extends ToggleAction {
        GroupByScopeTypeAction() {
            super(AnalysisScopeBundle.message((String)"action.group.by.scope.type", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.group.by.scope.type.description", (Object[])new Object[0]), AllIcons.Actions.GroupByTestProduction);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                GroupByScopeTypeAction.$$$reportNull$$$0(0);
            }
            return ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_GROUP_BY_SCOPE_TYPE;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                GroupByScopeTypeAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_GROUP_BY_SCOPE_TYPE = flag;
            ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_GROUP_BY_SCOPE_TYPE = flag;
            CyclicDependenciesPanel.this.rebuild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/cyclicDependencies/ui/CyclicDependenciesPanel$GroupByScopeTypeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class HideOutOfCyclePackagesAction
    extends ToggleAction {
        @NonNls
        static final String SHOW_PACKAGES_FROM_CYCLES_ONLY = "Hide packages without cyclic dependencies";

        HideOutOfCyclePackagesAction() {
            super(SHOW_PACKAGES_FROM_CYCLES_ONLY, SHOW_PACKAGES_FROM_CYCLES_ONLY, AllIcons.General.Filter);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                HideOutOfCyclePackagesAction.$$$reportNull$$$0(0);
            }
            return ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_FILTER_OUT_OF_CYCLE_PACKAGES;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                HideOutOfCyclePackagesAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_FILTER_OUT_OF_CYCLE_PACKAGES = state;
            ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_FILTER_OUT_OF_CYCLE_PACKAGES = state;
            CyclicDependenciesPanel.this.rebuild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cyclicDependencies/ui/CyclicDependenciesPanel$HideOutOfCyclePackagesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ShowFilesAction
    extends ToggleAction {
        ShowFilesAction() {
            super(AnalysisScopeBundle.message((String)"action.show.files", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.show.files.description", (Object[])new Object[0]), AllIcons.FileTypes.Java);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                ShowFilesAction.$$$reportNull$$$0(0);
            }
            return ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_SHOW_FILES;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                ShowFilesAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_SHOW_FILES = flag;
            ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_SHOW_FILES = flag;
            CyclicDependenciesPanel.this.rebuild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/cyclicDependencies/ui/CyclicDependenciesPanel$ShowFilesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class CloseAction
    extends AnAction
    implements DumbAware {
        CloseAction() {
            super(CommonBundle.message((String)"action.close", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.close.dependency.description", (Object[])new Object[0]), AllIcons.Actions.Cancel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(0);
            }
            Disposer.dispose((Disposable)CyclicDependenciesPanel.this.myUsagesPanel);
            DependenciesToolWindow.getInstance((Project)CyclicDependenciesPanel.this.myProject).closeContent(CyclicDependenciesPanel.this.myContent);
            CyclicDependenciesPanel.this.mySettings.copyToApplicationDependencySettings();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cyclicDependencies/ui/CyclicDependenciesPanel$CloseAction", "actionPerformed"));
        }
    }

    private class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final boolean myLeftTree;

        MyTreeCellRenderer(boolean isLeftTree) {
            this.myLeftTree = isLeftTree;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            PackageDependenciesNode node;
            if (tree == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (value2 instanceof PackageDependenciesNode) {
                PsiElement element;
                node = (PackageDependenciesNode)value2;
                if (this.myLeftTree && !((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_FILTER_OUT_OF_CYCLE_PACKAGES && (element = node.getPsiElement()) instanceof PsiPackage) {
                    PsiPackage aPackage = (PsiPackage)element;
                    Set packageDependencies = (Set)CyclicDependenciesPanel.this.myDependencies.get(aPackage);
                    if (packageDependencies != null && !packageDependencies.isEmpty()) {
                        attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                    }
                }
            } else {
                node = (PackageDependenciesNode)((DefaultMutableTreeNode)value2).getUserObject();
            }
            this.append(node.toString(), attributes);
            this.setIcon(node.getIcon());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/cyclicDependencies/ui/CyclicDependenciesPanel$MyTreeCellRenderer", "customizeCellRenderer"));
        }
    }
}

