/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.server.AutomakeCompileContext;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.notification.Notification;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import java.util.Collections;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineRemoteProto;

class AutoMakeMessageHandler
extends DefaultMessageHandler {
    private static final Key<Notification> LAST_AUTO_MAKE_NOTIFICATION = Key.create((String)"LAST_AUTO_MAKE_NOTIFICATION");
    private CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status myBuildStatus;
    private final Project myProject;
    private final WolfTheProblemSolver myWolf;
    private volatile boolean myUnprocessedFSChangesDetected;
    private final AutomakeCompileContext myContext;

    AutoMakeMessageHandler(@NotNull Project project) {
        if (project == null) {
            AutoMakeMessageHandler.$$$reportNull$$$0(0);
        }
        super(project);
        this.myUnprocessedFSChangesDetected = false;
        this.myProject = project;
        this.myBuildStatus = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.SUCCESS;
        this.myWolf = WolfTheProblemSolver.getInstance((Project)project);
        this.myContext = new AutomakeCompileContext(project);
    }

    public boolean unprocessedFSChangesDetected() {
        return this.myUnprocessedFSChangesDetected;
    }

    @Override
    protected void handleBuildEvent(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event) {
        if (this.myProject.isDisposed()) {
            return;
        }
        switch (event.getEventType()) {
            case BUILD_COMPLETED: {
                this.myContext.getProgressIndicator().stop();
                if (event.hasCompletionStatus()) {
                    CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status;
                    this.myBuildStatus = status = event.getCompletionStatus();
                    if (status == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.CANCELED) {
                        this.myContext.getProgressIndicator().cancel();
                    }
                }
                int errors = this.myContext.getMessageCount(CompilerMessageCategory.ERROR);
                int warnings = this.myContext.getMessageCount(CompilerMessageCategory.WARNING);
                SwingUtilities.invokeLater(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    CompilationStatusListener publisher = (CompilationStatusListener)this.myProject.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                    publisher.automakeCompilationFinished(errors, warnings, (CompileContext)this.myContext);
                });
                return;
            }
            case FILES_GENERATED: {
                CompilationStatusListener publisher = (CompilationStatusListener)this.myProject.getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS);
                for (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile : event.getGeneratedFilesList()) {
                    String root = FileUtil.toSystemIndependentName((String)generatedFile.getOutputRoot());
                    String relativePath = FileUtil.toSystemIndependentName((String)generatedFile.getRelativePath());
                    publisher.fileGenerated(root, relativePath);
                }
                return;
            }
            case CUSTOM_BUILDER_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage message2;
                if (event.hasCustomBuilderMessage() && "JPS".equals((message2 = event.getCustomBuilderMessage()).getBuilderId()) && "!unprocessed_fs_changes_detected!".equals(message2.getMessageType())) {
                    this.myUnprocessedFSChangesDetected = true;
                }
                return;
            }
        }
    }

    @Override
    protected void handleCompileMessage(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message2) {
        if (this.myProject.isDisposed()) {
            return;
        }
        CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind2 = message2.getKind();
        if (kind2 == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS) {
            ProblemsView view = ProblemsView.SERVICE.getInstance(this.myProject);
            if (message2.hasDone()) {
                view.setProgress(message2.getText(), message2.getDone());
            } else {
                view.setProgress(message2.getText());
            }
        } else {
            CompilerMessageCategory category = CompileDriver.convertToCategory(kind2, null);
            if (category != null) {
                String sourceFilePath = message2.hasSourceFilePath() ? message2.getSourceFilePath() : null;
                String url = sourceFilePath != null ? VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)sourceFilePath)) : null;
                long line = message2.hasLine() ? message2.getLine() : -1L;
                long column = message2.hasColumn() ? message2.getColumn() : -1L;
                CompilerMessage msg = this.myContext.createAndAddMessage(category, message2.getText(), url, (int)line, (int)column, null);
                if (category == CompilerMessageCategory.ERROR || kind2 == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.JPS_INFO) {
                    if (category == CompilerMessageCategory.ERROR) {
                        ReadAction.run(() -> this.informWolf(this.myProject, message2));
                    }
                    if (msg != null) {
                        ProblemsView.SERVICE.getInstance(this.myProject).addMessage(msg, sessionId);
                    }
                }
            }
        }
    }

    @Override
    public void handleFailure(@NotNull UUID sessionId, CmdlineRemoteProto.Message.Failure failure) {
        String descr;
        if (sessionId == null) {
            AutoMakeMessageHandler.$$$reportNull$$$0(1);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        String string = descr = failure.hasDescription() ? failure.getDescription() : null;
        if (descr == null) {
            descr = failure.hasStacktrace() ? failure.getStacktrace() : "";
        }
        String msg = "Auto build failure: " + descr;
        CompilerManager.NOTIFICATION_GROUP.createNotification(msg, MessageType.INFO);
        ProblemsView.SERVICE.getInstance(this.myProject).addMessage(new CompilerMessageImpl(this.myProject, CompilerMessageCategory.ERROR, msg), sessionId);
    }

    @Override
    public void sessionTerminated(@NotNull UUID sessionId) {
        Notification notification;
        if (sessionId == null) {
            AutoMakeMessageHandler.$$$reportNull$$$0(2);
        }
        String statusMessage = null;
        switch (this.myBuildStatus) {
            case SUCCESS: {
                break;
            }
            case UP_TO_DATE: {
                break;
            }
            case ERRORS: {
                statusMessage = "Auto build completed with errors";
                break;
            }
        }
        if (statusMessage != null) {
            notification = CompilerManager.NOTIFICATION_GROUP.createNotification(statusMessage, MessageType.INFO);
            if (!this.myProject.isDisposed()) {
                notification.notify(this.myProject);
            }
            this.myProject.putUserData(LAST_AUTO_MAKE_NOTIFICATION, (Object)notification);
        } else {
            notification = (Notification)this.myProject.getUserData(LAST_AUTO_MAKE_NOTIFICATION);
            if (notification != null) {
                notification.expire();
                this.myProject.putUserData(LAST_AUTO_MAKE_NOTIFICATION, null);
            }
        }
        if (!this.myProject.isDisposed()) {
            ProblemsView view = ProblemsView.SERVICE.getInstance(this.myProject);
            view.clearProgress();
            view.clearOldMessages(null, sessionId);
        }
    }

    private void informWolf(Project project, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message2) {
        VirtualFile vFile;
        String srcPath = message2.getSourceFilePath();
        if (srcPath != null && !project.isDisposed() && (vFile = LocalFileSystem.getInstance().findFileByPath(srcPath)) != null) {
            int line = (int)message2.getLine();
            int column = (int)message2.getColumn();
            if (line > 0 && column > 0) {
                Problem problem = this.myWolf.convertToProblem(vFile, line, column, new String[]{message2.getText()});
                this.myWolf.weHaveGotProblems(vFile, Collections.singletonList(problem));
            } else {
                this.myWolf.queue(vFile);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/server/AutoMakeMessageHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleFailure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sessionTerminated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

