/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfigurable;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ValidationConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private JCheckBox myValidateBox;
    private ElementsChooser<Compiler> myValidators;
    private JPanel myExcludedEntriesPanel;
    private final Project myProject;
    private final ValidationConfiguration myConfiguration;
    private final ExcludedEntriesConfigurable myExcludedConfigurable;

    public ValidationConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myConfiguration = ValidationConfiguration.getInstance(this.myProject);
        this.myExcludedConfigurable = ValidationConfigurable.createExcludedConfigurable(project);
        this.myValidators.getEmptyText().setText(CompilerBundle.message((String)"no.validators", (Object[])new Object[0]));
    }

    private static ExcludedEntriesConfigurable createExcludedConfigurable(final Project project) {
        ExcludesConfiguration configuration = ValidationConfiguration.getExcludedEntriesConfiguration(project);
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (project.isDefault() || !index.isExcluded(file));
            }
        };
        ArrayList allContentRoots = new ArrayList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            VirtualFile[] moduleContentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            Collections.addAll(allContentRoots, moduleContentRoots);
        }
        descriptor.setRoots(allContentRoots);
        return new ExcludedEntriesConfigurable(project, descriptor, configuration);
    }

    @NotNull
    public String getId() {
        if ("project.validation" == null) {
            ValidationConfigurable.$$$reportNull$$$0(0);
        }
        return "project.validation";
    }

    public String getDisplayName() {
        return CompilerBundle.message((String)"validation.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.validation";
    }

    public JComponent createComponent() {
        GridConstraints constraints = new GridConstraints();
        constraints.setFill(3);
        this.myExcludedEntriesPanel.add((Component)this.myExcludedConfigurable.createComponent(), constraints);
        return this.myPanel;
    }

    public boolean isModified() {
        List selectedElements = this.myValidators.getMarkedElements();
        List<Compiler> markedValidators = this.getMarkedValidators();
        if (markedValidators.size() != selectedElements.size()) {
            return true;
        }
        THashSet set = new THashSet((Collection)selectedElements, (TObjectHashingStrategy)new TObjectHashingStrategy<Compiler>(){

            public int computeHashCode(Compiler object) {
                return object.getDescription().hashCode();
            }

            public boolean equals(Compiler o1, Compiler o2) {
                return o1.getDescription().equals(o2.getDescription());
            }
        });
        return this.myConfiguration.isValidateOnBuild() != this.myValidateBox.isSelected() || set.retainAll(markedValidators) || this.myExcludedConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.setValidateOnBuild(this.myValidateBox.isSelected());
        for (int i = 0; i < this.myValidators.getElementCount(); ++i) {
            Compiler validator2 = (Compiler)this.myValidators.getElementAt(i);
            this.myConfiguration.setSelected(validator2, this.myValidators.isElementMarked((Object)validator2));
        }
        this.myExcludedConfigurable.apply();
    }

    public void reset() {
        this.myValidateBox.setSelected(this.myConfiguration.isValidateOnBuild());
        List<Compiler> validators = this.getValidators();
        Collections.sort(validators, Comparator.comparing(Compiler::getDescription));
        this.myValidators.setElements(validators, false);
        this.myValidators.markElements(this.getMarkedValidators());
        this.myExcludedConfigurable.reset();
    }

    private List<Compiler> getMarkedValidators() {
        List<Compiler> validators = this.getValidators();
        return ContainerUtil.mapNotNull(validators, (Function)((NullableFunction)validator2 -> this.myConfiguration.isSelected((Compiler)validator2) ? validator2 : null));
    }

    private List<Compiler> getValidators() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        return new SmartList((Object[])compilerManager.getCompilers(Validator.class));
    }

    public void disposeUIResources() {
        this.myExcludedConfigurable.disposeUIResources();
    }

    private void createUIComponents() {
        this.myValidators = new ElementsChooser<Compiler>(true){

            protected String getItemText(@NotNull Compiler validator2) {
                if (validator2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                String description = validator2.getDescription();
                return description.replace(" Validator", "").replace(" validator", "");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "com/intellij/compiler/options/ValidationConfigurable$3", "getItemText"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/options/ValidationConfigurable", "getId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myValidateBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Validate on build");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Validators", (int)0, (int)0, null, null));
        ElementsChooser<Compiler> elementsChooser = this.myValidators;
        jPanel4.add((Component)elementsChooser, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        this.myExcludedEntriesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Exclude From Validation", (int)0, (int)0, null, null));
        Splitter splitter = new Splitter();
        splitter.setOrientation(true);
        jPanel3.add((Component)splitter, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        splitter.setFirstComponent((JComponent)jPanel4);
        splitter.setSecondComponent((JComponent)jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

