/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.compiler.options.ModuleOptionsTableModel;
import com.intellij.compiler.options.ModuleTableCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class CompilerModuleOptionsComponent
extends JPanel {
    private final JBTable myTable;
    private final Project myProject;

    public CompilerModuleOptionsComponent(@NotNull Project project) {
        if (project == null) {
            CompilerModuleOptionsComponent.$$$reportNull$$$0(0);
        }
        super(new GridBagLayout());
        this.myProject = project;
        this.myTable = new JBTable((TableModel)new ModuleOptionsTableModel());
        this.myTable.setRowHeight(JBUIScale.scale((int)22));
        this.myTable.getEmptyText().setText("Additional compilation options will be the same for all modules");
        TableColumn moduleColumn = this.myTable.getColumnModel().getColumn(0);
        moduleColumn.setHeaderValue("Module");
        moduleColumn.setCellRenderer(new ModuleTableCellRenderer());
        TableColumn optionsColumn = this.myTable.getColumnModel().getColumn(1);
        String columnTitle = "Compilation options";
        optionsColumn.setHeaderValue(columnTitle);
        int width = this.myTable.getFontMetrics(this.myTable.getFont()).stringWidth(columnTitle) + 10;
        optionsColumn.setPreferredWidth(width);
        optionsColumn.setMinWidth(width);
        ExpandableTextField editor = new ExpandableTextField();
        InsertPathAction.addTo((JTextComponent)editor, null, (boolean)false);
        optionsColumn.setCellEditor(new DefaultCellEditor((JTextField)editor));
        new TableSpeedSearch((JTable)this.myTable);
        JPanel table = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpAction().disableDownAction().setAddAction(b -> this.addModules()).setRemoveAction(b -> this.removeSelectedModules()).createPanel();
        table.setPreferredSize(new Dimension(this.myTable.getWidth(), 150));
        JLabel header = new JLabel("Override compiler parameters per-module:");
        this.add((Component)header, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)table, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
    }

    private void addModules() {
        int i = ((ModuleOptionsTableModel)this.myTable.getModel()).addModulesToModel(this.myProject, this);
        if (i >= 0) {
            TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{i});
            TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        }
    }

    private void removeSelectedModules() {
        if (this.myTable.getSelectedRows().length > 0) {
            TableUtil.removeSelectedItems((JTable)this.myTable);
        }
    }

    @NotNull
    public Map<String, String> getModuleOptionsMap() {
        Map<String, String> map2 = ((ModuleOptionsTableModel)this.myTable.getModel()).getModuleOptions();
        if (map2 == null) {
            CompilerModuleOptionsComponent.$$$reportNull$$$0(1);
        }
        return map2;
    }

    public void setModuleOptionsMap(@NotNull Map<String, String> moduleOptions) {
        if (moduleOptions == null) {
            CompilerModuleOptionsComponent.$$$reportNull$$$0(2);
        }
        ((ModuleOptionsTableModel)this.myTable.getModel()).setModuleOptions(this.myProject, moduleOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/javaCompiler/CompilerModuleOptionsComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/javaCompiler/CompilerModuleOptionsComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleOptionsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModuleOptionsMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

