/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.CompilerContentIterator;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OneProjectItemCompileScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.OneProjectItemCompileScope");
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myUrl;

    public OneProjectItemCompileScope(Project project, VirtualFile file) {
        this.myProject = project;
        this.myFile = file;
        String url = file.getUrl();
        this.myUrl = file.isDirectory() ? url + "/" : url;
    }

    @NotNull
    public VirtualFile[] getFiles(FileType fileType, boolean inSourceOnly) {
        ArrayList files = new ArrayList(1);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        CompilerContentIterator iterator = new CompilerContentIterator(fileType, (FileIndex)projectFileIndex, inSourceOnly, files);
        if (this.myFile.isDirectory()) {
            projectFileIndex.iterateContentUnderDirectory(this.myFile, (ContentIterator)iterator);
        } else {
            iterator.processFile(this.myFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files);
        if (virtualFileArray == null) {
            OneProjectItemCompileScope.$$$reportNull$$$0(0);
        }
        return virtualFileArray;
    }

    public boolean belongs(@NotNull String url) {
        if (url == null) {
            OneProjectItemCompileScope.$$$reportNull$$$0(1);
        }
        if (this.myFile.isDirectory()) {
            return FileUtil.startsWith((String)url, (String)this.myUrl);
        }
        return FileUtil.pathsEqual((String)url, (String)this.myUrl);
    }

    @NotNull
    public Module[] getAffectedModules() {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)this.myFile, (Project)this.myProject);
        if (module == null) {
            LOG.error("Module is null for file " + this.myFile.getPresentableUrl());
            if (Module.EMPTY_ARRAY == null) {
                OneProjectItemCompileScope.$$$reportNull$$$0(2);
            }
            return Module.EMPTY_ARRAY;
        }
        Module[] moduleArray = new Module[]{module};
        if (moduleArray == null) {
            OneProjectItemCompileScope.$$$reportNull$$$0(3);
        }
        return moduleArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/OneProjectItemCompileScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/OneProjectItemCompileScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedModules";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "belongs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

