/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.codeInsight.daemon.impl.actions.SuppressFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressForClassFix;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.CompilerPropertiesAction;
import com.intellij.compiler.impl.ExcludeFromCompileAction;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CompilerErrorTreeView
extends NewErrorTreeViewPanel {
    public CompilerErrorTreeView(Project project, Runnable rerunAction) {
        super(project, null, true, true, rerunAction);
    }

    protected void fillRightToolbarGroup(DefaultActionGroup group) {
        super.fillRightToolbarGroup(group);
        group.addSeparator();
        group.add((AnAction)new CompilerPropertiesAction());
    }

    protected void addExtraPopupMenuActions(DefaultActionGroup group) {
        group.addSeparator();
        group.add((AnAction)new ExcludeFromCompileAction(this.myProject, this));
        group.add((AnAction)new SuppressJavacWarningsAction());
        group.add((AnAction)new SuppressJavacWarningForClassAction());
        ActionGroup popupGroup = (ActionGroup)ActionManager.getInstance().getAction("CompilerErrorViewPopupMenu");
        if (popupGroup != null) {
            for (AnAction action : popupGroup.getChildren(null)) {
                group.add(action);
            }
        }
    }

    protected boolean shouldShowFirstErrorInEditor() {
        return CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).AUTO_SHOW_ERRORS_IN_EDITOR;
    }

    private class SuppressJavacWarningForClassAction
    extends SuppressJavacWarningsAction {
        private SuppressJavacWarningForClassAction() {
        }

        @Override
        protected SuppressFix getSuppressAction(@NotNull String id) {
            if (id == null) {
                SuppressJavacWarningForClassAction.$$$reportNull$$$0(0);
            }
            return new SuppressForClassFix(id){

                @Override
                protected boolean use15Suppressions(@NotNull PsiJavaDocumentedElement container) {
                    if (container == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningForClassAction$1", "use15Suppressions"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningForClassAction", "getSuppressAction"));
        }
    }

    private class SuppressJavacWarningsAction
    extends AnAction {
        private SuppressJavacWarningsAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SuppressJavacWarningsAction.$$$reportNull$$$0(0);
            }
            NavigatableMessageElement messageElement = (NavigatableMessageElement)CompilerErrorTreeView.this.getSelectedErrorTreeElement();
            String[] text2 = messageElement.getText();
            String id = text2[0].substring(1, text2[0].indexOf("]"));
            SuppressFix suppressInspectionFix = this.getSuppressAction(id);
            Project project = e.getProject();
            assert (project != null);
            OpenFileDescriptor navigatable = (OpenFileDescriptor)messageElement.getNavigatable();
            PsiFile file = PsiManager.getInstance((Project)project).findFile(navigatable.getFile());
            assert (file != null);
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    suppressInspectionFix.invoke(project, file.findElementAt(navigatable.getOffset()));
                }
                catch (IncorrectOperationException e1) {
                    LOG.error((Throwable)e1);
                }
            }), suppressInspectionFix.getText(), null);
        }

        public void update(@NotNull AnActionEvent e) {
            Navigatable navigatable;
            NavigatableMessageElement messageElement;
            String[] text2;
            if (e == null) {
                SuppressJavacWarningsAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(false);
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            ErrorTreeElement errorTreeElement = CompilerErrorTreeView.this.getSelectedErrorTreeElement();
            if (errorTreeElement instanceof NavigatableMessageElement && (text2 = (messageElement = (NavigatableMessageElement)errorTreeElement).getText()).length > 0 && text2[0].startsWith("[") && text2[0].indexOf("]") != -1 && (navigatable = messageElement.getNavigatable()) instanceof OpenFileDescriptor) {
                OpenFileDescriptor fileDescriptor = (OpenFileDescriptor)navigatable;
                VirtualFile virtualFile = fileDescriptor.getFile();
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
                if (module == null) {
                    return;
                }
                Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (jdk == null) {
                    return;
                }
                boolean is_1_5 = JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_5);
                if (!is_1_5) {
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (psiFile == null) {
                    return;
                }
                if (EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module).compareTo((Enum)LanguageLevel.JDK_1_5) < 0) {
                    return;
                }
                PsiElement context = psiFile.findElementAt(fileDescriptor.getOffset());
                if (context == null) {
                    return;
                }
                String id = text2[0].substring(1, text2[0].indexOf("]"));
                SuppressFix suppressInspectionFix = this.getSuppressAction(id);
                boolean available = suppressInspectionFix.isAvailable(project, context);
                presentation.setEnabledAndVisible(available);
                if (available) {
                    presentation.setText(suppressInspectionFix.getText());
                }
            }
        }

        protected SuppressFix getSuppressAction(@NotNull String id) {
            if (id == null) {
                SuppressJavacWarningsAction.$$$reportNull$$$0(2);
            }
            return new SuppressFix(id){

                @Override
                public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (context == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (this.getContainer(context) instanceof PsiClass) {
                        return false;
                    }
                    return super.isAvailable(project, context);
                }

                @Override
                protected boolean use15Suppressions(@NotNull PsiJavaDocumentedElement container) {
                    if (container == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "container";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningsAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "use15Suppressions";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSuppressAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

