/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.compiler.chainsSearch.ChainOpAndOccurrences;
import com.intellij.compiler.chainsSearch.OperationChain;
import com.intellij.compiler.chainsSearch.RefChainOperation;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;

public class SearchInitializer {
    private final ChainCompletionContext myContext;
    private final LinkedList<OperationChain> myQueue;
    private final LinkedHashMap<RefChainOperation, OperationChain> myChains;

    public SearchInitializer(SortedSet<? extends ChainOpAndOccurrences<? extends RefChainOperation>> indexValues, ChainCompletionContext context) {
        this.myContext = context;
        int size = indexValues.size();
        ArrayList chains = new ArrayList(size);
        this.populateFrequentlyUsedMethod(indexValues, chains);
        this.myQueue = new LinkedList();
        this.myChains = new LinkedHashMap(chains.size());
        for (OperationChain chain : chains) {
            RefChainOperation signature = chain.getHead();
            this.myQueue.add(chain);
            this.myChains.put(signature, chain);
        }
    }

    public LinkedList<OperationChain> getChainQueue() {
        return this.myQueue;
    }

    public LinkedHashMap<RefChainOperation, OperationChain> getChains() {
        return this.myChains;
    }

    private void populateFrequentlyUsedMethod(SortedSet<? extends ChainOpAndOccurrences> operations, List<? super OperationChain> chains) {
        int bestOccurrences = -1;
        for (ChainOpAndOccurrences chainOpAndOccurrences : operations) {
            OperationChain operationChain = OperationChain.create(chainOpAndOccurrences.getOperation(), chainOpAndOccurrences.getOccurrenceCount(), this.myContext);
            if (operationChain == null) continue;
            chains.add(operationChain);
            int occurrences = chainOpAndOccurrences.getOccurrenceCount();
            if (bestOccurrences == -1) {
                bestOccurrences = occurrences;
                continue;
            }
            if (bestOccurrences <= occurrences * 10) continue;
            return;
        }
    }
}

