/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import java.util.Collection;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;

public enum CompilerHierarchySearchType {
    DIRECT_INHERITOR{

        @Override
        PsiElement[] performSearchInFile(SearchId[] definitions, PsiNamedElement baseElement, PsiFileWithStubSupport file, LanguageCompilerRefAdapter adapter) {
            return adapter.findDirectInheritorCandidatesInFile(definitions, file);
        }

        @Override
        Class<? extends CompilerRef> getRequiredClass(LanguageCompilerRefAdapter adapter) {
            return adapter.getHierarchyObjectClass();
        }

        @Override
        SearchId[] convertToIds(Collection<CompilerRef> compilerRef, NameEnumerator nameEnumerator) {
            return (SearchId[])compilerRef.stream().map(r -> r instanceof CompilerRef.JavaCompilerAnonymousClassRef ? new SearchId(((CompilerRef.JavaCompilerAnonymousClassRef)r).getName()) : new SearchId(nameEnumerator.getName(((CompilerRef.CompilerClassHierarchyElementDef)r).getName()))).toArray(SearchId[]::new);
        }
    }
    ,
    FUNCTIONAL_EXPRESSION{

        @Override
        PsiElement[] performSearchInFile(SearchId[] definitions, PsiNamedElement baseElement, PsiFileWithStubSupport file, LanguageCompilerRefAdapter adapter) {
            return adapter.findFunExpressionsInFile(definitions, file);
        }

        @Override
        Class<? extends CompilerRef> getRequiredClass(LanguageCompilerRefAdapter adapter) {
            return adapter.getFunExprClass();
        }

        @Override
        SearchId[] convertToIds(Collection<CompilerRef> compilerRef, NameEnumerator nameEnumerator) {
            return (SearchId[])compilerRef.stream().map(r -> ((CompilerRef.CompilerFunExprDef)r).getId()).map(SearchId::new).toArray(SearchId[]::new);
        }
    };


    abstract PsiElement[] performSearchInFile(SearchId[] var1, PsiNamedElement var2, PsiFileWithStubSupport var3, LanguageCompilerRefAdapter var4);

    abstract Class<? extends CompilerRef> getRequiredClass(LanguageCompilerRefAdapter var1);

    abstract SearchId[] convertToIds(Collection<CompilerRef> var1, NameEnumerator var2);
}

