/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationOptionsImpl;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.LibraryDefinitionsGeneratorFactory;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.PathElement;
import com.intellij.compiler.ant.taskdefs.PathRef;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ModuleChunkClasspath
extends Path {
    public ModuleChunkClasspath(final ModuleChunk chunk, final GenerationOptions genOptions, final boolean generateRuntimeClasspath, final boolean generateTestClasspath) {
        super(ModuleChunkClasspath.generateClasspathName(chunk, generateRuntimeClasspath, generateTestClasspath));
        final OrderedSet pathItems = new OrderedSet();
        final String moduleChunkBasedirProperty = BuildProperties.getModuleChunkBasedirProperty((ModuleChunk)chunk);
        Module[] modules = chunk.getModules();
        final HashSet processedChunks = new HashSet();
        final HashSet processedModules = new HashSet();
        for (Module module : modules) {
            new Object(){

                public void processModule(Module module, int dependencyLevel, boolean isModuleExported) {
                    if (processedModules.contains(module)) {
                        return;
                    }
                    if (!(dependencyLevel <= 1 || isModuleExported || genOptions.inlineRuntimeClasspath && generateRuntimeClasspath)) {
                        return;
                    }
                    processedModules.add(module);
                    ProjectEx project = (ProjectEx)chunk.getProject();
                    File baseDir = BuildProperties.getProjectBaseDir((Project)project);
                    OrderEnumerator enumerator = ModuleRootManager.getInstance((Module)module).orderEntries();
                    if (generateRuntimeClasspath) {
                        enumerator = enumerator.runtimeOnly();
                    } else {
                        enumerator = enumerator.compileOnly();
                        if (!generateTestClasspath && (dependencyLevel == 0 || chunk.contains(module))) {
                            enumerator = enumerator.withoutModuleSourceEntries();
                        }
                    }
                    if (!generateTestClasspath) {
                        enumerator = enumerator.productionOnly();
                    }
                    enumerator.forEach(orderEntry -> {
                        if (!orderEntry.isValid()) {
                            return true;
                        }
                        if (!(generateRuntimeClasspath || orderEntry instanceof ModuleOrderEntry || orderEntry instanceof ModuleSourceOrderEntry)) {
                            boolean isExported;
                            boolean bl = isExported = orderEntry instanceof ExportableOrderEntry && ((ExportableOrderEntry)orderEntry).isExported();
                            if (dependencyLevel > 0 && !isExported) {
                                return true;
                            }
                        }
                        if (orderEntry instanceof JdkOrderEntry) {
                            if (genOptions2.forceTargetJdk && !generateRuntimeClasspath) {
                                pathItems.add((Object)new PathRefItem(BuildProperties.propertyRef((String)BuildProperties.getModuleChunkJdkClasspathProperty((String)chunk.getName()))));
                            }
                        } else if (orderEntry instanceof ModuleOrderEntry) {
                            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                            Module dependentModule = moduleOrderEntry.getModule();
                            if (!chunk.contains(dependentModule)) {
                                if (generateRuntimeClasspath && !genOptions2.inlineRuntimeClasspath) {
                                    ModuleChunk depChunk = genOptions.getChunkByModule(dependentModule);
                                    if (!processedChunks.contains(depChunk)) {
                                        processedChunks.add(depChunk);
                                        String property = generateTestClasspath ? BuildProperties.getTestRuntimeClasspathProperty((String)depChunk.getName()) : BuildProperties.getRuntimeClasspathProperty((String)depChunk.getName());
                                        pathItems.add((Object)new PathRefItem(property));
                                    }
                                } else {
                                    this.processModule(dependentModule, dependencyLevel + 1, moduleOrderEntry.isExported());
                                }
                            }
                        } else if (orderEntry instanceof LibraryOrderEntry) {
                            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                            String libraryName = libraryOrderEntry.getLibraryName();
                            if (((LibraryOrderEntry)orderEntry).isModuleLevel()) {
                                CompositeGenerator gen = new CompositeGenerator();
                                gen.setHasLeadingNewline(false);
                                LibraryDefinitionsGeneratorFactory.genLibraryContent(project, genOptions, libraryOrderEntry.getLibrary(), baseDir, gen);
                                pathItems.add((Object)new GeneratorItem(libraryName, (Generator)gen));
                            } else {
                                pathItems.add((Object)new PathRefItem(BuildProperties.getLibraryPathId((String)libraryName)));
                            }
                        } else if (orderEntry instanceof ModuleSourceOrderEntry) {
                            for (String url : ModuleChunkClasspath.getCompilationClasses(module, (GenerationOptionsImpl)genOptions, generateRuntimeClasspath, generateTestClasspath, dependencyLevel == 0)) {
                                String propertyRef = genOptions.getPropertyRefForUrl(url = StringUtil.trimEnd((String)url, (String)"!/"));
                                if (propertyRef != null) {
                                    pathItems.add((Object)new PathElementItem(propertyRef));
                                    continue;
                                }
                                String path = VirtualFileManager.extractPath((String)url);
                                pathItems.add((Object)new PathElementItem(GenerationUtils.toRelativePath((String)path, (File)chunk.getBaseDir(), (String)moduleChunkBasedirProperty, (GenerationOptions)genOptions)));
                            }
                        } else {
                            pathItems.add((Object)new GeneratorItem(orderEntry.getClass().getName(), new Comment("Unknown OrderEntryType: " + orderEntry.getClass().getName())));
                        }
                        return true;
                    });
                }
            }.processModule(module, 0, false);
        }
        for (ClasspathItem pathItem : pathItems) {
            this.add(pathItem.toGenerator());
        }
    }

    private static String generateClasspathName(ModuleChunk chunk, boolean generateRuntimeClasspath, boolean generateTestClasspath) {
        if (generateTestClasspath) {
            return generateRuntimeClasspath ? BuildProperties.getTestRuntimeClasspathProperty((String)chunk.getName()) : BuildProperties.getTestClasspathProperty((String)chunk.getName());
        }
        return generateRuntimeClasspath ? BuildProperties.getRuntimeClasspathProperty((String)chunk.getName()) : BuildProperties.getClasspathProperty((String)chunk.getName());
    }

    private static String[] getCompilationClasses(Module module, GenerationOptionsImpl options, boolean forRuntime, boolean forTest, boolean firstLevel) {
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        if (!forRuntime) {
            if (forTest) {
                return extension.getOutputRootUrls(!firstLevel);
            }
            return firstLevel ? ArrayUtilRt.EMPTY_STRING_ARRAY : extension.getOutputRootUrls(false);
        }
        Set<String> jdkUrls = options.getAllJdkUrls();
        OrderedSet urls = new OrderedSet();
        ContainerUtil.addAll((Collection)urls, (Object[])extension.getOutputRootUrls(forTest));
        urls.removeAll(jdkUrls);
        return ArrayUtilRt.toStringArray((Collection)urls);
    }

    private static class PathRefItem
    extends ClasspathItem {
        PathRefItem(String value2) {
            super(value2);
        }

        @Override
        public Generator toGenerator() {
            return new PathRef(this.myValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PathRefItem)) {
                return false;
            }
            PathRefItem pathRefItem = (PathRefItem)o;
            return this.myValue.equals(pathRefItem.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }
    }

    private static class PathElementItem
    extends ClasspathItem {
        PathElementItem(String value2) {
            super(value2);
        }

        @Override
        public Generator toGenerator() {
            return new PathElement(this.myValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PathElementItem)) {
                return false;
            }
            PathElementItem pathElementItem = (PathElementItem)o;
            return this.myValue.equals(pathElementItem.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }
    }

    private static class GeneratorItem
    extends ClasspathItem {
        final Generator myGenerator;

        GeneratorItem(String value2, Generator generator) {
            super(value2);
            this.myGenerator = generator;
        }

        @Override
        public Generator toGenerator() {
            return this.myGenerator;
        }
    }

    private static abstract class ClasspathItem {
        protected final String myValue;

        ClasspathItem(String value2) {
            this.myValue = value2;
        }

        public abstract Generator toGenerator();
    }
}

