/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.ExternalCompilerConfigurationStorageKt;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalCompilerConfiguration", storages={@Storage(value="compiler.xml")}, externalStorageOnly=true)
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R:\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/compiler/ExternalCompilerConfigurationStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/roots/ProjectModelElement;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "<set-?>", "", "", "loadedState", "getLoadedState", "()Ljava/util/Map;", "getExternalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "getState", "loadState", "", "state", "intellij.java.compiler.impl"})
public final class ExternalCompilerConfigurationStorage
implements PersistentStateComponent<Element>,
ProjectModelElement {
    @Nullable
    private Map<String, String> loadedState;
    private final Project project;

    @Nullable
    public final Map<String, String> getLoadedState() {
        return this.loadedState;
    }

    @NotNull
    public Element getState() {
        Map<String, String> map2;
        Element result = new Element("state");
        if (!ProjectUtilCore.isExternalStorageEnabled((Project)this.project)) {
            return result;
        }
        CompilerConfiguration compilerConfiguration = CompilerConfigurationImpl.getInstance((Project)this.project);
        if (compilerConfiguration == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.compiler.CompilerConfigurationImpl");
        }
        Map<String, String> map3 = map2 = ((CompilerConfigurationImpl)compilerConfiguration).getModulesBytecodeTargetMap();
        Intrinsics.checkExpressionValueIsNotNull(map3, (String)"map");
        List<String> moduleNames = ExternalCompilerConfigurationStorageKt.getFilteredModuleNameList(this.project, map3, true);
        Collection collection = moduleNames;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Element element = new Element("bytecodeTargetLevel");
            ExternalCompilerConfigurationStorageKt.writeBytecodeTarget(moduleNames, map2, element);
            result.addContent(element);
        }
        return result;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        THashMap result = new THashMap();
        ExternalCompilerConfigurationStorageKt.readByteTargetLevel(state, (Map)result);
        this.loadedState = (Map)result;
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        ExternalProjectSystemRegistry externalProjectSystemRegistry = ExternalProjectSystemRegistry.getInstance();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        for (Module module : moduleManager.getModules()) {
            ProjectModelExternalSource projectModelExternalSource = externalProjectSystemRegistry.getExternalSource(module);
            if (projectModelExternalSource == null) continue;
            ProjectModelExternalSource projectModelExternalSource2 = projectModelExternalSource;
            boolean bl = false;
            boolean bl2 = false;
            ProjectModelExternalSource it = projectModelExternalSource2;
            boolean bl3 = false;
            return it;
        }
        return null;
    }

    public ExternalCompilerConfigurationStorage(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

