/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedImport;

import com.intellij.codeInspection.unusedImport.ImportStatementComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ImportsAreUsedVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiJavaFile myFile;
    private final List<PsiImportStatementBase> importStatements;
    private final List<PsiImportStatementBase> usedImportStatements = new ArrayList<PsiImportStatementBase>();

    ImportsAreUsedVisitor(PsiJavaFile file) {
        this.myFile = file;
        PsiImportList importList = file.getImportList();
        if (importList == null) {
            this.importStatements = Collections.emptyList();
        } else {
            PsiImportStatementBase[] importStatements = importList.getAllImportStatements();
            this.importStatements = new ArrayList<PsiImportStatementBase>(Arrays.asList(importStatements));
            Collections.sort(this.importStatements, ImportStatementComparator.getInstance());
        }
    }

    public void visitImportList(PsiImportList list) {
    }

    public void visitElement(PsiElement element) {
        if (this.importStatements.isEmpty()) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            ImportsAreUsedVisitor.$$$reportNull$$$0(0);
        }
        this.followReferenceToImport(reference);
        super.visitReferenceElement(reference);
    }

    private void followReferenceToImport(PsiJavaCodeReferenceElement reference) {
        JavaResolveResult[] results;
        if (reference.getQualifier() != null) {
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(true);
        PsiElement element = resolveResult.getElement();
        if (element == null && (results = reference.multiResolve(false)).length > 0) {
            element = results[0].getElement();
        }
        if (!(element instanceof PsiMember)) {
            return;
        }
        PsiMember member = (PsiMember)element;
        if (this.findImport(member, this.usedImportStatements) != null) {
            return;
        }
        PsiImportStatementBase foundImport = this.findImport(member, this.importStatements);
        if (foundImport != null) {
            this.importStatements.remove(foundImport);
            this.usedImportStatements.add(foundImport);
        }
    }

    private PsiImportStatementBase findImport(PsiMember member, List<? extends PsiImportStatementBase> importStatements) {
        String packageName;
        String qualifiedName;
        PsiClass containingClass = member.getContainingClass();
        if (member instanceof PsiClass) {
            PsiClass referencedClass = (PsiClass)member;
            qualifiedName = referencedClass.getQualifiedName();
            packageName = qualifiedName != null ? StringUtil.getPackageName((String)qualifiedName) : null;
        } else {
            if (!member.hasModifierProperty("static") || containingClass == null) {
                return null;
            }
            packageName = containingClass.getQualifiedName();
            qualifiedName = packageName + '.' + member.getName();
        }
        if (packageName == null) {
            return null;
        }
        boolean hasOnDemandImportConflict = ImportUtils.hasOnDemandImportConflict(qualifiedName, (PsiElement)this.myFile);
        for (PsiImportStatementBase psiImportStatementBase : importStatements) {
            if (!psiImportStatementBase.isOnDemand()) {
                JavaResolveResult[] targets;
                PsiJavaCodeReferenceElement reference = psiImportStatementBase.getImportReference();
                if (reference == null) continue;
                for (JavaResolveResult target : targets = reference.multiResolve(false)) {
                    if (!member.equals(target.getElement())) continue;
                    return psiImportStatementBase;
                }
                continue;
            }
            if (hasOnDemandImportConflict) continue;
            PsiElement target = psiImportStatementBase.resolve();
            if (target instanceof PsiPackage) {
                PsiPackage aPackage = (PsiPackage)target;
                if (!packageName.equals(aPackage.getQualifiedName())) continue;
                return psiImportStatementBase;
            }
            if (!(target instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)target;
            if (!(psiImportStatementBase instanceof PsiImportStaticStatement ? member.hasModifierProperty("static") && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)containingClass, (boolean)true) : psiImportStatementBase instanceof PsiImportStatement && member instanceof PsiClass && aClass.equals(containingClass))) continue;
            return psiImportStatementBase;
        }
        return null;
    }

    @NotNull
    PsiImportStatementBase[] getUnusedImportStatements() {
        if (this.importStatements.isEmpty()) {
            if (PsiImportStatementBase.EMPTY_ARRAY == null) {
                ImportsAreUsedVisitor.$$$reportNull$$$0(1);
            }
            return PsiImportStatementBase.EMPTY_ARRAY;
        }
        PsiImportStatementBase[] psiImportStatementBaseArray = this.importStatements.toArray(PsiImportStatementBase.EMPTY_ARRAY);
        if (psiImportStatementBaseArray == null) {
            ImportsAreUsedVisitor.$$$reportNull$$$0(2);
        }
        return psiImportStatementBaseArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unusedImport/ImportsAreUsedVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unusedImport/ImportsAreUsedVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedImportStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

