/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddRequiresDirectiveFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Java9ReflectionClassVisibilityInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiJavaModule javaModule;
        PsiFile file;
        if (holder == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(0);
        }
        if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)(file = holder.getFile())) && (javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)file)) != null) {
            JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                    super.visitMethodCallExpression(expression2);
                    if (JavaReflectionReferenceUtil.isCallToMethod(expression2, "java.lang.Class", "forName") || JavaReflectionReferenceUtil.isCallToMethod(expression2, "java.lang.ClassLoader", "loadClass")) {
                        Java9ReflectionClassVisibilityInspection.checkClassVisibility(expression2, holder, javaModule);
                    }
                }
            };
            if (javaElementVisitor == null) {
                Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(1);
            }
            return javaElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    private static void checkClassVisibility(@NotNull PsiMethodCallExpression callExpression, @NotNull ProblemsHolder holder, @NotNull PsiJavaModule javaModule) {
        PsiJavaModule otherModule;
        Project project;
        JavaPsiFacade facade;
        PsiClass psiClass;
        PsiExpression classNameArgument;
        String className2;
        PsiExpression[] arguments;
        if (callExpression == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(4);
        }
        if (javaModule == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(5);
        }
        if ((arguments = callExpression.getArgumentList().getExpressions()).length != 0 && (className2 = JavaReflectionReferenceUtil.computeConstantExpression(classNameArgument = arguments[0], String.class)) != null && (psiClass = (facade = JavaPsiFacade.getInstance((Project)(project = holder.getProject()))).findClass(className2, callExpression.getResolveScope())) != null && (otherModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)psiClass)) != null && otherModule != javaModule) {
            if (!JavaModuleGraphUtil.reads(javaModule, otherModule)) {
                String message2 = InspectionsBundle.message((String)"module.not.in.requirements", (Object[])new Object[]{javaModule.getName(), otherModule.getName()});
                holder.registerProblem((PsiElement)classNameArgument, message2, new LocalQuickFix[]{new AddRequiresDirectiveFix(javaModule, otherModule.getName())});
                return;
            }
            if (otherModule.hasModifierProperty("open")) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiJavaFile.class);
            if (file != null) {
                String packageName = file.getPackageName();
                if (Java9ReflectionClassVisibilityInspection.isPackageAccessible(otherModule.getOpens(), packageName, javaModule)) {
                    return;
                }
                boolean publicApi = Java9ReflectionClassVisibilityInspection.isPublicApi(psiClass);
                if (publicApi && Java9ReflectionClassVisibilityInspection.isPackageAccessible(otherModule.getExports(), packageName, javaModule)) {
                    return;
                }
                String message3 = InspectionsBundle.message((String)(publicApi ? "module.package.not.exported" : "module.package.not.open"), (Object[])new Object[]{otherModule.getName(), packageName, javaModule.getName()});
                holder.registerProblem((PsiElement)classNameArgument, message3, new LocalQuickFix[0]);
            }
        }
    }

    private static boolean isPackageAccessible(@NotNull Iterable<? extends PsiPackageAccessibilityStatement> statements, @NotNull String packageName, @NotNull PsiJavaModule javaModule) {
        if (statements == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(6);
        }
        if (packageName == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(7);
        }
        if (javaModule == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(8);
        }
        for (PsiPackageAccessibilityStatement psiPackageAccessibilityStatement : statements) {
            List moduleNames;
            if (!packageName.equals(psiPackageAccessibilityStatement.getPackageName()) || !(moduleNames = psiPackageAccessibilityStatement.getModuleNames()).isEmpty() && !moduleNames.contains(javaModule.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isPublicApi(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(9);
        }
        if (psiClass.hasModifierProperty("public") || psiClass.hasModifierProperty("protected")) {
            PsiElement parent = psiClass.getParent();
            return parent instanceof PsiJavaFile || parent instanceof PsiClass && Java9ReflectionClassVisibilityInspection.isPublicApi((PsiClass)parent);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkClassVisibility";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPackageAccessible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPublicApi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

