/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;

public class RefJavaFileImpl
extends RefFileImpl {
    private volatile RefModule myRefModule;

    RefJavaFileImpl(PsiFile elem, RefManager manager) {
        super(elem, manager);
    }

    public void buildReferences() {
        PsiPackageStatement packageStatement;
        PsiFile file = this.getPsiElement();
        if (file != null && "package-info.java".equals(file.getName()) && (packageStatement = ((PsiJavaFile)file).getPackageStatement()) != null) {
            packageStatement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    super.visitReferenceElement(reference);
                    this.processReference(reference.resolve());
                }

                public void visitNameValuePair(PsiNameValuePair pair2) {
                    super.visitNameValuePair(pair2);
                    PsiReference reference = pair2.getReference();
                    if (reference != null) {
                        this.processReference(reference.resolve());
                    }
                }

                private void processReference(PsiElement element) {
                    RefElement refElement = RefJavaFileImpl.this.getRefManager().getReference(element);
                    if (refElement instanceof RefJavaElementImpl) {
                        RefJavaFileImpl.this.addOutReference(refElement);
                        ((RefJavaElementImpl)refElement).markReferenced((RefElementImpl)RefJavaFileImpl.this, false, true, null);
                    }
                }
            });
        }
        this.getRefManager().fireBuildReferences((RefElement)this);
    }

    protected void initialize() {
        PsiFile psiFile = this.getPsiElement();
        if (psiFile == null) {
            return;
        }
        this.myRefModule = this.getRefManager().getRefModule(ModuleUtilCore.findModuleForFile((PsiFile)psiFile));
        UFile file = (UFile)ObjectUtils.notNull((Object)UastContextKt.toUElement((PsiElement)psiFile, UFile.class));
        String packageName = file.getPackageName();
        if (!packageName.isEmpty()) {
            ((RefPackageImpl)((RefJavaManager)this.getRefManager().getExtension(RefJavaManager.MANAGER)).getPackage(packageName)).add((RefEntity)this);
        } else if (this.myRefModule != null) {
            ((WritableRefEntity)this.myRefModule).add((RefEntity)this);
        } else {
            ((RefProjectImpl)this.getRefManager().getRefProject()).add((RefEntity)this);
        }
    }

    public RefModule getModule() {
        return this.myRefModule;
    }
}

