/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.AddJavadocIntention;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.javaDoc.JavadocHighlightUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocLocalInspection
extends LocalInspectionTool {
    public static final String SHORT_NAME = "JavaDoc";
    protected static final String NONE = "none";
    protected static final String PACKAGE_LOCAL = "package";
    protected static final String PUBLIC = "public";
    protected static final String PROTECTED = "protected";
    protected static final String PRIVATE = "private";
    private static final String IGNORE_ACCESSORS_ATTR_NAME = "IGNORE_ACCESSORS";
    private static final String IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME = "IGNORE_DUPLICATED_THROWS_TAGS";
    private static final String MODULE_OPTIONS_TAG_NAME = "MODULE_OPTIONS";
    protected final Options PACKAGE_OPTIONS = new Options("none", "");
    protected final Options MODULE_OPTIONS = new Options("none", "");
    public Options TOP_LEVEL_CLASS_OPTIONS = new Options("none", "");
    public Options INNER_CLASS_OPTIONS = new Options("none", "");
    public Options METHOD_OPTIONS = new Options("none", "@return@param@throws or @exception");
    public Options FIELD_OPTIONS = new Options("none", "");
    public boolean IGNORE_DEPRECATED;
    public boolean IGNORE_JAVADOC_PERIOD = true;
    @Deprecated
    public boolean IGNORE_DUPLICATED_THROWS;
    public boolean IGNORE_POINT_TO_ITSELF;
    public String myAdditionalJavadocTags = "";
    private boolean myIgnoreDuplicatedThrows = true;
    private boolean myIgnoreEmptyDescriptions;
    private boolean myIgnoreSimpleAccessors;

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    protected LocalQuickFix createAddJavadocFix(@NotNull PsiElement nameIdentifier, boolean isOnTheFly) {
        if (nameIdentifier == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(0);
        }
        return isOnTheFly ? new AddJavadocFix(nameIdentifier) : null;
    }

    protected LocalQuickFix createAddMissingTagFix(@NotNull String tag, @NotNull String value2, boolean isOnTheFly) {
        if (tag == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(2);
        }
        return new AddMissingTagFix(tag, value2);
    }

    protected LocalQuickFix createAddMissingParamTagFix(@NotNull String name2, boolean isOnTheFly) {
        if (name2 == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(3);
        }
        return new AddMissingParamTagFix(name2);
    }

    protected LocalQuickFix createRegisterTagFix(@NotNull String tag, boolean isOnTheFly) {
        if (tag == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(4);
        }
        return new AddUnknownTagToCustoms(this, tag);
    }

    public void setPackageOption(String modifier, String tags) {
        this.PACKAGE_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = modifier;
        this.PACKAGE_OPTIONS.REQUIRED_TAGS = tags;
    }

    public void registerAdditionalTag(@NotNull String tag) {
        if (tag == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(5);
        }
        this.myAdditionalJavadocTags = !this.myAdditionalJavadocTags.isEmpty() ? this.myAdditionalJavadocTags + "," + tag : tag;
    }

    public boolean isIgnoreDuplicatedThrows() {
        return this.myIgnoreDuplicatedThrows;
    }

    public void setIgnoreDuplicatedThrows(boolean ignoreDuplicatedThrows) {
        this.myIgnoreDuplicatedThrows = ignoreDuplicatedThrows;
    }

    public void setIgnoreEmptyDescriptions(boolean ignoreEmptyDescriptions) {
        this.myIgnoreEmptyDescriptions = ignoreEmptyDescriptions;
    }

    public boolean isIgnoreSimpleAccessors() {
        return this.myIgnoreSimpleAccessors;
    }

    public void setIgnoreSimpleAccessors(boolean ignoreSimpleAccessors) {
        this.myIgnoreSimpleAccessors = ignoreSimpleAccessors;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(6);
        }
        super.writeSettings(node);
        if (this.myIgnoreSimpleAccessors) {
            JDOMExternalizerUtil.writeCustomField((Element)node, (String)IGNORE_ACCESSORS_ATTR_NAME, (String)String.valueOf(true));
        }
        if (!this.myIgnoreDuplicatedThrows) {
            JDOMExternalizerUtil.writeCustomField((Element)node, (String)IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME, (String)String.valueOf(false));
        }
        if (this.MODULE_OPTIONS.isModified()) {
            this.MODULE_OPTIONS.writeExternal(JDOMExternalizerUtil.writeOption((Element)node, (String)MODULE_OPTIONS_TAG_NAME));
        }
        if (this.PACKAGE_OPTIONS.isModified()) {
            this.PACKAGE_OPTIONS.writeExternal(node);
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        Element moduleOptions;
        String ignoreDuplicatedThrows;
        if (node == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(7);
        }
        super.readSettings(node);
        String ignoreAccessors = JDOMExternalizerUtil.readCustomField((Element)node, (String)IGNORE_ACCESSORS_ATTR_NAME);
        if (ignoreAccessors != null) {
            this.myIgnoreSimpleAccessors = Boolean.parseBoolean(ignoreAccessors);
        }
        if ((ignoreDuplicatedThrows = JDOMExternalizerUtil.readCustomField((Element)node, (String)IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME)) != null) {
            this.myIgnoreDuplicatedThrows = Boolean.parseBoolean(ignoreDuplicatedThrows);
        }
        if ((moduleOptions = JDOMExternalizerUtil.readOption((Element)node, (String)MODULE_OPTIONS_TAG_NAME)) != null) {
            this.MODULE_OPTIONS.readExternal(moduleOptions);
        }
        this.PACKAGE_OPTIONS.readExternal(node);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(8);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitJavaFile(PsiJavaFile file) {
                if ("package-info.java".equals(file.getName())) {
                    JavaDocLocalInspection.this.checkFile(file, holder, isOnTheFly);
                }
            }

            public void visitModule(PsiJavaModule module) {
                JavaDocLocalInspection.this.checkModule(module, holder, isOnTheFly);
            }

            public void visitClass(PsiClass aClass) {
                JavaDocLocalInspection.this.checkClass(aClass, holder, isOnTheFly);
            }

            public void visitField(PsiField field) {
                JavaDocLocalInspection.this.checkField(field, holder, isOnTheFly);
            }

            public void visitMethod(PsiMethod method) {
                JavaDocLocalInspection.this.checkMethod(method, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(9);
        }
        return javaElementVisitor;
    }

    private void checkFile(PsiJavaFile file, ProblemsHolder delegate, boolean isOnTheFly) {
        PsiPackage pkg = JavaDirectoryService.getInstance().getPackage(file.getContainingDirectory());
        if (pkg == null) {
            return;
        }
        PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getChildOfType((PsiElement)file, PsiDocComment.class);
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspection.isDeprecated((PsiModifierListOwner)pkg, docComment)) {
            return;
        }
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, (PsiModifierListOwner)pkg);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            PsiDocTag[] tags = docComment.getTags();
            this.checkBasics(docComment, tags, (PsiElement)pkg, required, this.PACKAGE_OPTIONS, holder);
        } else if (required) {
            PsiElement toHighlight = (PsiElement)ObjectUtils.notNull((Object)file.getPackageStatement(), (Object)file);
            JavadocHighlightUtil.reportMissingTag(toHighlight, holder);
        }
    }

    private void checkModule(PsiJavaModule module, ProblemsHolder delegate, boolean isOnTheFly) {
        PsiDocComment docComment = module.getDocComment();
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspection.isDeprecated((PsiModifierListOwner)module, docComment)) {
            return;
        }
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, (PsiModifierListOwner)module);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            this.checkBasics(docComment, docComment.getTags(), (PsiElement)module, required, this.MODULE_OPTIONS, holder);
        } else if (required) {
            JavadocHighlightUtil.reportMissingTag((PsiElement)module.getNameIdentifier(), holder);
        }
    }

    private void checkClass(PsiClass aClass, ProblemsHolder delegate, boolean isOnTheFly) {
        if (aClass instanceof PsiAnonymousClass || aClass instanceof PsiSyntheticClass || aClass instanceof PsiTypeParameter) {
            return;
        }
        if (this.IGNORE_DEPRECATED && aClass.isDeprecated()) {
            return;
        }
        PsiDocComment docComment = aClass.getDocComment();
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, (PsiModifierListOwner)aClass);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            PsiDocTag[] tags = docComment.getTags();
            Options options = ClassUtil.isTopLevelClass((PsiClass)aClass) ? this.TOP_LEVEL_CLASS_OPTIONS : this.INNER_CLASS_OPTIONS;
            this.checkBasics(docComment, tags, (PsiElement)aClass, required, options, holder);
            if (required && JavaDocLocalInspection.isTagRequired(options, "param")) {
                JavadocHighlightUtil.checkMissingTypeParamTags((PsiTypeParameterListOwner)aClass, tags, docComment.getFirstChild(), holder);
            }
        } else if (required) {
            PsiElement toHighlight = (PsiElement)ObjectUtils.notNull((Object)aClass.getNameIdentifier(), (Object)aClass);
            JavadocHighlightUtil.reportMissingTag(toHighlight, holder);
        }
    }

    private void checkField(PsiField field, ProblemsHolder delegate, boolean isOnTheFly) {
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspection.isDeprecated((PsiDocCommentOwner)field)) {
            return;
        }
        PsiDocComment docComment = field.getDocComment();
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, (PsiModifierListOwner)field);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            this.checkBasics(docComment, docComment.getTags(), (PsiElement)field, required, this.FIELD_OPTIONS, holder);
        } else if (required) {
            JavadocHighlightUtil.reportMissingTag((PsiElement)field.getNameIdentifier(), holder);
        }
    }

    private void checkMethod(PsiMethod method, ProblemsHolder delegate, boolean isOnTheFly) {
        ExtensionPoint ep;
        PsiIdentifier nameIdentifier;
        if (method instanceof SyntheticElement) {
            return;
        }
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspection.isDeprecated((PsiDocCommentOwner)method)) {
            return;
        }
        if (this.myIgnoreSimpleAccessors && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method)) {
            return;
        }
        PsiDocComment docComment = method.getDocComment();
        boolean hasSupers = method.findSuperMethods().length > 0;
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, (PsiModifierListOwner)method);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            if (!JavaDocLocalInspection.isInherited(docComment, method)) {
                PsiDocTag[] tags = docComment.getTags();
                if (required && !hasSupers) {
                    if (JavaDocLocalInspection.isTagRequired(this.METHOD_OPTIONS, "return")) {
                        JavadocHighlightUtil.checkMissingReturnTag(tags, method, docComment.getFirstChild(), holder);
                    }
                    if (JavaDocLocalInspection.isTagRequired(this.METHOD_OPTIONS, "param")) {
                        JavadocHighlightUtil.checkMissingParamTags(tags, method, docComment.getFirstChild(), holder);
                        JavadocHighlightUtil.checkMissingTypeParamTags((PsiTypeParameterListOwner)method, tags, docComment.getFirstChild(), holder);
                    }
                    if (JavaDocLocalInspection.isTagRequired(this.METHOD_OPTIONS, "throws")) {
                        JavadocHighlightUtil.checkMissingThrowsTags(tags, method, docComment.getFirstChild(), holder);
                    }
                }
                if (!this.myIgnoreEmptyDescriptions) {
                    JavadocHighlightUtil.checkEmptyMethodTagsDescription(tags, holder);
                }
                this.checkBasics(docComment, tags, (PsiElement)method, false, this.METHOD_OPTIONS, holder);
            }
        } else if (required && !hasSupers && (nameIdentifier = method.getNameIdentifier()) != null && Stream.of((ep = Extensions.getRootArea().getExtensionPoint("com.intellij.javaDocNotNecessary")).getExtensions()).noneMatch(condition2 -> condition2.value((Object)method))) {
            JavadocHighlightUtil.reportMissingTag((PsiElement)nameIdentifier, holder);
        }
    }

    private void checkBasics(PsiDocComment docComment, PsiDocTag[] tags, PsiElement context, boolean required, Options options, ProblemHolderImpl holder) {
        if (required) {
            JavadocHighlightUtil.checkRequiredTags(tags, options, docComment.getFirstChild(), holder);
        }
        JavadocHighlightUtil.checkRequiredTagDescriptions(tags, holder);
        JavadocHighlightUtil.checkTagValues(tags, context, holder);
        if (!this.IGNORE_JAVADOC_PERIOD) {
            JavadocHighlightUtil.checkForPeriod(docComment, context, holder);
        }
        JavadocHighlightUtil.checkInlineTags(docComment.getDescriptionElements(), holder);
        JavadocHighlightUtil.checkForBadCharacters(docComment, holder);
        JavadocHighlightUtil.checkDuplicateTags(tags, holder);
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.javadoc.display.name", (Object[])new Object[0]);
        if (string == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.javadoc.issues", (Object[])new Object[0]);
        if (string == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(12);
        }
        return SHORT_NAME;
    }

    @Nullable
    public String getAlternativeID() {
        return "javadoc";
    }

    private static boolean isDeprecated(PsiModifierListOwner element, PsiDocComment docComment) {
        return PsiImplUtil.isDeprecatedByAnnotation(element) || docComment != null && docComment.findTagByName("deprecated") != null;
    }

    protected static boolean isTagRequired(Options options, String tag) {
        return options.REQUIRED_TAGS.contains(tag);
    }

    private static boolean isDeprecated(PsiDocCommentOwner element) {
        return element.isDeprecated() || element.getContainingClass() != null && element.getContainingClass().isDeprecated();
    }

    private static boolean isInherited(PsiDocComment docComment, PsiMethod psiMethod) {
        JavadocTagInfo tagInfo;
        for (PsiElement descriptionElement : docComment.getDescriptionElements()) {
            if (!(descriptionElement instanceof PsiInlineDocTag) || !"inheritDoc".equals(((PsiInlineDocTag)descriptionElement).getName())) continue;
            return true;
        }
        return docComment.findTagByName("inheritDoc") != null && (tagInfo = JavadocManager.SERVICE.getInstance((Project)psiMethod.getProject()).getTagInfo("inheritDoc")) != null && tagInfo.isValidInContext((PsiElement)psiMethod);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAddJavadocFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAddMissingTagFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAddMissingParamTagFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRegisterTagFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalTag";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProblemHolderImpl
    implements JavadocHighlightUtil.ProblemHolder {
        private final ProblemsHolder myHolder;
        private final boolean myOnTheFly;

        private ProblemHolderImpl(ProblemsHolder holder, boolean onTheFly) {
            this.myHolder = holder;
            this.myOnTheFly = onTheFly;
        }

        @Override
        public Project project() {
            return this.myHolder.getManager().getProject();
        }

        @Override
        public JavaDocLocalInspection inspection() {
            return JavaDocLocalInspection.this;
        }

        @Override
        public void problem(@NotNull PsiElement toHighlight, @NotNull @Nls String message2, @Nullable LocalQuickFix fix2) {
            if (toHighlight == null) {
                ProblemHolderImpl.$$$reportNull$$$0(0);
            }
            if (message2 == null) {
                ProblemHolderImpl.$$$reportNull$$$0(1);
            }
            this.myHolder.registerProblem(this.myHolder.getManager().createProblemDescriptor(toHighlight, message2, fix2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly));
        }

        @Override
        public void eolProblem(@NotNull PsiElement toHighlight, @NotNull @Nls String message2, @Nullable LocalQuickFix fix2) {
            LocalQuickFix[] localQuickFixArray;
            if (toHighlight == null) {
                ProblemHolderImpl.$$$reportNull$$$0(2);
            }
            if (message2 == null) {
                ProblemHolderImpl.$$$reportNull$$$0(3);
            }
            if (fix2 != null) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = fix2;
            } else {
                localQuickFixArray = null;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.myHolder.registerProblem(this.myHolder.getManager().createProblemDescriptor(toHighlight, message2, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, true));
        }

        @Override
        public LocalQuickFix addJavadocFix(@NotNull PsiElement nameIdentifier) {
            if (nameIdentifier == null) {
                ProblemHolderImpl.$$$reportNull$$$0(4);
            }
            return JavaDocLocalInspection.this.createAddJavadocFix(nameIdentifier, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix addMissingTagFix(@NotNull String tag, @NotNull String value2) {
            if (tag == null) {
                ProblemHolderImpl.$$$reportNull$$$0(5);
            }
            if (value2 == null) {
                ProblemHolderImpl.$$$reportNull$$$0(6);
            }
            return JavaDocLocalInspection.this.createAddMissingTagFix(tag, value2, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix addMissingParamTagFix(@NotNull String name2) {
            if (name2 == null) {
                ProblemHolderImpl.$$$reportNull$$$0(7);
            }
            return JavaDocLocalInspection.this.createAddMissingParamTagFix(name2, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix registerTagFix(@NotNull String tag) {
            if (tag == null) {
                ProblemHolderImpl.$$$reportNull$$$0(8);
            }
            return JavaDocLocalInspection.this.createRegisterTagFix(tag, this.myOnTheFly);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toHighlight";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIdentifier";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$ProblemHolderImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problem";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "eolProblem";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addJavadocFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMissingTagFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMissingParamTagFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerTagFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddUnknownTagToCustoms
    implements LocalQuickFix {
        private final JavaDocLocalInspection myInspection;
        private final String myTag;

        AddUnknownTagToCustoms(@NotNull JavaDocLocalInspection inspection, @NotNull String tag) {
            if (inspection == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(0);
            }
            if (tag == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(1);
            }
            this.myInspection = inspection;
            this.myTag = tag;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(3);
            }
            this.myInspection.registerAdditionalTag(this.myTag);
            ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
        }

        @NotNull
        public String getName() {
            String string = QuickFixBundle.message("add.docTag.to.custom.tags", this.myTag);
            if (string == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("fix.javadoc.family", new Object[0]);
            if (string == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddMissingParamTagFix
    extends AddMissingTagFix {
        private final String myName;

        AddMissingParamTagFix(String name2) {
            super("param", name2);
            this.myName = name2;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.param.tag.family", (Object[])new Object[0]);
            if (string == null) {
                AddMissingParamTagFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element == null ? null : element.getParent();
            if (!(parent instanceof PsiDocComment)) {
                return null;
            }
            PsiDocComment docComment = (PsiDocComment)parent;
            PsiJavaDocumentedElement owner2 = docComment.getOwner();
            if (!(owner2 instanceof PsiMethod)) {
                return null;
            }
            Object[] parameters2 = ((PsiMethod)owner2).getParameterList().getParameters();
            PsiParameter myParam = (PsiParameter)ContainerUtil.find((Object[])parameters2, psiParameter -> this.myName.equals(psiParameter.getName()));
            if (myParam == null) {
                return null;
            }
            PsiDocTag[] tags = docComment.findTagsByName("param");
            if (tags.length == 0) {
                tags = docComment.getTags();
                if (tags.length == 0) {
                    return null;
                }
                return tags[0];
            }
            PsiParameter nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (nextParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(nextParam, tag)) continue;
                    return tag;
                }
                nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextParam, PsiParameter.class);
            }
            PsiParameter prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (prevParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(prevParam, tag)) continue;
                    return PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, PsiDocTag.class);
                }
                prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevParam, PsiParameter.class);
            }
            return null;
        }

        private static boolean matches(PsiParameter param, PsiDocTag tag) {
            PsiDocTagValue valueElement = tag.getValueElement();
            String name2 = param.getName();
            return valueElement != null && name2 != null && valueElement.getText().trim().startsWith(name2);
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.param.tag", (Object[])new Object[]{this.myName});
            if (string == null) {
                AddMissingParamTagFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingParamTagFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class AddMissingTagFix
    implements LocalQuickFix {
        private final String myTag;
        private final String myValue;

        AddMissingTagFix(@NotNull String tag, @NotNull String value2) {
            if (tag == null) {
                AddMissingTagFix.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                AddMissingTagFix.$$$reportNull$$$0(1);
            }
            this.myTag = tag;
            this.myValue = value2;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiDocComment docComment;
            if (project == null) {
                AddMissingTagFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddMissingTagFix.$$$reportNull$$$0(3);
            }
            if ((docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getEndElement(), PsiDocComment.class)) != null) {
                PsiDocTag tag = JavaPsiFacade.getElementFactory((Project)project).createDocTagFromText("@" + this.myTag + " " + this.myValue);
                PsiElement anchor = this.getAnchor(descriptor);
                PsiElement addedTag = anchor != null ? docComment.addBefore((PsiElement)tag, anchor) : docComment.add((PsiElement)tag);
                AddMissingTagFix.moveCaretAfter(addedTag);
            }
        }

        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            return null;
        }

        private static void moveCaretAfter(PsiElement newCaretPosition) {
            PsiElement sibling = newCaretPosition.getNextSibling();
            if (sibling != null) {
                ((Navigatable)sibling).navigate(true);
            }
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag", (Object[])new Object[]{this.myTag, this.myValue});
            if (string == null) {
                AddMissingTagFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag.family", (Object[])new Object[0]);
            if (string == null) {
                AddMissingTagFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddJavadocFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final AddJavadocIntention myIntention = new AddJavadocIntention();

        AddJavadocFix(PsiElement nameIdentifier) {
            super(nameIdentifier);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                AddJavadocFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                AddJavadocFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                AddJavadocFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                AddJavadocFix.$$$reportNull$$$0(3);
            }
            this.myIntention.invoke(project, editor, startElement);
        }

        @NotNull
        public String getText() {
            String string = this.myIntention.getText();
            if (string == null) {
                AddJavadocFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.myIntention.getFamilyName();
            if (string == null) {
                AddJavadocFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddJavadocFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddJavadocFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class OptionsPanel
    extends JPanel {
        OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.emptyInsets(), 0, 0);
            String title = InspectionsBundle.message((String)"inspection.javadoc.dialog.title", (Object[])new Object[0]);
            FieldPanel additionalTagsPanel = new FieldPanel(InspectionsBundle.message((String)"inspection.javadoc.label.text", (Object[])new Object[0]), title, null, null);
            additionalTagsPanel.setPreferredSize(new Dimension(150, additionalTagsPanel.getPreferredSize().height));
            additionalTagsPanel.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Document document = e.getDocument();
                    try {
                        String text2 = document.getText(0, document.getLength());
                        if (text2 != null) {
                            JavaDocLocalInspection.this.myAdditionalJavadocTags = text2.trim();
                        }
                    }
                    catch (BadLocationException ex) {
                        Logger.getInstance(JavaDocLocalInspection.class).error((Throwable)ex);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$OptionsPanel$1", "textChanged"));
                }
            });
            additionalTagsPanel.setText(JavaDocLocalInspection.this.myAdditionalJavadocTags);
            this.add((Component)additionalTagsPanel, gc);
            JBTabbedPane tabs = new JBTabbedPane(3, 1);
            String[] tags = new String[]{"@author", "@version", "@since"};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.package", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC}, tags, JavaDocLocalInspection.this.PACKAGE_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.module", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC}, tags, JavaDocLocalInspection.this.MODULE_OPTIONS));
            tags = new String[]{"@author", "@version", "@since", "@param"};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PACKAGE_LOCAL}, tags, JavaDocLocalInspection.this.TOP_LEVEL_CLASS_OPTIONS));
            tags = new String[]{"@return", "@param", InspectionsBundle.message((String)"inspection.javadoc.throws.or.exception.option", (Object[])new Object[0])};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.method", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PROTECTED, JavaDocLocalInspection.PACKAGE_LOCAL, JavaDocLocalInspection.PRIVATE}, tags, JavaDocLocalInspection.this.METHOD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.field", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PROTECTED, JavaDocLocalInspection.PACKAGE_LOCAL, JavaDocLocalInspection.PRIVATE}, null, JavaDocLocalInspection.this.FIELD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.inner.class", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PROTECTED, JavaDocLocalInspection.PACKAGE_LOCAL, JavaDocLocalInspection.PRIVATE}, null, JavaDocLocalInspection.this.INNER_CLASS_OPTIONS));
            this.add((Component)tabs, gc);
            JCheckBox checkBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.deprecated", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_DEPRECATED);
            checkBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_DEPRECATED = checkBox.isSelected();
            });
            gc.gridwidth = 1;
            this.add((Component)checkBox, gc);
            JCheckBox periodCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.period", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD);
            periodCheckBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD = periodCheckBox.isSelected();
            });
            this.add((Component)periodCheckBox, gc);
            JCheckBox ignoreDuplicateThrowsCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.throws", (Object[])new Object[0]), JavaDocLocalInspection.this.isIgnoreDuplicatedThrows());
            ignoreDuplicateThrowsCheckBox.addActionListener(e -> JavaDocLocalInspection.this.setIgnoreDuplicatedThrows(ignoreDuplicateThrowsCheckBox.isSelected()));
            this.add((Component)ignoreDuplicateThrowsCheckBox, gc);
            JCheckBox ignorePointToItselfCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.self.ref", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF);
            ignorePointToItselfCheckBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF = ignorePointToItselfCheckBox.isSelected();
            });
            this.add((Component)ignorePointToItselfCheckBox, gc);
            JCheckBox ignoreSimpleAccessorsCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.simple", (Object[])new Object[0]), JavaDocLocalInspection.this.isIgnoreSimpleAccessors());
            ignoreSimpleAccessorsCheckBox.addActionListener(e -> JavaDocLocalInspection.this.setIgnoreSimpleAccessors(ignoreSimpleAccessorsCheckBox.isSelected()));
            this.add((Component)ignoreSimpleAccessorsCheckBox, gc);
        }

        private JPanel createOptionsPanel(String[] modifiers, String[] tags, Options options) {
            JPanel pane = new JPanel(new GridLayout(1, tags == null ? 1 : 2));
            pane.add(this.createScopePanel(modifiers, options));
            if (tags != null) {
                pane.add(this.createTagsPanel(tags, options));
            }
            pane.validate();
            return pane;
        }

        private JPanel createScopePanel(String[] modifiers, Options options) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.scope.for.title", (Object[])new Object[0])), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            for (int i = 0; i < modifiers.length; ++i) {
                sliderLabels.put(i + 1, new JLabel(modifiers[i]));
            }
            JSlider slider = new JSlider(1, 1, modifiers.length, 1);
            slider.setLabelTable(sliderLabels);
            slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            slider.setPreferredSize((Dimension)JBUI.size((int)80, (int)50));
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            slider.addChangeListener(e -> {
                int value2 = slider.getValue();
                options.ACCESS_JAVADOC_REQUIRED_FOR = modifiers[value2 - 1];
                for (Integer key2 : sliderLabels.keySet()) {
                    ((JComponent)sliderLabels.get(key2)).setForeground((Color)(key2 <= value2 ? JBColor.BLACK : Gray._100));
                }
            });
            JBColor fore = JBColor.BLACK;
            for (int i = 0; i < modifiers.length; ++i) {
                ((JComponent)sliderLabels.get(i + 1)).setForeground((Color)fore);
                if (!modifiers[i].equals(options.ACCESS_JAVADOC_REQUIRED_FOR)) continue;
                slider.setValue(i + 1);
                fore = Gray._100;
            }
            panel.add((Component)slider, "West");
            return panel;
        }

        private JPanel createTagsPanel(String[] tags, Options options) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.javadoc.required.tags.option.title", (Object[])new Object[0])), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            GridBagConstraints gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 18;
            for (int i = 0; i < tags.length; ++i) {
                JCheckBox box = new JCheckBox(tags[i]);
                gc.gridy = i;
                if (i == tags.length - 1) {
                    gc.weighty = 1.0;
                }
                panel.add((Component)box, gc);
                box.setSelected(JavaDocLocalInspection.isTagRequired(options, tags[i]));
                box.addChangeListener(new MyChangeListener(box, options, tags[i]));
            }
            return panel;
        }

        private class MyChangeListener
        implements ChangeListener {
            private final JCheckBox myCheckBox;
            private final Options myOptions;
            private final String myTagName;

            MyChangeListener(JCheckBox checkBox, Options options, String tagName) {
                this.myCheckBox = checkBox;
                this.myOptions = options;
                this.myTagName = tagName;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.myCheckBox.isSelected()) {
                    if (!JavaDocLocalInspection.isTagRequired(this.myOptions, this.myTagName)) {
                        this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS + this.myTagName;
                    }
                } else {
                    this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS.replaceAll(this.myTagName, "");
                }
            }
        }
    }

    public static class Options
    implements JDOMExternalizable {
        public String ACCESS_JAVADOC_REQUIRED_FOR = "none";
        public String REQUIRED_TAGS = "";

        public Options() {
        }

        public Options(String accessJavadocRequiredFor, String requiredTags) {
            this.ACCESS_JAVADOC_REQUIRED_FOR = accessJavadocRequiredFor;
            this.REQUIRED_TAGS = requiredTags;
        }

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }

        private boolean isModified() {
            return !this.ACCESS_JAVADOC_REQUIRED_FOR.equals(JavaDocLocalInspection.NONE) || !this.REQUIRED_TAGS.isEmpty();
        }
    }
}

