/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateExpressions;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SideEffectCalculator {
    private final ObjectIntHashMap<PsiExpression> myCache = new ObjectIntHashMap();
    private static final Set<String> SIDE_EFFECTS_FREE_CLASSES = ContainerUtil.set((Object[])new String[]{"java.lang.Boolean", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Byte", "java.lang.String", "java.math.BigDecimal", "java.math.BigInteger", "java.math.MathContext", "java.util.UUID", "java.util.Objects"});

    SideEffectCalculator() {
    }

    @Contract(value="null -> false")
    boolean mayHaveSideEffect(@Nullable PsiExpression expression2) {
        if (expression2 == null || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiClassObjectAccessExpression) {
            return false;
        }
        int c = this.myCache.get((Object)expression2);
        if (c < 0) {
            c = this.calculateSideEffect(expression2) ? 1 : 0;
            this.myCache.put((Object)expression2, c);
        }
        return c == 1;
    }

    boolean calculateSideEffect(@Nullable PsiExpression e) {
        if (e instanceof PsiParenthesizedExpression) {
            return this.mayHaveSideEffect(((PsiParenthesizedExpression)e).getExpression());
        }
        if (e instanceof PsiUnaryExpression) {
            return PsiUtil.isIncrementDecrementOperation((PsiElement)e) || this.mayHaveSideEffect(((PsiUnaryExpression)e).getOperand());
        }
        if (e instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)e;
            return Arrays.stream(polyadic.getOperands()).anyMatch(this::mayHaveSideEffect);
        }
        if (e instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)e;
            return this.mayHaveSideEffect(conditional.getCondition()) || this.mayHaveSideEffect(conditional.getThenExpression()) || this.mayHaveSideEffect(conditional.getElseExpression());
        }
        if (e instanceof PsiMethodCallExpression) {
            return this.calculateCallSideEffect((PsiMethodCallExpression)e);
        }
        if (e instanceof PsiReferenceExpression) {
            return this.calculateReferenceSideEffect((PsiReferenceExpression)e);
        }
        if (e instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)e;
            return this.mayHaveSideEffect(instanceOf.getOperand());
        }
        if (e instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression access = (PsiArrayAccessExpression)e;
            PsiExpression array = access.getArrayExpression();
            return this.mayHaveSideEffect(array) || this.mayHaveSideEffect(access.getIndexExpression()) || !Boolean.TRUE.equals(CommonDataflow.getExpressionFact(array, DfaFactType.LOCALITY));
        }
        if (e instanceof PsiLambdaExpression) {
            return false;
        }
        if (e instanceof PsiNewExpression) {
            return this.calculateNewSideEffect((PsiNewExpression)e);
        }
        return true;
    }

    private boolean calculateReferenceSideEffect(@NotNull PsiReferenceExpression ref) {
        if (ref == null) {
            SideEffectCalculator.$$$reportNull$$$0(0);
        }
        if (this.mayHaveSideEffect(ref.getQualifierExpression())) {
            return true;
        }
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter || resolved instanceof PsiClass) {
            return false;
        }
        if (resolved instanceof PsiField) {
            PsiField field = (PsiField)resolved;
            return !field.hasModifierProperty("final");
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            return SideEffectCalculator.methodMayHaveSideEffect(method);
        }
        return true;
    }

    private boolean calculateCallSideEffect(@NotNull PsiMethodCallExpression call) {
        PsiMethod method;
        if (call == null) {
            SideEffectCalculator.$$$reportNull$$$0(1);
        }
        return SideEffectCalculator.methodMayHaveSideEffect(method = call.resolveMethod()) || this.calculateSideEffect((PsiCallExpression)call, call.getMethodExpression().getQualifierExpression());
    }

    private boolean calculateNewSideEffect(@NotNull PsiNewExpression newExpr) {
        PsiElement resolved;
        if (newExpr == null) {
            SideEffectCalculator.$$$reportNull$$$0(2);
        }
        if (newExpr.getAnonymousClass() != null || this.mayHaveSideEffect((PsiExpression)newExpr.getArrayInitializer())) {
            return true;
        }
        PsiJavaCodeReferenceElement ref = newExpr.getClassReference();
        if (ref != null && (resolved = ref.resolve()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)resolved;
            return !ClassUtils.isImmutableClass(psiClass) || this.calculateSideEffect((PsiCallExpression)newExpr, newExpr.getQualifier());
        }
        return true;
    }

    private boolean calculateSideEffect(@NotNull PsiCallExpression call, @Nullable PsiExpression qualifier) {
        PsiExpressionList argumentList;
        if (call == null) {
            SideEffectCalculator.$$$reportNull$$$0(3);
        }
        if ((argumentList = call.getArgumentList()) != null) {
            for (PsiExpression argument : argumentList.getExpressions()) {
                if (!this.mayHaveSideEffect(argument)) continue;
                return true;
            }
        }
        return this.mayHaveSideEffect(qualifier);
    }

    @Contract(value="null -> true")
    private static boolean methodMayHaveSideEffect(@Nullable PsiMethod method) {
        if (method == null) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return true;
        }
        String className2 = psiClass.getQualifiedName();
        if (className2 == null) {
            return true;
        }
        if (MethodUtils.isEquals(method) || MethodUtils.isHashCode(method) || MethodUtils.isToString(method) || MethodUtils.isCompareTo(method) || MethodUtils.isComparatorCompare(method) || SIDE_EFFECTS_FREE_CLASSES.contains(className2)) {
            return false;
        }
        if ("java.lang.Math".equals(className2) || "java.lang.StrictMath".equals(className2)) {
            return "random".equals(method.getName());
        }
        if ("java.util.Collections".equals(className2)) {
            String name2 = method.getName();
            return !name2.equals("min") && !name2.equals("max") && !name2.startsWith("unmodifiable");
        }
        return true;
    }

    static boolean isDefinitelyWithSideEffect(@Nullable PsiExpression expression2) {
        return expression2 instanceof PsiAssignmentExpression || PsiUtil.isIncrementDecrementOperation((PsiElement)expression2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/duplicateExpressions/SideEffectCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateReferenceSideEffect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateCallSideEffect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateNewSideEffect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateSideEffect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

