/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateExpressions;

import com.intellij.codeInspection.duplicateExpressions.ComplexityCalculator;
import com.intellij.codeInspection.duplicateExpressions.ExpressionHashingStrategy;
import com.intellij.codeInspection.duplicateExpressions.SideEffectCalculator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DuplicateExpressionsContext {
    private static final Key<Map<PsiCodeBlock, DuplicateExpressionsContext>> CONTEXTS_KEY = Key.create((String)"DuplicateExpressionsContext");
    private final Map<PsiExpression, List<PsiExpression>> myOccurrences = new THashMap((TObjectHashingStrategy)new ExpressionHashingStrategy());
    private final ComplexityCalculator myComplexityCalculator = new ComplexityCalculator();
    private final SideEffectCalculator mySideEffectCalculator = new SideEffectCalculator();

    DuplicateExpressionsContext() {
    }

    void addOccurrence(PsiExpression expression2) {
        List list = this.myOccurrences.computeIfAbsent(expression2, unused -> new ArrayList());
        list.add(expression2);
    }

    void forEach(BiConsumer<? super PsiExpression, ? super List<PsiExpression>> consumer) {
        this.myOccurrences.forEach(consumer);
    }

    int getComplexity(PsiExpression expression2) {
        return this.myComplexityCalculator.getComplexity(expression2);
    }

    boolean mayHaveSideEffect(PsiExpression expression2) {
        return this.mySideEffectCalculator.mayHaveSideEffect(expression2);
    }

    @Nullable
    static DuplicateExpressionsContext getOrCreateContext(@NotNull PsiExpression expression2, @NotNull UserDataHolder session) {
        PsiCodeBlock nearestBody;
        if (expression2 == null) {
            DuplicateExpressionsContext.$$$reportNull$$$0(0);
        }
        if (session == null) {
            DuplicateExpressionsContext.$$$reportNull$$$0(1);
        }
        if ((nearestBody = DuplicateExpressionsContext.findNearestBody(expression2)) != null) {
            Map contexts = (Map)session.getUserData(CONTEXTS_KEY);
            if (contexts == null) {
                contexts = new THashMap();
                session.putUserData(CONTEXTS_KEY, (Object)contexts);
            }
            return contexts.computeIfAbsent(nearestBody, unused -> new DuplicateExpressionsContext());
        }
        return null;
    }

    @Nullable
    static DuplicateExpressionsContext getContext(@Nullable PsiCodeBlock body2, @NotNull UserDataHolder session) {
        Map contexts;
        if (session == null) {
            DuplicateExpressionsContext.$$$reportNull$$$0(2);
        }
        return (contexts = (Map)session.getUserData(CONTEXTS_KEY)) != null ? (DuplicateExpressionsContext)contexts.get(body2) : null;
    }

    static PsiCodeBlock findNearestBody(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            DuplicateExpressionsContext.$$$reportNull$$$0(3);
        }
        return (PsiCodeBlock)ObjectUtils.tryCast((Object)ControlFlowUtil.findCodeFragment((PsiElement)expression2), PsiCodeBlock.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/duplicateExpressions/DuplicateExpressionsContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findNearestBody";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

