/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;

public final class DeprecatedApiUsageProcessor
implements ApiUsageProcessor {
    private final ProblemsHolder myHolder;
    private final boolean myIgnoreInsideDeprecated;
    private final boolean myIgnoreAbstractDeprecatedOverrides;
    private final boolean myIgnoreImportStatements;
    private final boolean myIgnoreMethodsOfDeprecated;
    private final boolean myIgnoreInSameOutermostClass;
    private final boolean myForRemoval;
    private final ProblemHighlightType myHighlightType;

    public DeprecatedApiUsageProcessor(@NotNull ProblemsHolder holder, boolean ignoreInsideDeprecated, boolean ignoreAbstractDeprecatedOverrides, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, boolean ignoreInSameOutermostClass, boolean forRemoval, @Nullable HighlightSeverity severity) {
        if (holder == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
        this.myIgnoreInsideDeprecated = ignoreInsideDeprecated;
        this.myIgnoreAbstractDeprecatedOverrides = ignoreAbstractDeprecatedOverrides;
        this.myIgnoreImportStatements = ignoreImportStatements;
        this.myIgnoreMethodsOfDeprecated = ignoreMethodsOfDeprecated;
        this.myIgnoreInSameOutermostClass = ignoreInSameOutermostClass;
        this.myForRemoval = forRemoval;
        this.myHighlightType = forRemoval && severity == HighlightSeverity.ERROR ? ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL : ProblemHighlightType.LIKE_DEPRECATED;
    }

    @Override
    public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
        if (sourceNode == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(1);
        }
        if (target == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(2);
        }
        this.checkTargetDeprecated(sourceNode, target);
    }

    @Override
    public void processImportReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target) {
        if (sourceNode == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(3);
        }
        if (target == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(4);
        }
        this.checkTargetDeprecated(sourceNode, target);
    }

    private void checkTargetDeprecated(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target) {
        PsiElement elementToHighlight;
        if (sourceNode == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(5);
        }
        if (target == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(6);
        }
        if ((elementToHighlight = sourceNode.getSourcePsi()) != null) {
            this.checkTargetDeprecated(elementToHighlight, target);
        }
    }

    private void checkTargetDeprecated(@NotNull PsiElement elementToHighlight, @NotNull PsiModifierListOwner target) {
        if (elementToHighlight == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(7);
        }
        if (target == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(8);
        }
        DeprecationInspectionBase.checkDeprecated(target, elementToHighlight, null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, this.myIgnoreMethodsOfDeprecated, this.myIgnoreInSameOutermostClass, this.myHolder, this.myForRemoval, this.myHighlightType);
    }

    @Override
    public void processConstructorInvocation(@NotNull UElement sourceNode, @NotNull PsiClass instantiatedClass, @Nullable PsiMethod constructor, @Nullable UClass subclassDeclaration) {
        if (sourceNode == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(9);
        }
        if (instantiatedClass == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(10);
        }
        if (constructor != null && PsiImplUtil.isDeprecated((PsiElement)constructor) && this.myForRemoval == DeprecationInspectionBase.isForRemovalAttributeSet((PsiModifierListOwner)constructor)) {
            this.checkTargetDeprecated(sourceNode, (PsiModifierListOwner)constructor);
            return;
        }
        if (this.isDefaultConstructorDeprecated(instantiatedClass)) {
            PsiElement elementToHighlight = sourceNode.getSourcePsi();
            if (elementToHighlight == null) {
                return;
            }
            String description = JavaErrorMessages.message(this.myForRemoval ? "marked.for.removal.default.constructor" : "deprecated.default.constructor", instantiatedClass.getQualifiedName());
            this.myHolder.registerProblem(elementToHighlight, DeprecationInspectionBase.getDescription(description, this.myForRemoval, this.myHighlightType), this.myHighlightType, new LocalQuickFix[0]);
        }
    }

    @Override
    public void processMethodOverriding(@NotNull UMethod method, @NotNull PsiMethod overriddenMethod) {
        PsiClass aClass;
        if (method == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(11);
        }
        if (overriddenMethod == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(12);
        }
        if ((aClass = overriddenMethod.getContainingClass()) == null) {
            return;
        }
        PsiElement methodNameElement = UElementKt.getSourcePsiElement((UElement)method.getUastAnchor());
        if (methodNameElement == null) {
            return;
        }
        if (this.myIgnoreAbstractDeprecatedOverrides && !aClass.isDeprecated() && overriddenMethod.hasModifierProperty("abstract")) {
            return;
        }
        if (overriddenMethod.isDeprecated() && this.myForRemoval == DeprecationInspectionBase.isForRemovalAttributeSet((PsiModifierListOwner)overriddenMethod)) {
            String description = JavaErrorMessages.message(this.myForRemoval ? "overrides.marked.for.removal.method" : "overrides.deprecated.method", DeprecationInspectionBase.getPresentableName((PsiElement)aClass));
            this.myHolder.registerProblem(methodNameElement, DeprecationInspectionBase.getDescription(description, this.myForRemoval, this.myHighlightType), this.myHighlightType, new LocalQuickFix[0]);
        }
    }

    @Override
    public void processJavaModuleReference(@NotNull PsiJavaModuleReference javaModuleReference, @NotNull PsiJavaModule target) {
        if (javaModuleReference == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(13);
        }
        if (target == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(14);
        }
        this.checkTargetDeprecated(javaModuleReference.getElement(), (PsiModifierListOwner)target);
    }

    private boolean isDefaultConstructorDeprecated(@NotNull PsiClass aClass) {
        List externalDeprecated;
        if (aClass == null) {
            DeprecatedApiUsageProcessor.$$$reportNull$$$0(15);
        }
        return (externalDeprecated = ExternalAnnotationsManager.getInstance((Project)aClass.getProject()).findDefaultConstructorExternalAnnotations(aClass, "java.lang.Deprecated")) != null && ContainerUtil.exists((Iterable)externalDeprecated, annotation -> DeprecationInspectionBase.isForRemovalAttributeSet(annotation) == this.myForRemoval);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiatedClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriddenMethod";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModuleReference";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/deprecation/DeprecatedApiUsageProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processImportReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTargetDeprecated";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processConstructorInvocation";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processMethodOverriding";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processJavaModuleReference";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefaultConstructorDeprecated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

