/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.TransferTarget;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaValueFactory {
    private final List<DfaValue> myValues = new ArrayList<DfaValue>();
    final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myAssignableCache = new HashMap<Pair<DfaPsiType, DfaPsiType>, Boolean>();
    final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myConvertibleCache = new HashMap<Pair<DfaPsiType, DfaPsiType>, Boolean>();
    private final Map<PsiType, DfaPsiType> myDfaTypes = new HashMap<PsiType, DfaPsiType>();
    private final boolean myUnknownMembersAreNullable;
    private final FieldChecker myFieldChecker;
    private static final ElementPattern<? extends PsiModifierListOwner> MEMBER_OR_METHOD_PARAMETER = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiMember(), PsiJavaPatterns.psiParameter().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiMember())});
    private final Map<Pair<TransferTarget, FList<Trap>>, DfaControlTransferValue> myControlTransfers = FactoryMap.create(p -> new DfaControlTransferValue(this, (TransferTarget)p.first, (FList<Trap>)((FList)p.second)));
    private final DfaVariableValue.Factory myVarFactory;
    private final DfaConstValue.Factory myConstFactory;
    private final DfaBoxedValue.Factory myBoxedFactory;
    private final DfaBinOpValue.Factory myBinOpFactory;
    private final DfaRelationValue.Factory myRelationFactory;
    private final DfaExpressionFactory myExpressionFactory;
    private final DfaFactMapValue.Factory myFactFactory;

    public DfaValueFactory(@Nullable PsiElement context, boolean unknownMembersAreNullable) {
        this.myFieldChecker = new FieldChecker(context);
        this.myUnknownMembersAreNullable = unknownMembersAreNullable;
        this.myValues.add(null);
        this.myVarFactory = new DfaVariableValue.Factory(this);
        this.myConstFactory = new DfaConstValue.Factory(this);
        this.myBoxedFactory = new DfaBoxedValue.Factory(this);
        this.myRelationFactory = new DfaRelationValue.Factory(this);
        this.myExpressionFactory = new DfaExpressionFactory(this);
        this.myFactFactory = new DfaFactMapValue.Factory(this);
        this.myBinOpFactory = new DfaBinOpValue.Factory(this);
    }

    public boolean canTrustFieldInitializer(PsiField field) {
        return this.myFieldChecker.canTrustFieldInitializer(field);
    }

    @NotNull
    public Nullability suggestNullabilityForNonAnnotatedMember(@NotNull PsiModifierListOwner member) {
        if (member == null) {
            DfaValueFactory.$$$reportNull$$$0(0);
        }
        if (this.myUnknownMembersAreNullable && MEMBER_OR_METHOD_PARAMETER.accepts((Object)member) && AnnotationUtil.getSuperAnnotationOwners((PsiModifierListOwner)member).isEmpty()) {
            Nullability nullability = Nullability.NULLABLE;
            if (nullability == null) {
                DfaValueFactory.$$$reportNull$$$0(1);
            }
            return nullability;
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaValueFactory.$$$reportNull$$$0(2);
        }
        return nullability;
    }

    @NotNull
    public DfaValue createTypeValue(@Nullable PsiType type2, @NotNull Nullability nullability) {
        LongRangeSet range;
        if (nullability == null) {
            DfaValueFactory.$$$reportNull$$$0(3);
        }
        if (type2 == null) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaValueFactory.$$$reportNull$$$0(4);
            }
            return dfaUnknownValue;
        }
        if (type2 instanceof PsiPrimitiveType && (range = LongRangeSet.fromType(type2)) != null) {
            DfaValue dfaValue = this.getFactFactory().createValue(DfaFactType.RANGE, range);
            if (dfaValue == null) {
                DfaValueFactory.$$$reportNull$$$0(5);
            }
            return dfaValue;
        }
        DfaFactMap facts = DfaFactMap.EMPTY.with(DfaFactType.TYPE_CONSTRAINT, this.createDfaType(type2).asConstraint()).with(DfaFactType.NULLABILITY, DfaNullability.fromNullability(nullability));
        DfaValue dfaValue = this.getFactFactory().createValue(facts);
        if (dfaValue == null) {
            DfaValueFactory.$$$reportNull$$$0(6);
        }
        return dfaValue;
    }

    @NotNull
    public DfaValue createExactTypeValue(@Nullable PsiType type2) {
        if (type2 == null) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaValueFactory.$$$reportNull$$$0(7);
            }
            return dfaUnknownValue;
        }
        DfaFactMap facts = DfaFactMap.EMPTY.with(DfaFactType.TYPE_CONSTRAINT, TypeConstraint.exact(this.createDfaType(type2))).with(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL);
        DfaValue dfaValue = this.getFactFactory().createValue(facts);
        if (dfaValue == null) {
            DfaValueFactory.$$$reportNull$$$0(8);
        }
        return dfaValue;
    }

    @NotNull
    public <T> DfaValue withFact(@NotNull DfaValue value2, @NotNull DfaFactType<T> factType, @Nullable T factValue) {
        if (value2 == null) {
            DfaValueFactory.$$$reportNull$$$0(9);
        }
        if (factType == null) {
            DfaValueFactory.$$$reportNull$$$0(10);
        }
        if (value2 instanceof DfaUnknownValue) {
            DfaValue dfaValue = this.getFactFactory().createValue(DfaFactMap.EMPTY.with(factType, factValue));
            if (dfaValue == null) {
                DfaValueFactory.$$$reportNull$$$0(11);
            }
            return dfaValue;
        }
        if (value2 instanceof DfaFactMapValue) {
            DfaValue dfaValue = ((DfaFactMapValue)value2).withFact(factType, factValue);
            if (dfaValue == null) {
                DfaValueFactory.$$$reportNull$$$0(12);
            }
            return dfaValue;
        }
        DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
        if (dfaUnknownValue == null) {
            DfaValueFactory.$$$reportNull$$$0(13);
        }
        return dfaUnknownValue;
    }

    @NotNull
    public DfaPsiType createDfaType(@NotNull PsiType psiType) {
        DfaPsiType dfaType;
        if (psiType == null) {
            DfaValueFactory.$$$reportNull$$$0(14);
        }
        if ((dfaType = this.myDfaTypes.get(psiType = DfaPsiType.normalizeType(psiType))) == null) {
            dfaType = new DfaPsiType(this.myDfaTypes.size() + 1, psiType, this);
            this.myDfaTypes.put(psiType, dfaType);
        }
        DfaPsiType dfaPsiType = dfaType;
        if (dfaPsiType == null) {
            DfaValueFactory.$$$reportNull$$$0(15);
        }
        return dfaPsiType;
    }

    int registerValue(DfaValue value2) {
        this.myValues.add(value2);
        return this.myValues.size() - 1;
    }

    public DfaValue getValue(int id) {
        return this.myValues.get(id);
    }

    @NotNull
    public DfaPsiType getType(int id) {
        DfaPsiType dfaPsiType = (DfaPsiType)StreamEx.ofValues(this.myDfaTypes).findFirst(t -> t.getID() == id).orElseThrow(IllegalArgumentException::new);
        if (dfaPsiType == null) {
            DfaValueFactory.$$$reportNull$$$0(16);
        }
        return dfaPsiType;
    }

    @Nullable
    @Contract(value="null -> null")
    public DfaValue createValue(PsiExpression psiExpression) {
        return this.myExpressionFactory.getExpressionDfaValue(psiExpression);
    }

    @NotNull
    public DfaConstValue getInt(int value2) {
        DfaConstValue dfaConstValue = this.getConstFactory().createFromValue(value2, (PsiType)PsiType.INT);
        if (dfaConstValue == null) {
            DfaValueFactory.$$$reportNull$$$0(17);
        }
        return dfaConstValue;
    }

    @Nullable
    public DfaValue createLiteralValue(PsiLiteralExpression literal) {
        return this.getConstFactory().create(literal);
    }

    @NotNull
    public DfaValue createCondition(@NotNull DfaValue dfaLeft, @NotNull DfaRelationValue.RelationType relationType, @NotNull DfaValue dfaRight) {
        DfaConstValue value2;
        if (dfaLeft == null) {
            DfaValueFactory.$$$reportNull$$$0(18);
        }
        if (relationType == null) {
            DfaValueFactory.$$$reportNull$$$0(19);
        }
        if (dfaRight == null) {
            DfaValueFactory.$$$reportNull$$$0(20);
        }
        if ((value2 = this.tryEvaluate(dfaLeft, relationType, dfaRight)) != null) {
            DfaConstValue dfaConstValue = value2;
            if (dfaConstValue == null) {
                DfaValueFactory.$$$reportNull$$$0(21);
            }
            return dfaConstValue;
        }
        DfaRelationValue relation = this.getRelationFactory().createRelation(dfaLeft, relationType, dfaRight);
        if (relation != null) {
            DfaRelationValue dfaRelationValue = relation;
            if (dfaRelationValue == null) {
                DfaValueFactory.$$$reportNull$$$0(22);
            }
            return dfaRelationValue;
        }
        DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
        if (dfaUnknownValue == null) {
            DfaValueFactory.$$$reportNull$$$0(23);
        }
        return dfaUnknownValue;
    }

    @Nullable
    private DfaConstValue tryEvaluate(DfaValue dfaLeft, DfaRelationValue.RelationType relationType, DfaValue dfaRight) {
        DfaConstValue sentinel = this.getConstFactory().getSentinel();
        if (dfaLeft == sentinel != (dfaRight == sentinel)) {
            return this.getBoolean(relationType == DfaRelationValue.RelationType.NE);
        }
        if (dfaRight instanceof DfaFactMapValue && dfaLeft == this.getConstFactory().getNull()) {
            return this.tryEvaluate(dfaRight, relationType, dfaLeft);
        }
        if (dfaLeft instanceof DfaFactMapValue && dfaRight == this.getConstFactory().getNull() && DfaNullability.isNotNull(((DfaFactMapValue)dfaLeft).getFacts())) {
            if (relationType == DfaRelationValue.RelationType.EQ) {
                return this.getConstFactory().getFalse();
            }
            if (relationType == DfaRelationValue.RelationType.NE) {
                return this.getConstFactory().getTrue();
            }
        }
        if (dfaLeft instanceof DfaFactMapValue && dfaRight instanceof DfaFactMapValue && (relationType == DfaRelationValue.RelationType.IS || relationType == DfaRelationValue.RelationType.IS_NOT)) {
            boolean isDistinct;
            DfaFactMap leftFacts = ((DfaFactMapValue)dfaLeft).getFacts();
            DfaFactMap rightFacts = ((DfaFactMapValue)dfaRight).getFacts();
            boolean isSuperState = rightFacts.isSuperStateOf(leftFacts);
            if (isSuperState) {
                return this.getBoolean(relationType == DfaRelationValue.RelationType.IS);
            }
            boolean bl = isDistinct = rightFacts.intersect(leftFacts) == null;
            if (isDistinct) {
                return this.getBoolean(relationType == DfaRelationValue.RelationType.IS_NOT);
            }
        }
        LongRangeSet leftRange = LongRangeSet.fromDfaValue(dfaLeft);
        LongRangeSet rightRange = LongRangeSet.fromDfaValue(dfaRight);
        if (leftRange != null && rightRange != null) {
            LongRangeSet constraint = rightRange.fromRelation(relationType);
            if (constraint != null && !constraint.intersects(leftRange)) {
                return this.getConstFactory().getFalse();
            }
            LongRangeSet revConstraint = rightRange.fromRelation(relationType.getNegated());
            if (revConstraint != null && !revConstraint.intersects(leftRange)) {
                return this.getConstFactory().getTrue();
            }
        }
        if (dfaLeft instanceof DfaConstValue && dfaRight instanceof DfaConstValue && (relationType == DfaRelationValue.RelationType.EQ || relationType == DfaRelationValue.RelationType.NE)) {
            return this.getBoolean(dfaLeft == dfaRight ^ !DfaUtil.isNaN(((DfaConstValue)dfaLeft).getValue()) ^ relationType == DfaRelationValue.RelationType.EQ);
        }
        return null;
    }

    public DfaConstValue getBoolean(boolean value2) {
        return value2 ? this.getConstFactory().getTrue() : this.getConstFactory().getFalse();
    }

    public <T> DfaValue getFactValue(@NotNull DfaFactType<T> factType, @Nullable T value2) {
        if (factType == null) {
            DfaValueFactory.$$$reportNull$$$0(24);
        }
        return this.getFactFactory().createValue(factType, value2);
    }

    public Collection<DfaValue> getValues() {
        return Collections.unmodifiableCollection(this.myValues);
    }

    @NotNull
    public DfaControlTransferValue controlTransfer(TransferTarget kind2, FList<Trap> traps) {
        DfaControlTransferValue dfaControlTransferValue = this.myControlTransfers.get(Pair.create((Object)kind2, traps));
        if (dfaControlTransferValue == null) {
            DfaValueFactory.$$$reportNull$$$0(25);
        }
        return dfaControlTransferValue;
    }

    @NotNull
    public DfaVariableValue.Factory getVarFactory() {
        DfaVariableValue.Factory factory = this.myVarFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(26);
        }
        return factory;
    }

    @NotNull
    public DfaConstValue.Factory getConstFactory() {
        DfaConstValue.Factory factory = this.myConstFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(27);
        }
        return factory;
    }

    @NotNull
    public DfaBoxedValue.Factory getBoxedFactory() {
        DfaBoxedValue.Factory factory = this.myBoxedFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(28);
        }
        return factory;
    }

    @NotNull
    public DfaRelationValue.Factory getRelationFactory() {
        DfaRelationValue.Factory factory = this.myRelationFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(29);
        }
        return factory;
    }

    @NotNull
    public DfaFactMapValue.Factory getFactFactory() {
        DfaFactMapValue.Factory factory = this.myFactFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(30);
        }
        return factory;
    }

    @NotNull
    public DfaExpressionFactory getExpressionFactory() {
        DfaExpressionFactory dfaExpressionFactory = this.myExpressionFactory;
        if (dfaExpressionFactory == null) {
            DfaValueFactory.$$$reportNull$$$0(31);
        }
        return dfaExpressionFactory;
    }

    @NotNull
    public DfaBinOpValue.Factory getBinOpFactory() {
        DfaBinOpValue.Factory factory = this.myBinOpFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(32);
        }
        return factory;
    }

    @NotNull
    public DfaValue createCommonValue(@NotNull PsiExpression[] expressions2, PsiType targetType) {
        if (expressions2 == null) {
            DfaValueFactory.$$$reportNull$$$0(33);
        }
        DfaValue loopElement = null;
        for (PsiExpression expression2 : expressions2) {
            DfaValue expressionValue = this.createValue(expression2);
            if (expressionValue == null) {
                expressionValue = this.createTypeValue(expression2.getType(), NullabilityUtil.getExpressionNullability(expression2));
            }
            DfaValue dfaValue = loopElement = loopElement == null ? expressionValue : loopElement.unite(expressionValue);
            if (loopElement == DfaUnknownValue.getInstance()) break;
        }
        DfaValue dfaValue = loopElement == null ? DfaUnknownValue.getInstance() : DfaUtil.boxUnbox(loopElement, targetType);
        if (dfaValue == null) {
            DfaValueFactory.$$$reportNull$$$0(34);
        }
        return dfaValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaLeft";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRight";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNullabilityForNonAnnotatedMember";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createExactTypeValue";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withFact";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDfaType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInt";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createCondition";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "controlTransfer";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarFactory";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstFactory";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoxedFactory";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelationFactory";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactFactory";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionFactory";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinOpFactory";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommonValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestNullabilityForNonAnnotatedMember";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTypeValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withFact";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDfaType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCondition";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFactValue";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createCommonValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FieldChecker {
        private final boolean myTrustDirectFieldInitializers;
        private final boolean myTrustFieldInitializersInConstructors;
        private final boolean myCanInstantiateItself;
        private final PsiClass myClass;

        FieldChecker(PsiElement context) {
            PsiClass contextClass;
            PsiMethod method;
            PsiMethod psiMethod = method = context instanceof PsiClass ? null : (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class);
            this.myClass = contextClass = method != null ? method.getContainingClass() : (context instanceof PsiClass ? (PsiClass)context : null);
            if (method == null || this.myClass == null) {
                this.myCanInstantiateItself = false;
                this.myTrustFieldInitializersInConstructors = false;
                this.myTrustDirectFieldInitializers = false;
                return;
            }
            ClassInitializationInfo info = (ClassInitializationInfo)CachedValuesManager.getCachedValue((PsiElement)contextClass, () -> CachedValueProvider.Result.create((Object)new ClassInitializationInfo(contextClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            this.myCanInstantiateItself = info.myCanInstantiateItself;
            if (method.hasModifierProperty("static") || method.isConstructor()) {
                this.myTrustDirectFieldInitializers = true;
                this.myTrustFieldInitializersInConstructors = false;
                return;
            }
            this.myTrustFieldInitializersInConstructors = !info.mySuperCtorsCallMethods && !info.myCtorsCallMethods;
            this.myTrustDirectFieldInitializers = !info.mySuperCtorsCallMethods;
        }

        boolean canTrustFieldInitializer(PsiField field) {
            if (field.hasInitializer()) {
                boolean staticField = field.hasModifierProperty("static");
                if (staticField && this.myClass != null && field.getContainingClass() != this.myClass) {
                    return true;
                }
                return this.myTrustDirectFieldInitializers && (!this.myCanInstantiateItself || !staticField);
            }
            return this.myTrustFieldInitializersInConstructors;
        }
    }

    private static class ClassInitializationInfo {
        final boolean myCanInstantiateItself;
        final boolean myCtorsCallMethods;
        final boolean mySuperCtorsCallMethods;

        ClassInitializationInfo(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                ClassInitializationInfo.$$$reportNull$$$0(0);
            }
            this.myCanInstantiateItself = ((StreamEx)StreamEx.of((Object[])psiClass.getChildren()).select(PsiMember.class).filter(member -> member.hasModifierProperty("static"))).flatMap(member -> StreamEx.ofTree((Object)member, e -> StreamEx.of((Object[])e.getChildren()))).select(PsiNewExpression.class).map(PsiNewExpression::getClassReference).nonNull().anyMatch(classRef -> classRef.isReferenceTo((PsiElement)psiClass));
            this.mySuperCtorsCallMethods = !InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)false, superClass -> !ClassInitializationInfo.canCallMethodsInConstructors(superClass, true));
            this.myCtorsCallMethods = ClassInitializationInfo.canCallMethodsInConstructors(psiClass, false);
        }

        private static boolean canCallMethodsInConstructors(@NotNull PsiClass aClass, boolean virtual) {
            if (aClass == null) {
                ClassInitializationInfo.$$$reportNull$$$0(1);
            }
            for (PsiMethod constructor : aClass.getConstructors()) {
                if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                    return true;
                }
                PsiCodeBlock body2 = constructor.getBody();
                if (body2 == null) continue;
                for (PsiMethodCallExpression call : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)body2)).filter(PsiMethodCallExpression.class)) {
                    PsiReferenceExpression methodExpression = call.getMethodExpression();
                    if (methodExpression.textMatches((CharSequence)"this") || methodExpression.textMatches((CharSequence)"super")) continue;
                    if (!virtual) {
                        return true;
                    }
                    PsiMethod target = call.resolveMethod();
                    if (target == null || !PsiUtil.canBeOverridden((PsiMethod)target)) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory$ClassInitializationInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canCallMethodsInConstructors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

